/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.event.UIEvents;
import com.vaadin.navigator.View;
import com.vaadin.server.Responsive;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.PostConstruct;
import org.openthinclient.api.proc.RuntimeProcessExecutor;
import org.openthinclient.api.versioncheck.AvailableVersionChecker;
import org.openthinclient.api.versioncheck.UpdateDescriptor;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.progress.NoopProgressReceiver;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.component.NotificationDialog;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.ViewHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="support")
@SideBarItem(sectionId="support", captionCode="UI_SUPPORT_APPLICATION_HEADER", order=10)
public class UpdateManagerView
extends Panel
implements View {
    private static final long serialVersionUID = -8836300902351197949L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateManagerView.class);
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private DownloadManager downloadManager;
    @Value(value="${application.version}")
    private String applicationVersion;
    @Value(value="${otc.application.version.update.location}")
    private String updateLocation;
    @Value(value="${otc.application.version.update.process}")
    private String updateProcess;
    final MessageConveyor mc;
    final VerticalLayout root;
    private VerticalLayout content = null;
    private Button button = null;
    private ProgressBar bar = null;
    private Label labelUpdateProgress = null;
    private ProcessStatus processStatus = ProcessStatus.UNSET;

    public UpdateManagerView() {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addStyleName("borderless");
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.root.addStyleName("dashboard-view");
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
        this.root.addComponent((Component)new ViewHeader(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CONSOLE_ABOUT_HEADER, new Object[0])));
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        if (UI.getCurrent().getSession().getAttribute("processStatus") != null) {
            this.processStatus = (ProcessStatus)((Object)UI.getCurrent().getSession().getAttribute("processStatus"));
        }
        this.buildContent();
    }

    private void buildContent() {
        this.content = new VerticalLayout();
        Label labelDescription = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CURRENT_APPLICATION_VERSION, new Object[]{this.applicationVersion}), ContentMode.HTML);
        this.content.addComponent((Component)labelDescription);
        if (this.processStatus == ProcessStatus.RUNNING) {
            this.handleUpdateInProgress();
        } else {
            this.updateView();
        }
        this.root.addComponent((Component)this.content);
        this.root.setExpandRatio((Component)this.content, 1.0f);
    }

    private void buildUpdateCheckView() {
        this.button = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_BUTTON, new Object[0]));
        this.button.addClickListener((Button.ClickListener & Serializable)e -> {
            AvailableVersionChecker avc = new AvailableVersionChecker(this.managerHome, this.downloadManager);
            try {
                NotificationDialog notification;
                UpdateDescriptor versionDescriptor = avc.getVersion(new URI(this.updateLocation), (ProgressReceiver)new NoopProgressReceiver());
                Version newVersion = Version.parse((String)versionDescriptor.getNewVersion());
                Version currentVersion = Version.parse((String)this.applicationVersion);
                int result = currentVersion.compareTo((Object)newVersion);
                if (result < 0) {
                    notification = new NotificationDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_CAPTION, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_UPDATE, new Object[]{versionDescriptor.getNewVersion()}), NotificationDialog.NotificationDialogType.PLAIN);
                    Button updateBtn = new Button("Update");
                    PackageManagerConfiguration configuration = (PackageManagerConfiguration)this.managerHome.getConfiguration(PackageManagerConfiguration.class);
                    updateBtn.addClickListener((Button.ClickListener & Serializable)event -> {
                        updateBtn.setEnabled(false);
                        RuntimeProcessExecutor.executeManagerUpdateCheck((String)this.updateProcess, (NetworkConfiguration.ProxyConfiguration)configuration.getProxyConfiguration(), (RuntimeProcessExecutor.Callback)new RuntimeProcessExecutor.Callback(){

                            public void exited(int exitValue) {
                                UpdateManagerView.this.setStatus(ProcessStatus.EXIT);
                            }

                            public void prepareShutdown() {
                                UpdateManagerView.this.setStatus(ProcessStatus.SUCCESS);
                            }

                            public void started() {
                                UpdateManagerView.this.setStatus(ProcessStatus.RUNNING);
                                UpdateManagerView.this.handleUpdateInProgress();
                            }
                        });
                        notification.close();
                        UI.getCurrent().setPollInterval(500);
                        UI.getCurrent().addPollListener((UIEvents.PollListener & Serializable)pollEvent -> this.updateView());
                    });
                    notification.addContent((Component)updateBtn);
                } else {
                    notification = new NotificationDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_CAPTION, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_OK, new Object[0]), NotificationDialog.NotificationDialogType.SUCCESS);
                }
                notification.open(false);
            }
            catch (Exception exception) {
                NotificationDialog notification = new NotificationDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_CAPTION, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_CHECK_APPLICATION_VERSION_NOTIFICATION_FAIL, new Object[0]), NotificationDialog.NotificationDialogType.ERROR);
                notification.open(false);
                return;
            }
        });
        this.content.addComponent((Component)this.button);
    }

    private void setStatus(ProcessStatus status) {
        this.processStatus = status;
        UI.getCurrent().getSession().setAttribute("processStatus", (Object)this.processStatus);
    }

    private void updateView() {
        LOGGER.debug("Update view for status {}", (Object)this.processStatus);
        switch (this.processStatus) {
            case UNSET: {
                this.buildUpdateCheckView();
                break;
            }
            case SUCCESS: {
                this.handleUpdateSuccess();
                this.setStatus(ProcessStatus.UNSET);
                break;
            }
            case EXIT: {
                this.handleUpdateFailed();
                this.setStatus(ProcessStatus.UNSET);
            }
        }
    }

    private void handleUpdateInProgress() {
        if (this.button != null) {
            this.content.removeComponent((Component)this.button);
        }
        this.labelUpdateProgress = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_RUNNING, new Object[0]), ContentMode.HTML);
        this.content.addComponent((Component)this.labelUpdateProgress);
        this.bar = new ProgressBar();
        this.bar.setIndeterminate(true);
        this.content.addComponent((Component)this.bar);
    }

    private void handleUpdateFailed() {
        if (this.button != null) {
            this.content.removeComponent((Component)this.button);
        }
        if (this.labelUpdateProgress != null) {
            this.content.removeComponent((Component)this.labelUpdateProgress);
        }
        if (this.bar != null) {
            this.content.removeComponent((Component)this.bar);
        }
        this.content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_EXIT, new Object[0]), ContentMode.HTML));
        UI.getCurrent().setPollInterval(-1);
    }

    private void handleUpdateSuccess() {
        if (this.button != null) {
            this.content.removeComponent((Component)this.button);
        }
        if (this.labelUpdateProgress != null) {
            this.content.removeComponent((Component)this.labelUpdateProgress);
        }
        if (this.bar != null) {
            this.content.removeComponent((Component)this.bar);
        }
        this.content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_APPLICATION_UPDATE_SUCCESS, new Object[0]), ContentMode.HTML));
        UI.getCurrent().setPollInterval(-1);
    }

    static enum ProcessStatus {
        UNSET,
        RUNNING,
        EXIT,
        SUCCESS;

    }
}

