/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.annotations.Theme;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Locale;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.vaadin.spring.security.shared.VaadinSharedSecurity;

@SpringUI(path="/login")
@Theme(value="dashboard")
public class LoginUI
extends UI {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginUI.class);
    @Autowired
    VaadinSharedSecurity vaadinSecurity;
    private IMessageConveyor mc;
    private CheckBox rememberMe;

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(ConsoleWebMessages.class, (Locale)UI.getCurrent().getLocale()));
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        Component loginForm = this.buildLoginForm();
        VerticalLayout rootLayout = new VerticalLayout(new Component[]{loginForm});
        rootLayout.setSizeFull();
        rootLayout.setComponentAlignment(loginForm, Alignment.MIDDLE_CENTER);
        this.setContent((Component)rootLayout);
        this.setSizeFull();
    }

    private Component buildLoginForm() {
        VerticalLayout loginPanel = new VerticalLayout();
        loginPanel.setSizeUndefined();
        Responsive.makeResponsive((Component[])new Component[]{loginPanel});
        loginPanel.addStyleName("login-panel");
        loginPanel.addComponent(this.buildLabels());
        final Label loginFailed = new Label();
        loginFailed.setStyleName("login-failed");
        loginFailed.setVisible(false);
        loginPanel.addComponents(new Component[]{loginFailed});
        HorizontalLayout fields = new HorizontalLayout();
        fields.setSpacing(true);
        fields.addStyleName("fields");
        final TextField username = new TextField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_USERNAME, new Object[0]));
        username.setIcon((Resource)FontAwesome.USER);
        username.addStyleName("inline-icon");
        final PasswordField password = new PasswordField(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_PASSWORD, new Object[0]));
        password.setIcon((Resource)FontAwesome.LOCK);
        password.addStyleName("inline-icon");
        Button signin = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_LOGIN, new Object[0]));
        signin.addStyleName("primary");
        signin.setClickShortcut(13, new int[0]);
        signin.focus();
        signin.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
                try {
                    Authentication authentication = LoginUI.this.vaadinSecurity.login(username.getValue().toLowerCase(), password.getValue(), LoginUI.this.rememberMe.getValue().booleanValue());
                    LOGGER.debug("Received UserLoginRequestedEvent for ", authentication.getPrincipal());
                }
                catch (AccessDeniedException | AuthenticationException ex) {
                    loginFailed.getParent().addStyleName("failed");
                    loginFailed.setValue(mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDUI_LOGIN_FAILED, new Object[0]));
                    loginFailed.setVisible(true);
                }
                catch (Exception ex) {
                    loginFailed.getParent().getParent().addStyleName("error");
                    loginFailed.setValue(mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDUI_LOGIN_UNEXPECTED_ERROR, new Object[0]));
                    loginFailed.setVisible(true);
                    LOGGER.error("Unexpected error while logging in", (Throwable)ex);
                }
            }
        });
        fields.addComponents(new Component[]{username, password, signin});
        fields.setComponentAlignment((Component)signin, Alignment.BOTTOM_LEFT);
        loginPanel.addComponent((Component)fields);
        this.rememberMe = new CheckBox(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_REMEMBERME, new Object[0]), false);
        loginPanel.addComponent((Component)this.rememberMe);
        return loginPanel;
    }

    private Component buildLabels() {
        CssLayout labels = new CssLayout();
        labels.addStyleName("labels");
        Label welcome = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_WELCOME, new Object[0]));
        welcome.setSizeUndefined();
        welcome.addStyleName("h4");
        welcome.addStyleName("colored");
        labels.addComponent((Component)welcome);
        Label title = new Label("openthinclient.org");
        title.setSizeUndefined();
        title.addStyleName("h3");
        title.addStyleName("light");
        labels.addComponent((Component)title);
        return labels;
    }
}

