/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.Page;
import com.vaadin.server.Responsive;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.annotation.SpringViewDisplay;
import com.vaadin.spring.navigator.SpringViewProvider;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.Registration;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.event.PackageManagerTaskActivatedEvent;
import org.openthinclient.web.ui.event.PackageManagerTaskFinalizedEvent;
import org.openthinclient.web.view.AccessDeniedView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.security.VaadinSecurity;
import org.vaadin.spring.sidebar.components.ValoSideBar;

@Theme(value="dashboard")
@Title(value="openthinclient.org")
@SpringUI
@SpringViewDisplay
public final class ManagerUI
extends UI
implements ViewDisplay {
    private static final long serialVersionUID = 4314279050575370517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerUI.class);
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    VaadinSecurity vaadinSecurity;
    @Autowired
    SpringViewProvider viewProvider;
    @Autowired
    ValoSideBar sideBar;
    @Autowired
    PackageManagerExecutionEngine packageManagerExecutionEngine;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    @Autowired
    SpringViewProvider springViewProvider;
    private Registration taskFinalizedRegistration;
    private Registration taskActivatedRegistration;
    private Panel springViewDisplay;

    protected void onPackageManagerTaskFinalized(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskFinalizedEvent(this.packageManagerExecutionEngine));
    }

    protected void onPackageManagerTaskActivated(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskActivatedEvent(this.packageManagerExecutionEngine));
    }

    @PostConstruct
    public void init() {
        this.springViewProvider.setAccessDeniedViewClass(AccessDeniedView.class);
    }

    public void showView(View view) {
        this.springViewDisplay.setContent((Component)view);
    }

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(ConsoleWebMessages.class, (Locale)UI.getCurrent().getLocale()));
        Responsive.makeResponsive((Component[])new Component[]{this});
        this.addStyleName("valo-menu-responsive");
        Page.getCurrent().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener & Serializable)event -> this.eventBus.publish((Object)this, (Object)new DashboardEvent.BrowserResizeEvent(event.getHeight(), event.getWidth())));
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        Page.getCurrent().setTitle(mc.getMessage((Enum)ConsoleWebMessages.UI_PAGE_TITLE, new Object[0]));
        this.taskActivatedRegistration = this.packageManagerExecutionEngine.addTaskActivatedHandler(this::onPackageManagerTaskActivated);
        this.taskFinalizedRegistration = this.packageManagerExecutionEngine.addTaskFinalizedHandler(this::onPackageManagerTaskFinalized);
        this.showMainScreen();
    }

    private void showMainScreen() {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setSizeFull();
        hl.addStyleName("mainview");
        this.sideBar.setId("dashboard-menu");
        this.sideBar.setHeader(this.buildHeader());
        hl.addComponent((Component)this.sideBar);
        CssLayout content = new CssLayout();
        content.addStyleName("view-content");
        content.setSizeFull();
        hl.addComponent((Component)content);
        hl.setExpandRatio((Component)content, 1.0f);
        Navigator navigator = new Navigator(UI.getCurrent(), (ComponentContainer)content);
        navigator.addProvider((ViewProvider)this.viewProvider);
        if (navigator.getState().isEmpty()) {
            navigator.navigateTo("");
        } else {
            navigator.navigateTo(navigator.getState());
        }
        this.setContent((Component)hl);
    }

    private Layout buildHeader() {
        Label logo = new Label("openthinclient.org <strong>Manager</strong>", ContentMode.HTML);
        logo.setSizeUndefined();
        HorizontalLayout logoWrapper = new HorizontalLayout(new Component[]{logo});
        logoWrapper.setComponentAlignment((Component)logo, Alignment.MIDDLE_CENTER);
        return logoWrapper;
    }

    @EventBusListenerMethod
    public void userLoggedOut(DashboardEvent.UserLoggedOutEvent event) {
        LOGGER.debug("Received UserLoggedOutEvent for ", SecurityContextHolder.getContext().getAuthentication().getPrincipal());
        VaadinSession.getCurrent().close();
        SecurityContextHolder.getContext().setAuthentication(null);
        this.vaadinSecurity.logout();
    }

    @EventBusListenerMethod
    public void closeOpenWindows(DashboardEvent.CloseOpenWindowsEvent event) {
        for (Window window : this.getWindows()) {
            window.close();
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.taskActivatedRegistration.unregister();
        this.taskFinalizedRegistration.unregister();
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }
}

