/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.DefaultErrorHandler;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.Sparklines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHeader
extends VerticalLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewHeader.class);
    public static final String TITLE_ID = "dashboard-title";
    private final HorizontalLayout tools;
    private final Label titleLabel;

    public ViewHeader(boolean showSparklines) {
        this.setMargin(false);
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        HorizontalLayout head = new HorizontalLayout();
        head.setMargin(false);
        head.setSpacing(false);
        head.addStyleName("viewheader");
        this.titleLabel = new Label();
        this.titleLabel.setId(TITLE_ID);
        this.titleLabel.setSizeUndefined();
        this.titleLabel.addStyleName("h1");
        this.titleLabel.addStyleName("no-margin");
        head.addComponent((Component)this.titleLabel);
        this.tools = new HorizontalLayout();
        this.tools.setSpacing(true);
        this.tools.addStyleName("toolbar");
        head.addComponent((Component)this.tools);
        this.addComponent((Component)head);
        if (showSparklines) {
            this.addComponent((Component)new Sparklines());
        }
        UI.getCurrent().setErrorHandler((ErrorHandler)new DefaultErrorHandler((IMessageConveyor)mc){
            final /* synthetic */ IMessageConveyor val$mc;
            {
                this.val$mc = iMessageConveyor;
            }

            public void error(ErrorEvent event) {
                LOGGER.error("Caught unexpected error.", event.getThrowable());
                Label errorMessage = new Label(this.val$mc.getMessage((Enum)ConsoleWebMessages.UI_UNEXPECTED_ERROR, new Object[0]), ContentMode.HTML);
                errorMessage.addStyleName("unexpected_error");
                ViewHeader.this.addComponent((Component)errorMessage);
            }
        });
    }

    public ViewHeader(String title) {
        this(true);
        this.setTitle(title);
    }

    public ViewHeader(String title, boolean showSparklines) {
        this(showSparklines);
        this.setTitle(title);
    }

    public void addTool(Component component) {
        this.tools.addComponent(component);
    }

    public void addTools(Component ... components) {
        this.tools.addComponents(components);
    }

    public void removeTool(Component component) {
        this.tools.removeComponent(component);
    }

    public String getTitle() {
        return this.titleLabel.getValue();
    }

    public void setTitle(String title) {
        this.titleLabel.setValue(title);
    }
}

