/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.view.dashboard;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.event.LayoutEvents;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.openthinclient.web.domain.DashboardNotification;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.DashboardPanel;
import org.openthinclient.web.ui.ViewHeader;
import org.openthinclient.web.view.dashboard.DashboardNotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="")
@SideBarItem(sectionId="common", caption="Dashboard", order=1)
public class DashboardView
extends Panel
implements View {
    public static final String NAME = "";
    final IMessageConveyor mc;
    private final VerticalLayout root;
    private final EventBus.SessionEventBus eventBus;
    private final DashboardNotificationService notificationService;
    private Label titleLabel;
    private NotificationsButton notificationsButton;
    private CssLayout dashboardPanels;
    private Window notificationsWindow;

    @Autowired
    public DashboardView(final EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.eventBus = eventBus;
        this.notificationService = notificationService;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.addStyleName("borderless");
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.root.addStyleName("dashboard-view");
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
        this.root.addComponent(this.buildHeader());
        Component content = this.buildContent();
        this.root.addComponent(content);
        this.root.setExpandRatio(content, 1.0f);
        this.root.addLayoutClickListener(new LayoutEvents.LayoutClickListener(){

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                eventBus.publish((Object)this, (Object)new DashboardEvent.CloseOpenWindowsEvent());
            }
        });
    }

    private Component buildHeader() {
        ViewHeader header = new ViewHeader("Dashboard");
        this.notificationsButton = this.buildNotificationsButton();
        LogoutButton logout = this.buildLogoutButton();
        return header;
    }

    private NotificationsButton buildNotificationsButton() {
        NotificationsButton result = new NotificationsButton(this.notificationService);
        result.addClickListener(this::openNotificationsPopup);
        return result;
    }

    private LogoutButton buildLogoutButton() {
        LogoutButton result = new LogoutButton();
        result.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                DashboardView.this.eventBus.publish((Object)this, (Object)new DashboardEvent.UserLoggedOutEvent());
            }
        });
        return result;
    }

    private Component buildContent() {
        this.dashboardPanels = new CssLayout();
        this.dashboardPanels.addStyleName("dashboard-panels");
        Responsive.makeResponsive((Component[])new Component[]{this.dashboardPanels});
        DashboardPanel helpPanel = new DashboardPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_TITLE, new Object[0]), (Resource)new ThemeResource("icon/help.svg"));
        helpPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_CONTENT, new Object[0]), ContentMode.HTML));
        DashboardPanel otcPanel = new DashboardPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_OTC_TITLE, new Object[0]), (Resource)new ThemeResource("icon/logo.svg"));
        otcPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_OTC_CONTENT, new Object[0]), ContentMode.HTML));
        DashboardPanel toolsPanel = new DashboardPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_TITLE, new Object[0]), (Resource)new ThemeResource("icon/meter.svg"));
        toolsPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_CONTENT, new Object[0]), ContentMode.HTML));
        this.dashboardPanels.addComponents(new Component[]{helpPanel, otcPanel, toolsPanel});
        return this.dashboardPanels;
    }

    private void openNotificationsPopup(Button.ClickEvent event) {
        VerticalLayout notificationsLayout = new VerticalLayout();
        notificationsLayout.setMargin(true);
        notificationsLayout.setSpacing(true);
        Label title = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_NOTIFOCATIONS_CAPTION, new Object[0]));
        title.addStyleName("h3");
        title.addStyleName("no-margin");
        notificationsLayout.addComponent((Component)title);
        List<DashboardNotification> notifications = this.notificationService.getNotifications();
        this.eventBus.publish((Object)this, (Object)new DashboardEvent.NotificationsCountUpdatedEvent());
        for (DashboardNotification notification : notifications) {
            VerticalLayout notificationLayout = new VerticalLayout();
            notificationLayout.addStyleName("notification-item");
            Label titleLabel = new Label(notification.getFirstName() + " " + notification.getLastName() + " " + notification.getAction());
            titleLabel.addStyleName("notification-title");
            Label timeLabel = new Label(notification.getPrettyTime());
            timeLabel.addStyleName("notification-time");
            Label contentLabel = new Label(notification.getContent());
            contentLabel.addStyleName("notification-content");
            notificationLayout.addComponents(new Component[]{titleLabel, timeLabel, contentLabel});
            notificationsLayout.addComponent((Component)notificationLayout);
        }
        HorizontalLayout footer = new HorizontalLayout();
        footer.addStyleName("v-window-bottom-toolbar");
        footer.setWidth("100%");
        Button showAll = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_NOTIFOCATIONS_VIEWALL, new Object[0]), (Button.ClickListener & Serializable)e -> Notification.show((String)this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_NOT_IMPLEMENTED, new Object[0])));
        showAll.addStyleName("borderless-colored");
        showAll.addStyleName("small");
        footer.addComponent((Component)showAll);
        footer.setComponentAlignment((Component)showAll, Alignment.TOP_CENTER);
        notificationsLayout.addComponent((Component)footer);
        if (this.notificationsWindow == null) {
            this.notificationsWindow = new Window();
            this.notificationsWindow.setWidth(300.0f, Sizeable.Unit.PIXELS);
            this.notificationsWindow.addStyleName("notifications");
            this.notificationsWindow.setClosable(false);
            this.notificationsWindow.setResizable(false);
            this.notificationsWindow.setDraggable(false);
            this.notificationsWindow.setCloseShortcut(27, null);
            this.notificationsWindow.setContent((Component)notificationsLayout);
        }
        if (!this.notificationsWindow.isAttached()) {
            this.notificationsWindow.setPositionY(event.getClientY() - event.getRelativeY() + 40);
            this.getUI().addWindow(this.notificationsWindow);
            this.notificationsWindow.focus();
        } else {
            this.notificationsWindow.close();
        }
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.notificationsButton.updateNotificationsCount(null);
    }

    private void toggleMaximized(Component panel, boolean maximized) {
        Iterator it = this.root.iterator();
        while (it.hasNext()) {
            ((Component)it.next()).setVisible(!maximized);
        }
        this.dashboardPanels.setVisible(true);
        for (Component c : this.dashboardPanels) {
            c.setVisible(!maximized);
        }
        if (maximized) {
            panel.setVisible(true);
            panel.addStyleName("max");
        } else {
            panel.removeStyleName("max");
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    public static final class LogoutButton
    extends Button {
        public static final String ID = "dashboard-logout";

        public LogoutButton() {
            this.setIcon((Resource)FontAwesome.SIGN_OUT);
            this.setId(ID);
            this.addStyleName("logout");
            this.addStyleName("icon-only");
        }
    }

    public static final class NotificationsButton
    extends Button {
        public static final String ID = "dashboard-notifications";
        private static final String STYLE_UNREAD = "unread";
        private final DashboardNotificationService notificationService;

        public NotificationsButton(DashboardNotificationService notificationService) {
            this.notificationService = notificationService;
            this.setIcon((Resource)FontAwesome.BELL);
            this.setId(ID);
            this.addStyleName("notifications");
            this.addStyleName("icon-only");
        }

        @EventBusListenerMethod
        public void updateNotificationsCount(DashboardEvent.NotificationsCountUpdatedEvent event) {
            this.setUnreadCount(this.notificationService.getUnreadNotificationsCount());
        }

        public void setUnreadCount(int count) {
            this.setCaption(String.valueOf(count));
            String description = "Notifications";
            if (count > 0) {
                this.addStyleName(STYLE_UNREAD);
                description = description + " (" + count + " unread)";
            } else {
                this.removeStyleName(STYLE_UNREAD);
            }
            this.setDescription(description);
            this.setVisible(count != 0);
        }
    }
}

