/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.fields;

import com.vaadin.data.HasValue;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.Registration;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.TextField;
import java.util.EventObject;
import org.vaadin.viritin.fluency.ui.FluentCustomField;
import org.vaadin.viritin.util.HtmlElementPropertySetter;

public abstract class AbstractNumberField<S extends AbstractNumberField<S, T>, T>
extends CustomField<T>
implements FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier,
FluentCustomField<S, T> {
    private static final long serialVersionUID = 5925606478174987241L;
    private String htmlFieldType = "number";
    protected TextField tf = new TextField(){
        private static final long serialVersionUID = 6823601969399906594L;

        public void beforeClientResponse(boolean initial) {
            super.beforeClientResponse(initial);
            AbstractNumberField.this.configureHtmlElement();
        }
    };
    protected HtmlElementPropertySetter s = new HtmlElementPropertySetter((AbstractComponent)this.tf);
    protected HasValue.ValueChangeListener<String> vcl = new HasValue.ValueChangeListener<String>(){
        private static final long serialVersionUID = 5034199201545161061L;

        public void valueChange(HasValue.ValueChangeEvent<String> event) {
            Object old = AbstractNumberField.this.getValue();
            String value = (String)event.getValue();
            if (value != null) {
                AbstractNumberField.this.userInputToValue(value);
                AbstractNumberField.this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)AbstractNumberField.this, old, true));
            } else {
                AbstractNumberField.this.setValue(null);
            }
        }
    };

    protected void configureHtmlElement() {
        this.s.setProperty("type", this.getHtmlFieldType());
        this.s.setJavaScriptEventHandler("keypress", "function(e) {var c = viritin.getChar(e); return c==null || /^[-\\d\\n\\t\\r]+$/.test(c);}");
    }

    protected abstract void userInputToValue(String var1);

    protected Component initContent() {
        this.tf.addValueChangeListener(this.vcl);
        return this.tf;
    }

    protected void doSetValue(T value) {
        if (value == null) {
            this.tf.setValue(null);
        } else {
            this.tf.setValue(this.valueToPresentation(value));
        }
    }

    protected String valueToPresentation(T newValue) {
        return newValue.toString();
    }

    public String getHtmlFieldType() {
        return this.htmlFieldType;
    }

    public void setHtmlFieldType(String htmlFieldType) {
        this.htmlFieldType = htmlFieldType;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tf.setEnabled(enabled);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.tf.setReadOnly(readOnly);
    }

    public void setWidth(float width, Sizeable.Unit unit) {
        super.setWidth(width, unit);
        if (this.tf != null) {
            if (width != -1.0f) {
                this.tf.setWidth("100%");
            } else {
                this.tf.setWidth(null);
            }
        }
    }

    public Registration addBlurListener(FieldEvents.BlurListener listener) {
        return this.tf.addBlurListener(listener);
    }

    public Registration addFocusListener(FieldEvents.FocusListener listener) {
        return this.tf.addFocusListener(listener);
    }

    public AbstractNumberField<S, T> withBlurListener(FieldEvents.BlurListener listener) {
        this.addBlurListener(listener);
        return this;
    }

    public AbstractNumberField<S, T> withFocusListener(FieldEvents.FocusListener listener) {
        this.addFocusListener(listener);
        return this;
    }
}

