/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.viritin.v7.BeanBinder;
import org.vaadin.viritin.v7.MBeanFieldGroup;

public abstract class AbstractElementCollection<ET>
extends CustomField<Collection> {
    private static final long serialVersionUID = 7785110162928180695L;
    private static final Method addedMethod = ReflectTools.findMethod(ElementAddedListener.class, (String)"elementAdded", (Class[])new Class[]{ElementAddedEvent.class});
    private static final Method removedMethod = ReflectTools.findMethod(ElementRemovedListener.class, (String)"elementRemoved", (Class[])new Class[]{ElementRemovedEvent.class});
    private Instantiator<ET> instantiator;
    private Instantiator<?> oldEditorInstantiator;
    private EditorInstantiator<?, ET> newEditorInstantiator;
    private final Class<ET> elementType;
    private final Class<?> editorType;
    protected ET newInstance;
    private final MBeanFieldGroup.FieldGroupListener fieldGroupListener = new MBeanFieldGroup.FieldGroupListener(){
        private static final long serialVersionUID = 2498166986711639744L;

        public void onFieldGroupChange(MBeanFieldGroup beanFieldGroup) {
            if (beanFieldGroup.getItemDataSource().getBean() == AbstractElementCollection.this.newInstance) {
                if (!AbstractElementCollection.this.getFieldGroupFor(AbstractElementCollection.this.newInstance).isValid()) {
                    return;
                }
                AbstractElementCollection.this.getAndEnsureValue().add(AbstractElementCollection.this.newInstance);
                AbstractElementCollection.this.fireEvent(new ElementAddedEvent(AbstractElementCollection.this, AbstractElementCollection.this.newInstance));
                AbstractElementCollection.this.setPersisted(AbstractElementCollection.this.newInstance, true);
                AbstractElementCollection.this.onElementAdded();
            }
            AbstractElementCollection.this.fireValueChange(false);
        }
    };
    private List<String> visibleProperties;
    private boolean allowNewItems = true;
    private boolean allowRemovingItems = true;
    private boolean allowEditItems = true;
    private final Map<ET, EditorStuff> pojoToEditor = new IdentityHashMap<ET, EditorStuff>();
    private final Map<String, String> propertyToHeader = new HashMap<String, String>();

    public AbstractElementCollection<ET> addElementAddedListener(ElementAddedListener<ET> listener) {
        this.addListener(ElementAddedEvent.class, listener, addedMethod);
        return this;
    }

    public AbstractElementCollection<ET> removeElementAddedListener(ElementAddedListener listener) {
        this.removeListener(ElementAddedEvent.class, listener, addedMethod);
        return this;
    }

    public AbstractElementCollection<ET> addElementRemovedListener(ElementRemovedListener<ET> listener) {
        this.addListener(ElementRemovedEvent.class, listener, removedMethod);
        return this;
    }

    public AbstractElementCollection<ET> removeElementRemovedListener(ElementRemovedListener listener) {
        this.removeListener(ElementRemovedEvent.class, listener, removedMethod);
        return this;
    }

    public boolean isAllowNewItems() {
        return this.allowNewItems;
    }

    public boolean isAllowRemovingItems() {
        return this.allowRemovingItems;
    }

    public boolean isAllowEditItems() {
        return this.allowEditItems;
    }

    public AbstractElementCollection<ET> setAllowEditItems(boolean allowEditItems) {
        this.allowEditItems = allowEditItems;
        return this;
    }

    public AbstractElementCollection<ET> setAllowRemovingItems(boolean allowRemovingItems) {
        this.allowRemovingItems = allowRemovingItems;
        return this;
    }

    public AbstractElementCollection<ET> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public void validate() throws Validator.InvalidValueException {
        super.validate();
        Collection v = (Collection)this.getValue();
        if (v != null) {
            for (Object o : v) {
                for (Field f : this.getFieldGroupFor(o).getFields()) {
                    f.validate();
                }
            }
        }
    }

    private Collection<ET> getAndEnsureValue() {
        AbstractCollection value = (ArrayList)this.getValue();
        if (value == null) {
            if (this.getPropertyDataSource() == null) {
                return new HashSet();
            }
            Class fieldType = this.getPropertyDataSource().getType();
            if (fieldType.isInterface()) {
                value = fieldType == List.class ? new ArrayList() : new HashSet();
            } else {
                try {
                    value = (Collection)fieldType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Could not instantiate the used colleciton type", ex);
                }
            }
            this.getPropertyDataSource().setValue(value);
        }
        return value;
    }

    public AbstractElementCollection<ET> setAllowNewElements(boolean allowNewItems) {
        this.allowNewItems = allowNewItems;
        return this;
    }

    public AbstractElementCollection(Class<ET> elementType, Class<?> formType) {
        this.elementType = elementType;
        this.editorType = formType;
    }

    public AbstractElementCollection(Class<ET> elementType, Instantiator i, Class<?> formType) {
        this.elementType = elementType;
        this.instantiator = i;
        this.editorType = formType;
    }

    public Class<ET> getElementType() {
        return this.elementType;
    }

    protected ET createInstance() {
        if (this.instantiator != null) {
            return this.instantiator.create();
        }
        try {
            return this.elementType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object createEditorInstance(ET pojo) {
        if (this.newEditorInstantiator != null) {
            return this.newEditorInstantiator.create(pojo);
        }
        if (this.oldEditorInstantiator != null) {
            return this.oldEditorInstantiator.create();
        }
        try {
            return this.editorType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public EditorInstantiator<?, ET> getNewEditorInstantiator() {
        return this.newEditorInstantiator;
    }

    public void setNewEditorInstantiator(EditorInstantiator<?, ET> editorInstantiator) {
        this.newEditorInstantiator = editorInstantiator;
    }

    public Instantiator<?> getEditorInstantiator() {
        return this.oldEditorInstantiator;
    }

    public void setEditorInstantiator(Instantiator<?> editorInstantiator) {
        this.oldEditorInstantiator = editorInstantiator;
    }

    protected final MBeanFieldGroup<ET> getFieldGroupFor(ET pojo) {
        EditorStuff es = this.pojoToEditor.get(pojo);
        if (es == null) {
            Object o = this.createEditorInstance(pojo);
            MBeanFieldGroup<ET> bfg = BeanBinder.bind(pojo, o, new String[0]).withEagerValidation(this.fieldGroupListener);
            es = new EditorStuff(bfg, o);
            this.pojoToEditor.put(pojo, es);
        }
        return es.bfg;
    }

    protected final Component getComponentFor(ET pojo, String property) {
        Field c;
        EditorStuff editorsstuff = this.pojoToEditor.get(pojo);
        if (editorsstuff == null) {
            Object o = this.createEditorInstance(pojo);
            MBeanFieldGroup<ET> bfg = BeanBinder.bind(pojo, o, new String[0]).withEagerValidation(this.fieldGroupListener);
            editorsstuff = new EditorStuff(bfg, o);
            this.pojoToEditor.put(pojo, editorsstuff);
        }
        if ((c = editorsstuff.bfg.getField(property)) == null) {
            try {
                java.lang.reflect.Field f = this.editorType.getDeclaredField(property);
                f.setAccessible(true);
                c = (Component)f.get(editorsstuff.editor);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(AbstractElementCollection.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (c == null) {
                c = new Label("");
            }
        }
        return c;
    }

    public void addElement(ET instance) {
        this.getAndEnsureValue().add(instance);
        this.addInternalElement(instance);
        this.fireValueChange(false);
        this.fireEvent((EventObject)((Object)new ElementAddedEvent<ET>(this, instance)));
    }

    public void removeElement(ET elemnentToBeRemoved) {
        this.removeInternalElement(elemnentToBeRemoved);
        this.getAndEnsureValue().remove(elemnentToBeRemoved);
        this.fireValueChange(false);
        this.fireEvent((EventObject)((Object)new ElementRemovedEvent<ET>(this, elemnentToBeRemoved)));
    }

    public AbstractElementCollection<ET> setVisibleProperties(List<String> properties) {
        this.visibleProperties = properties;
        return this;
    }

    public List<String> getVisibleProperties() {
        if (this.visibleProperties == null) {
            this.visibleProperties = new ArrayList<String>();
            for (java.lang.reflect.Field f : this.editorType.getDeclaredFields()) {
                if (!Field.class.isAssignableFrom(f.getType())) continue;
                this.visibleProperties.add(f.getName());
            }
        }
        return this.visibleProperties;
    }

    public AbstractElementCollection<ET> setVisibleProperties(List<String> properties, List<String> propertyHeaders) {
        this.visibleProperties = properties;
        Iterator<String> it = propertyHeaders.iterator();
        for (String prop : this.visibleProperties) {
            this.setPropertyHeader(prop, it.next());
        }
        return this;
    }

    public AbstractElementCollection<ET> setPropertyHeader(String propertyName, String propertyHeader) {
        this.propertyToHeader.put(propertyName, propertyHeader);
        return this;
    }

    protected String getPropertyHeader(String propertyName) {
        String header = this.propertyToHeader.get(propertyName);
        if (header == null) {
            header = DefaultFieldFactory.createCaptionByPropertyId((Object)propertyName);
        }
        return header;
    }

    protected Component initContent() {
        return this.getLayout();
    }

    protected void setInternalValue(Collection newValue) {
        super.setInternalValue((Object)newValue);
        this.clear();
        Collection value = newValue;
        if (value != null) {
            for (Object v : value) {
                this.addInternalElement(v);
            }
        }
        this.onElementAdded();
    }

    public Class<? extends Collection> getType() {
        return Collection.class;
    }

    protected abstract void addInternalElement(ET var1);

    protected abstract void setPersisted(ET var1, boolean var2);

    protected abstract void removeInternalElement(ET var1);

    protected abstract Layout getLayout();

    protected abstract void onElementAdded();

    private class EditorStuff
    implements Serializable {
        private static final long serialVersionUID = 5132645136059482705L;
        MBeanFieldGroup<ET> bfg;
        Object editor;

        private EditorStuff(MBeanFieldGroup<ET> editor, Object o) {
            this.bfg = editor;
            this.editor = o;
        }
    }

    public static interface EditorInstantiator<T, ET>
    extends Serializable {
        public T create(ET var1);
    }

    public static interface Instantiator<ET>
    extends Serializable {
        public ET create();
    }

    public static interface ElementRemovedListener<ET>
    extends Serializable {
        public void elementRemoved(ElementRemovedEvent<ET> var1);
    }

    public static interface ElementAddedListener<ET>
    extends Serializable {
        public void elementAdded(ElementAddedEvent<ET> var1);
    }

    public static class ElementRemovedEvent<ET>
    extends Component.Event {
        private static final long serialVersionUID = 574545902966053269L;
        private final ET element;

        public ElementRemovedEvent(AbstractElementCollection source, ET element) {
            super((Component)source);
            this.element = element;
        }

        public ET getElement() {
            return this.element;
        }
    }

    public static class ElementAddedEvent<ET>
    extends Component.Event {
        private static final long serialVersionUID = 2263765199849601501L;
        private final ET element;

        public ElementAddedEvent(AbstractElementCollection source, ET element) {
            super((Component)source);
            this.element = element;
        }

        public ET getElement() {
            return this.element;
        }
    }
}

