/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.CustomField;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;
import org.vaadin.viritin.v7.fields.MTextField;

public class ClearableTextField
extends CustomField {
    private final MTextField textfield = new MTextField();
    private final MButton clearButton = (MButton)new MButton((Resource)FontAwesome.TIMES).withStyleName(new String[]{"icon-only"});
    private final MHorizontalLayout root = (MHorizontalLayout)((MHorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().expand(this.textfield).add(this.clearButton).withSpacing(false)).withFullWidth()).withStyleName(new String[]{"clearable-textfield"});

    public ClearableTextField() {
        this.clearButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ClearableTextField.this.textfield.clear();
                ClearableTextField.this.textfield.focus();
            }
        });
        this.textfield.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                ClearableTextField.this.setValue(ClearableTextField.this.textfield.getValue());
            }
        });
        this.textfield.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent event) {
                ClearableTextField.this.setValue(event.getText());
            }
        });
        this.setWidth("300px");
    }

    public ClearableTextField(String caption) {
        this();
        this.setCaption(caption);
    }

    public ClearableTextField(Property dataSource) {
        this();
        this.textfield.setPropertyDataSource(dataSource);
    }

    public ClearableTextField(String caption, Property dataSource) {
        this();
        this.setCaption(caption);
        this.textfield.setPropertyDataSource(dataSource);
    }

    public ClearableTextField(String caption, String value) {
        this();
        this.setCaption(caption);
        this.textfield.setValue(value);
    }

    public MTextField getTextfield() {
        return this.textfield;
    }

    public Layout getRoot() {
        return this.root;
    }

    public MButton getClearButton() {
        return this.clearButton;
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.textfield.setReadOnly(readOnly);
        this.clearButton.setEnabled(!readOnly);
    }

    public void setImmediate(boolean immediate) {
        super.setImmediate(immediate);
        this.textfield.setImmediate(immediate);
    }

    public void addClickListener(Button.ClickListener listener) {
        this.clearButton.addClickListener(listener);
    }

    public void removeClickListener(Button.ClickListener listener) {
        this.clearButton.removeClickListener(listener);
    }

    public void click() {
        this.clearButton.click();
    }

    public void setClickShortcut(int keyCode, int ... modifiers) {
        this.clearButton.setClickShortcut(keyCode, modifiers);
    }

    public void removeClickShortcut() {
        this.clearButton.removeClickShortcut();
    }

    public void setIcon(Resource icon, String iconAltText) {
        this.clearButton.setIcon(icon, iconAltText);
    }

    public String getIconAlternateText() {
        return this.clearButton.getIconAlternateText();
    }

    public void setIconAlternateText(String iconAltText) {
        this.clearButton.setIconAlternateText(iconAltText);
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.clearButton.setHtmlContentAllowed(htmlContentAllowed);
    }

    public boolean isHtmlContentAllowed() {
        return this.clearButton.isHtmlContentAllowed();
    }

    public void clear() {
        super.clear();
        this.textfield.clear();
    }

    public String getNullRepresentation() {
        return this.textfield.getNullRepresentation();
    }

    public boolean isNullSettingAllowed() {
        return this.textfield.isNullSettingAllowed();
    }

    public void setNullRepresentation(String nullRepresentation) {
        this.textfield.setNullRepresentation(nullRepresentation);
    }

    public void setNullSettingAllowed(boolean nullSettingAllowed) {
        this.textfield.setNullSettingAllowed(nullSettingAllowed);
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    public int getMaxLength() {
        return this.textfield.getMaxLength();
    }

    public void setMaxLength(int maxLength) {
        this.textfield.setMaxLength(maxLength);
    }

    public int getColumns() {
        return this.textfield.getColumns();
    }

    public void setColumns(int columns) {
        this.textfield.setColumns(columns);
    }

    public String getInputPrompt() {
        return this.textfield.getInputPrompt();
    }

    public void setInputPrompt(String inputPrompt) {
        this.textfield.setInputPrompt(inputPrompt);
    }

    public void setTextChangeEventMode(AbstractTextField.TextChangeEventMode inputEventMode) {
        this.textfield.setTextChangeEventMode(inputEventMode);
    }

    public AbstractTextField.TextChangeEventMode getTextChangeEventMode() {
        return this.textfield.getTextChangeEventMode();
    }

    public void addTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.textfield.addTextChangeListener(listener);
    }

    public void removeTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.textfield.removeTextChangeListener(listener);
    }

    public void setTextChangeTimeout(int timeout) {
        this.textfield.setTextChangeTimeout(timeout);
    }

    public int getTextChangeTimeout() {
        return this.textfield.getTextChangeTimeout();
    }

    public void selectAll() {
        this.textfield.selectAll();
    }

    public void setSelectionRange(int pos, int length) {
        this.textfield.setSelectionRange(pos, length);
    }

    public void setCursorPosition(int pos) {
        this.textfield.setCursorPosition(pos);
    }

    public int getCursorPosition() {
        return this.textfield.getCursorPosition();
    }

    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.textfield.addFocusListener(listener);
    }

    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.textfield.removeFocusListener(listener);
    }

    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.textfield.addBlurListener(listener);
    }

    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.textfield.removeBlurListener(listener);
    }

    public ClearableTextField withCaption(String caption) {
        super.setCaption(caption);
        return this;
    }

    public ClearableTextField withConversionError(String message) {
        this.setConversionError(message);
        return this;
    }

    public ClearableTextField withConverter(Converter<String, ?> converter) {
        this.setConverter(converter);
        return this;
    }

    public ClearableTextField withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public ClearableTextField withValue(String value) {
        this.setValue(value);
        return this;
    }

    protected void doEagerValidation() {
        this.textfield.doEagerValidation();
    }

    protected void setInternalValue(Object newValue) {
        super.setInternalValue(newValue);
        this.textfield.setValue(newValue.toString());
    }

    public ErrorMessage getErrorMessage() {
        ErrorMessage errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            this.textfield.removeStyleName("error");
        } else {
            this.textfield.addStyleName("error");
        }
        return errorMessage;
    }

    public void setComponentError(ErrorMessage componentError) {
        super.setComponentError(componentError);
        if (componentError == null) {
            this.textfield.removeStyleName("error");
        } else {
            this.textfield.addStyleName("error");
        }
    }

    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
    }

    public void focus() {
        this.textfield.focus();
    }

    protected Component initContent() {
        return this.root;
    }

    public Class getType() {
        return String.class;
    }

    public void attach() {
        super.attach();
        Page.getCurrent().getStyles().add(".clearable-textfield .v-widget {\n\tborder-radius: 4px 4px 4px 4px;\n}\n.clearable-textfield .v-slot:last-child>.v-widget {\n\tborder-top-left-radius: 0;\n\tborder-bottom-left-radius: 0; margin-left:-1px\n}\n\n.clearable-textfield .v-slot:first-child>.v-widget {\n\tborder-top-right-radius: 0;\n\tborder-bottom-right-radius: 0;\n}\n");
    }
}

