/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.viritin.button.ConfirmButton;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MGridLayout;
import org.vaadin.viritin.v7.MBeanFieldGroup;
import org.vaadin.viritin.v7.fields.AbstractElementCollection;
import org.vaadin.viritin.v7.form.AbstractForm;

public class ElementCollectionField<ET>
extends AbstractElementCollection<ET> {
    private static final long serialVersionUID = 8573373104105052804L;
    List<ET> items = new ArrayList<ET>();
    boolean inited = false;
    MGridLayout layout = new MGridLayout();
    private boolean visibleHeaders = true;
    private boolean requireVerificationForRemoval;
    private AbstractForm<ET> popupEditor;
    private String disabledDeleteThisElementDescription = "Fill this row to add a new element, currently ignored";
    private String deleteThisElementDescription = "Delete this element";

    public ElementCollectionField(Class<ET> elementType, Class<?> formType) {
        super(elementType, formType);
    }

    public ElementCollectionField(Class<ET> elementType, AbstractElementCollection.Instantiator i, Class<?> formType) {
        super(elementType, i, formType);
    }

    @Override
    public void addInternalElement(final ET v) {
        this.ensureInited();
        this.items.add(v);
        MBeanFieldGroup<ET> fg = this.getFieldGroupFor(v);
        for (String property : this.getVisibleProperties()) {
            Field c = fg.getField(property);
            if (c == null) {
                c = this.getComponentFor(v, property.toString());
                Logger.getLogger(ElementCollectionField.class.getName()).log(Level.WARNING, "No editor field for{0}", property);
            }
            this.layout.addComponent((Component)c);
            this.layout.setComponentAlignment((Component)c, Alignment.MIDDLE_LEFT);
        }
        if (this.getPopupEditor() != null) {
            MButton b = ((MButton)new MButton((Resource)FontAwesome.EDIT).withStyleName(new String[]{"icon-only"})).withListener(new Button.ClickListener(){
                private static final long serialVersionUID = 5019806363620874205L;

                public void buttonClick(Button.ClickEvent event) {
                    ElementCollectionField.this.editInPopup(v);
                }
            });
            this.layout.add(b);
        }
        if (this.isAllowRemovingItems()) {
            this.layout.add(this.createRemoveButton(v));
        }
        if (!this.isAllowEditItems()) {
            fg.setReadOnly(true);
        }
    }

    protected Component createRemoveButton(final ET v) {
        Button b = this.requireVerificationForRemoval ? new ConfirmButton() : new MButton();
        b.setIcon((Resource)FontAwesome.TRASH_O);
        b.addStyleName("icon-only");
        b.addStyleName("danger");
        b.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5019806363620874205L;

            public void buttonClick(Button.ClickEvent event) {
                ElementCollectionField.this.removeElement(v);
            }
        });
        return b;
    }

    @Override
    public void removeInternalElement(ET v) {
        int index = this.itemsIdentityIndexOf(v);
        this.items.remove(index);
        int row = index + 1;
        this.layout.removeRow(row);
    }

    public GridLayout getLayout() {
        return this.layout;
    }

    @Override
    public void setPersisted(ET v, boolean persisted) {
        int row = this.itemsIdentityIndexOf(v) + 1;
        if (this.isAllowRemovingItems()) {
            Button c = (Button)this.layout.getComponent(this.layout.getColumns() - 1, row);
            if (persisted) {
                c.setDescription(this.getDeleteElementDescription());
            } else {
                for (int i = 0; i < this.getVisibleProperties().size(); ++i) {
                    try {
                        AbstractField f = (AbstractField)((Field)this.layout.getComponent(i, row));
                        f.setValidationVisible(false);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c.setDescription(this.getDisabledDeleteElementDescription());
            }
            c.setEnabled(persisted);
        }
    }

    private int itemsIdentityIndexOf(Object o) {
        for (int index = 0; index < this.items.size(); ++index) {
            if (this.items.get(index) != o) continue;
            return index;
        }
        return -1;
    }

    private void ensureInited() {
        if (!this.inited) {
            this.layout.setSpacing(true);
            int columns = this.getVisibleProperties().size();
            if (this.isAllowRemovingItems()) {
                ++columns;
            }
            if (this.getPopupEditor() != null) {
                ++columns;
            }
            this.layout.setColumns(columns);
            if (this.visibleHeaders) {
                for (String property : this.getVisibleProperties()) {
                    Component header = this.createHeader(property);
                    this.layout.addComponent(header);
                }
                if (this.isAllowRemovingItems()) {
                    this.layout.newLine();
                }
            }
            this.inited = true;
        }
    }

    protected Component createHeader(Object property) {
        Label header = new Label(this.getPropertyHeader(property.toString()));
        header.setWidthUndefined();
        return header;
    }

    public ElementCollectionField<ET> withEditorInstantiator(AbstractElementCollection.Instantiator instantiator) {
        this.setEditorInstantiator(instantiator);
        return this;
    }

    public ElementCollectionField<ET> withNewEditorInstantiator(AbstractElementCollection.EditorInstantiator<?, ET> instantiator) {
        this.setNewEditorInstantiator(instantiator);
        return this;
    }

    public ElementCollectionField<ET> withVisibleHeaders(boolean visibleHeaders) {
        this.visibleHeaders = visibleHeaders;
        return this;
    }

    public void clear() {
        if (this.inited) {
            int rows;
            this.items.clear();
            int n = rows = this.inited ? 1 : 0;
            while (this.layout.getRows() > rows) {
                this.layout.removeRow(rows);
            }
        }
    }

    public String getDisabledDeleteElementDescription() {
        return this.disabledDeleteThisElementDescription;
    }

    public void setDisabledDeleteThisElementDescription(String disabledDeleteThisElementDescription) {
        this.disabledDeleteThisElementDescription = disabledDeleteThisElementDescription;
    }

    public String getDeleteElementDescription() {
        return this.deleteThisElementDescription;
    }

    public void setDeleteThisElementDescription(String deleteThisElementDescription) {
        this.deleteThisElementDescription = deleteThisElementDescription;
    }

    @Override
    public void onElementAdded() {
        if (this.isAllowNewItems()) {
            this.newInstance = this.createInstance();
            this.addInternalElement(this.newInstance);
            this.setPersisted(this.newInstance, false);
        }
    }

    @Override
    public ElementCollectionField<ET> setPropertyHeader(String propertyName, String propertyHeader) {
        super.setPropertyHeader(propertyName, propertyHeader);
        return this;
    }

    @Override
    public ElementCollectionField<ET> setVisibleProperties(List<String> properties, List<String> propertyHeaders) {
        super.setVisibleProperties(properties, propertyHeaders);
        return this;
    }

    @Override
    public ElementCollectionField<ET> setVisibleProperties(List<String> properties) {
        super.setVisibleProperties(properties);
        return this;
    }

    @Override
    public ElementCollectionField<ET> setAllowNewElements(boolean allowNewItems) {
        super.setAllowNewElements(allowNewItems);
        return this;
    }

    @Override
    public ElementCollectionField<ET> setAllowRemovingItems(boolean allowRemovingItems) {
        super.setAllowRemovingItems(allowRemovingItems);
        return this;
    }

    @Override
    public ElementCollectionField<ET> withCaption(String caption) {
        super.withCaption(caption);
        return this;
    }

    @Override
    public ElementCollectionField<ET> removeElementRemovedListener(AbstractElementCollection.ElementRemovedListener listener) {
        super.removeElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET> addElementRemovedListener(AbstractElementCollection.ElementRemovedListener<ET> listener) {
        super.addElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET> removeElementAddedListener(AbstractElementCollection.ElementAddedListener listener) {
        super.removeElementAddedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionField<ET> addElementAddedListener(AbstractElementCollection.ElementAddedListener<ET> listener) {
        super.addElementAddedListener(listener);
        return this;
    }

    public ElementCollectionField<ET> expand(String ... propertyId) {
        for (String propertyId1 : propertyId) {
            int index = this.getVisibleProperties().indexOf(propertyId1);
            if (index == -1) {
                throw new IllegalArgumentException("The expanded property must available");
            }
            this.layout.setColumnExpandRatio(index, 1.0f);
        }
        if (this.layout.getWidth() == -1.0f) {
            this.layout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        }
        return this;
    }

    public ElementCollectionField<ET> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public ElementCollectionField<ET> withId(String id) {
        this.setId(id);
        return this;
    }

    public ElementCollectionField<ET> setRequireVerificationForRemoving(boolean requireVerification) {
        this.requireVerificationForRemoval = requireVerification;
        return this;
    }

    public AbstractForm<ET> getPopupEditor() {
        return this.popupEditor;
    }

    public void setPopupEditor(AbstractForm<ET> newPopupEditor) {
        this.popupEditor = newPopupEditor;
        if (newPopupEditor != null) {
            newPopupEditor.setSavedHandler(new AbstractForm.SavedHandler<ET>(){
                private static final long serialVersionUID = 389618696563816566L;

                @Override
                public void onSave(ET entity) {
                    MBeanFieldGroup fg = ElementCollectionField.this.getFieldGroupFor(entity);
                    fg.setItemDataSource(entity);
                    fg.setBeanModified(true);
                    ElementCollectionField.this.popupEditor.getPopup().close();
                }
            });
        }
    }

    public void editInPopup(ET entity) {
        this.getPopupEditor().setEntity(entity);
        this.getPopupEditor().openInModalPopup();
    }
}

