/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MVerticalLayout;
import org.vaadin.viritin.v7.MBeanFieldGroup;
import org.vaadin.viritin.v7.fields.AbstractElementCollection;
import org.vaadin.viritin.v7.fields.MTable;

public class ElementCollectionTable<ET>
extends AbstractElementCollection<ET> {
    private static final long serialVersionUID = 8055987316151594559L;
    private MTable<ET> table;
    private MButton addButton = new MButton((Resource)FontAwesome.PLUS, new Button.ClickListener(){
        private static final long serialVersionUID = 6115218255676556647L;

        public void buttonClick(Button.ClickEvent event) {
            ElementCollectionTable.this.addElement(ElementCollectionTable.this.createInstance());
        }
    });
    private IdentityHashMap<ET, MButton> elementToDelButton = new IdentityHashMap();
    boolean inited = false;
    private MVerticalLayout layout = new MVerticalLayout();
    private String[] deleteElementStyles;
    private String disabledDeleteThisElementDescription = "Fill this row to add a new element, currently ignored";
    private String deleteThisElementDescription = "Delete this element";

    public ElementCollectionTable(Class<ET> elementType, Class<?> formType) {
        super(elementType, formType);
    }

    public ElementCollectionTable(Class<ET> elementType, AbstractElementCollection.Instantiator i, Class<?> formType) {
        super(elementType, i, formType);
    }

    public void attach() {
        super.attach();
        this.ensureInited();
    }

    @Override
    public void addInternalElement(ET v) {
        this.ensureInited();
        this.table.addBeans(v);
    }

    @Override
    public void removeInternalElement(ET v) {
        this.table.removeItem(v);
        this.elementToDelButton.remove(v);
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    public MButton getAddButton() {
        return this.addButton;
    }

    public MTable<ET> getTable() {
        return this.table;
    }

    @Override
    public void setPersisted(ET v, boolean persisted) {
    }

    private void ensureInited() {
        if (!this.inited) {
            this.layout.setMargin(false);
            this.setHeight("300px");
            this.table = new MTable(this.getElementType()).withFullWidth();
            for (String propertyId : this.getVisibleProperties()) {
                this.table.addGeneratedColumn(propertyId, new Table.ColumnGenerator(){
                    private static final long serialVersionUID = 3637140096807147630L;

                    public Object generateCell(Table source, Object itemId, Object columnId) {
                        Field component;
                        MBeanFieldGroup<Object> fg = ElementCollectionTable.this.getFieldGroupFor(itemId);
                        if (!ElementCollectionTable.this.isAllowEditItems()) {
                            fg.setReadOnly(true);
                        }
                        if ((component = fg.getField(columnId)) == null) {
                            ElementCollectionTable.this.getComponentFor(itemId, columnId.toString());
                        }
                        return component;
                    }
                });
            }
            ArrayList<String> cols = new ArrayList<String>(this.getVisibleProperties());
            if (this.isAllowRemovingItems()) {
                this.table.addGeneratedColumn("__ACTIONS", new Table.ColumnGenerator(){
                    private static final long serialVersionUID = 492486828008202547L;

                    public Object generateCell(Table source, final Object itemId, Object columnId) {
                        MButton b = (MButton)new MButton((Resource)FontAwesome.TRASH_O).withListener(new Button.ClickListener(){
                            private static final long serialVersionUID = -1257102620834362724L;

                            public void buttonClick(Button.ClickEvent event) {
                                ElementCollectionTable.this.removeElement(itemId);
                            }
                        }).withStyleName(new String[]{"icon-only"});
                        b.setDescription(ElementCollectionTable.this.getDeleteElementDescription());
                        if (ElementCollectionTable.this.getDeleteElementStyles() != null) {
                            for (String style : ElementCollectionTable.this.getDeleteElementStyles()) {
                                b.addStyleName(style);
                            }
                        }
                        ElementCollectionTable.this.elementToDelButton.put(itemId, b);
                        return b;
                    }
                });
                this.table.setColumnHeader("__ACTIONS", "");
                cols.add("__ACTIONS");
            }
            this.table.setVisibleColumns(cols.toArray());
            for (String property : this.getVisibleProperties()) {
                this.table.setColumnHeader(property, this.getPropertyHeader(property.toString()));
            }
            this.layout.expand(new Component[]{this.table});
            if (this.isAllowNewItems()) {
                this.layout.addComponent(this.addButton);
            }
            this.inited = true;
        }
    }

    public void clear() {
        if (this.inited) {
            this.table.removeAllItems();
            this.elementToDelButton.clear();
        }
    }

    public String getDisabledDeleteElementDescription() {
        return this.disabledDeleteThisElementDescription;
    }

    public void setDisabledDeleteThisElementDescription(String disabledDeleteThisElementDescription) {
        this.disabledDeleteThisElementDescription = disabledDeleteThisElementDescription;
    }

    public String getDeleteElementDescription() {
        return this.deleteThisElementDescription;
    }

    public void setDeleteThisElementDescription(String deleteThisElementDescription) {
        this.deleteThisElementDescription = deleteThisElementDescription;
    }

    public String[] getDeleteElementStyles() {
        return this.deleteElementStyles;
    }

    public void addDeleteElementStyles(String ... deleteElementStyles) {
        this.deleteElementStyles = deleteElementStyles;
    }

    @Override
    public void onElementAdded() {
    }

    @Override
    public ElementCollectionTable<ET> setPropertyHeader(String propertyName, String propertyHeader) {
        super.setPropertyHeader(propertyName, propertyHeader);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> setVisibleProperties(List<String> properties, List<String> propertyHeaders) {
        super.setVisibleProperties(properties, propertyHeaders);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> setVisibleProperties(List<String> properties) {
        super.setVisibleProperties(properties);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> setAllowNewElements(boolean allowNewItems) {
        super.setAllowNewElements(allowNewItems);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> setAllowRemovingItems(boolean allowRemovingItems) {
        super.setAllowRemovingItems(allowRemovingItems);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> withCaption(String caption) {
        super.withCaption(caption);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> removeElementRemovedListener(AbstractElementCollection.ElementRemovedListener listener) {
        super.removeElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> addElementRemovedListener(AbstractElementCollection.ElementRemovedListener<ET> listener) {
        super.addElementRemovedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> removeElementAddedListener(AbstractElementCollection.ElementAddedListener listener) {
        super.removeElementAddedListener(listener);
        return this;
    }

    @Override
    public ElementCollectionTable<ET> addElementAddedListener(AbstractElementCollection.ElementAddedListener<ET> listener) {
        super.addElementAddedListener(listener);
        return this;
    }

    public ElementCollectionTable<ET> withEditorInstantiator(AbstractElementCollection.Instantiator instantiator) {
        this.setEditorInstantiator(instantiator);
        return this;
    }
}

