/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.viritin.v7.fields.AbstractNumberField;

public class IntegerField
extends AbstractNumberField<Integer> {
    private static final long serialVersionUID = 377246000306551089L;

    public IntegerField() {
        this.setSizeUndefined();
    }

    public IntegerField(String caption) {
        this.setCaption(caption);
    }

    @Override
    protected void userInputToValue(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            this.setValue(Integer.parseInt(str));
        } else {
            this.setValue(null);
        }
    }

    public Class<? extends Integer> getType() {
        return Integer.class;
    }

    public IntegerField withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public IntegerField withId(String id) {
        this.setId(id);
        return this;
    }

    public IntegerField withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public IntegerField withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return this;
    }

    public IntegerField withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public IntegerField withBlurListener(FieldEvents.BlurListener listener) {
        return (IntegerField)super.withBlurListener(listener);
    }

    public IntegerField withFocusListener(FieldEvents.FocusListener listener) {
        return (IntegerField)super.withFocusListener(listener);
    }
}

