/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.Label;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.v7.label.RichText;

public class LabelField<T>
extends CustomField<T> {
    private static final long serialVersionUID = -3079451926367430515L;
    private final Class<T> type;
    private CaptionGenerator<T> captionGenerator = new ToStringCaptionGenerator();
    private Label label = new RichText();

    public LabelField(Class<T> type, String caption) {
        this.type = type;
        this.setCaption(caption);
    }

    public LabelField(Class<T> type) {
        this.type = type;
    }

    public LabelField() {
        this.type = String.class;
    }

    public LabelField<T> withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public LabelField<T> withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return this;
    }

    public LabelField<T> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public LabelField<T> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public LabelField<T> withValue(T newFieldValue) {
        this.setValue(newFieldValue);
        return this;
    }

    protected Component initContent() {
        this.updateLabel();
        return this.label;
    }

    protected void updateLabel() {
        String caption = this.captionGenerator != null ? this.captionGenerator.getCaption(this.getValue()) : this.getValue().toString();
        this.label.setValue(caption);
    }

    protected void setInternalValue(T newValue) {
        super.setInternalValue(newValue);
        this.updateLabel();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public void setCaptionGenerator(CaptionGenerator<T> captionGenerator) {
        this.captionGenerator = captionGenerator;
        this.updateLabel();
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    private static class ToStringCaptionGenerator<T>
    implements CaptionGenerator<T> {
        private static final long serialVersionUID = 1149675718238329960L;

        private ToStringCaptionGenerator() {
        }

        @Override
        public String getCaption(T option) {
            if (option == null) {
                return "";
            }
            return option.toString();
        }
    }
}

