/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.datefield.Resolution;
import com.vaadin.v7.ui.DateField;
import java.util.Date;
import java.util.Map;

public class MDateField
extends DateField {
    private InitialTimeMode initialTimeMode;
    private boolean settingInitialValue;

    public MDateField() {
    }

    public MDateField(String caption) {
        super(caption);
    }

    public MDateField(String caption, Property dataSource) {
        super(caption, dataSource);
    }

    public MDateField(Property dataSource) throws IllegalArgumentException {
        super(dataSource);
    }

    public MDateField(String caption, Date value) {
        super(caption, value);
    }

    public InitialTimeMode getInitialTimeMode() {
        return this.initialTimeMode;
    }

    public void setInitialTimeMode(InitialTimeMode initialTimeMode) {
        this.initialTimeMode = initialTimeMode;
    }

    public void changeVariables(Object source, Map<String, Object> variables) {
        if (this.getValue() == null) {
            this.settingInitialValue = true;
        }
        super.changeVariables(source, variables);
        this.settingInitialValue = false;
    }

    protected void setValue(Date newValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException {
        if (this.settingInitialValue && this.getResolution().ordinal() > Resolution.HOUR.ordinal()) {
            if (this.getInitialTimeMode() == InitialTimeMode.START_OF_DAY) {
                newValue.setHours(0);
                newValue.setMinutes(0);
                newValue.setSeconds(0);
                newValue.setTime(newValue.getTime() - newValue.getTime() % 1000L);
            } else if (this.getInitialTimeMode() == InitialTimeMode.END_OF_DAY) {
                newValue.setHours(23);
                newValue.setMinutes(59);
                newValue.setSeconds(59);
                newValue.setTime(newValue.getTime() - newValue.getTime() % 1000L + 999L);
            }
        }
        super.setValue(newValue, repaintIsNotNeeded);
    }

    public MDateField withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public MDateField withResolution(Resolution resolution) {
        this.setResolution(resolution);
        return this;
    }

    public MDateField withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public MDateField withRequired(boolean required) {
        this.setRequired(required);
        return this;
    }

    public MDateField withRequiredError(String requiredError) {
        this.setRequiredError(requiredError);
        return this;
    }

    public MDateField withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public MDateField withValue(Date newDate) {
        this.setValue(newDate);
        return this;
    }

    public MDateField withValueChangeListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
        return this;
    }

    public MDateField withBlurListener(FieldEvents.BlurListener listener) {
        this.addBlurListener(listener);
        return this;
    }

    public MDateField withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return this;
    }

    public MDateField withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public MDateField withId(String id) {
        this.setId(id);
        return this;
    }

    public MDateField withVisible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public MDateField withDateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public static enum InitialTimeMode {
        START_OF_DAY,
        END_OF_DAY,
        NOW;

    }
}

