/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.CompositeErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.PasswordField;
import java.util.EventObject;
import org.vaadin.viritin.v7.fields.EagerValidateable;

public class MPasswordField
extends PasswordField
implements EagerValidateable {
    private static final long serialVersionUID = 7493214285444996814L;
    private boolean eagerValidation = false;
    private boolean eagerValidationStatus;
    private String lastKnownTextChangeValue;
    private Validator.InvalidValueException eagerValidationError;

    public MPasswordField() {
        this.configureMaddonStuff();
    }

    private void configureMaddonStuff() {
        this.setNullRepresentation("");
    }

    public MPasswordField(String caption) {
        super(caption);
        this.configureMaddonStuff();
    }

    public MPasswordField(Property dataSource) {
        super(dataSource);
        this.configureMaddonStuff();
    }

    public MPasswordField(String caption, Property dataSource) {
        super(caption, dataSource);
        this.configureMaddonStuff();
    }

    public MPasswordField(String caption, String value) {
        super(caption, value);
    }

    protected void setValue(String newFieldValue, boolean repaintIsNotNeeded) throws Property.ReadOnlyException, Converter.ConversionException, Validator.InvalidValueException {
        this.lastKnownTextChangeValue = null;
        this.eagerValidationError = null;
        super.setValue((Object)newFieldValue, repaintIsNotNeeded);
    }

    @Override
    public boolean isEagerValidation() {
        return this.eagerValidation;
    }

    @Override
    public void setEagerValidation(boolean eagerValidation) {
        this.eagerValidation = eagerValidation;
    }

    protected void fireEvent(EventObject event) {
        if (this.isEagerValidation() && event instanceof FieldEvents.TextChangeEvent) {
            this.lastKnownTextChangeValue = ((FieldEvents.TextChangeEvent)event).getText();
            this.doEagerValidation();
        }
        super.fireEvent(event);
    }

    public String getLastKnownTextContent() {
        return this.lastKnownTextChangeValue;
    }

    public MPasswordField withConversionError(String message) {
        this.setConversionError(message);
        return this;
    }

    public MPasswordField withConverter(Converter<String, ?> converter) {
        this.setConverter(converter);
        return this;
    }

    public MPasswordField withFullWidth() {
        this.setWidth("100%");
        return this;
    }

    public MPasswordField withInputPrompt(String inputPrompt) {
        this.setInputPrompt(inputPrompt);
        return this;
    }

    public MPasswordField withReadOnly(boolean readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public MPasswordField withValidator(Validator validator) {
        this.addValidator(validator);
        return this;
    }

    public MPasswordField withWidth(float width, Sizeable.Unit unit) {
        this.setWidth(width, unit);
        return this;
    }

    public MPasswordField withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public MPasswordField withNullRepresentation(String nullRepresentation) {
        this.setNullRepresentation(nullRepresentation);
        return this;
    }

    public MPasswordField withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public MPasswordField withRequired(boolean required) {
        this.setRequired(required);
        return this;
    }

    public MPasswordField withRequiredError(String requiredError) {
        this.setRequiredError(requiredError);
        return this;
    }

    public MPasswordField withId(String id) {
        this.setId(id);
        return this;
    }

    public MPasswordField withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public MPasswordField withTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.addTextChangeListener(listener);
        return this;
    }

    public MPasswordField withValueChangeListener(Property.ValueChangeListener listener) {
        this.addValueChangeListener(listener);
        return this;
    }

    public MPasswordField withBlurListener(FieldEvents.BlurListener listener) {
        this.addBlurListener(listener);
        return this;
    }

    public ErrorMessage getErrorMessage() {
        Validator.InvalidValueException validationError = this.getValidationError();
        ErrorMessage superError = this.getComponentError();
        if (superError == null && validationError == null && this.getCurrentBufferedSourceException() == null) {
            return null;
        }
        return new CompositeErrorMessage(new ErrorMessage[]{superError, AbstractErrorMessage.getErrorMessageForException((Throwable)validationError), AbstractErrorMessage.getErrorMessageForException((Throwable)this.getCurrentBufferedSourceException())});
    }

    protected Validator.InvalidValueException getValidationError() {
        Validator.InvalidValueException validationError;
        block4: {
            if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
                return this.eagerValidationError;
            }
            validationError = null;
            if (this.isValidationVisible()) {
                try {
                    this.validate();
                }
                catch (Validator.InvalidValueException e) {
                    if (e.isInvisible()) break block4;
                    validationError = e;
                }
            }
        }
        return validationError;
    }

    protected void doEagerValidation() {
        boolean wasvalid = this.eagerValidationStatus;
        this.eagerValidationStatus = true;
        this.eagerValidationError = null;
        try {
            if (this.isRequired() && this.getLastKnownTextContent().isEmpty()) {
                throw new Validator.EmptyValueException(this.getRequiredError());
            }
            this.validate(this.getLastKnownTextContent());
            if (!wasvalid) {
                this.markAsDirty();
            }
        }
        catch (Validator.InvalidValueException e) {
            this.eagerValidationError = e;
            this.eagerValidationStatus = false;
            this.markAsDirty();
        }
    }

    public boolean isValid() {
        if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
            return this.eagerValidationStatus;
        }
        return super.isValid();
    }

    public void validate() throws Validator.InvalidValueException {
        if (this.isEagerValidation() && this.lastKnownTextChangeValue != null) {
            if (this.isRequired() && this.getLastKnownTextContent().isEmpty()) {
                throw new Validator.EmptyValueException(this.getRequiredError());
            }
            this.validate(this.getLastKnownTextContent());
        } else {
            super.validate();
        }
    }
}

