/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields.config;

import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;

public class ComboBoxConfig {
    FilteringMode filteringMode;
    ComboBox.ItemStyleGenerator itemStyleGenerator;
    Integer pageLength;
    Boolean textInputAllowed;
    Boolean scrollToSelectedItem;

    public static final ComboBoxConfig build() {
        return new ComboBoxConfig();
    }

    public ComboBoxConfig withFilteringMode(FilteringMode filteringMode) {
        this.filteringMode = filteringMode;
        return this;
    }

    public ComboBoxConfig withItemStyleGenerator(ComboBox.ItemStyleGenerator itemStyleGenerator) {
        this.itemStyleGenerator = itemStyleGenerator;
        return this;
    }

    public ComboBoxConfig withPageLength(int pageLength) {
        this.pageLength = pageLength;
        return this;
    }

    public ComboBoxConfig withTextInputAllowed(boolean textInputAllowed) {
        this.textInputAllowed = textInputAllowed;
        return this;
    }

    public ComboBoxConfig withScrollToSelectedItem(boolean scrollToSelectedItem) {
        this.scrollToSelectedItem = scrollToSelectedItem;
        return this;
    }

    public void configurateComboBox(ComboBox comboBox) {
        if (this.filteringMode != null) {
            comboBox.setFilteringMode(this.filteringMode);
        }
        if (this.itemStyleGenerator != null) {
            comboBox.setItemStyleGenerator(this.itemStyleGenerator);
        }
        if (this.pageLength != null) {
            comboBox.setPageLength(this.pageLength.intValue());
        }
        if (this.textInputAllowed != null) {
            comboBox.setTextInputAllowed(this.textInputAllowed.booleanValue());
        }
        if (this.scrollToSelectedItem != null) {
            comboBox.setScrollToSelectedItem(this.scrollToSelectedItem.booleanValue());
        }
    }
}

