/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.grid;

import com.vaadin.server.Extension;
import com.vaadin.server.Sizeable;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.PropertyValueGenerator;
import com.vaadin.v7.event.SortEvent;
import com.vaadin.v7.ui.Grid;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.viritin.LazyList;
import org.vaadin.viritin.MSize;
import org.vaadin.viritin.v7.ListContainer;
import org.vaadin.viritin.v7.SortableLazyList;
import org.vaadin.viritin.v7.grid.GeneratedPropertyListContainer;
import org.vaadin.viritin.v7.grid.StringPropertyValueGenerator;
import org.vaadin.viritin.v7.grid.TypedPropertyValueGenerator;
import org.vaadin.viritin.v7.grid.utils.GridUtils;

public class MGrid<T>
extends Grid {
    private static final long serialVersionUID = -7821775220281254054L;
    private Class<T> typeOfRows;
    private SortEvent.SortListener sortListener;
    private FieldGroup.CommitHandler reloadDataEfficientlyAfterEditor;

    public MGrid() {
    }

    public MGrid(Class<T> typeOfRows) {
        this.setRowType(typeOfRows);
    }

    public MGrid<T> setRowType(Class<T> typeOfRows1) {
        this.setContainerDataSource(new ListContainer<T>(typeOfRows1));
        this.typeOfRows = typeOfRows1;
        return this;
    }

    public MGrid(List<T> listOfEntities) {
        this.setRows(listOfEntities);
    }

    public MGrid(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(new LazyList<T>(pageProvider, countProvider, 45));
    }

    public MGrid(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(new LazyList<T>(pageProvider, countProvider, pageSize));
    }

    public MGrid(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(pageProvider, countProvider, 45);
    }

    public MGrid(SortableLazyList.MultiSortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(pageProvider, countProvider, 45);
    }

    public MGrid(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
    }

    public MGrid(SortableLazyList.MultiSortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
    }

    private void ensureSortListener() {
        if (this.sortListener == null) {
            this.sortListener = new SortEvent.SortListener(){
                private static final long serialVersionUID = -8850456663417023533L;

                public void sort(SortEvent event) {
                    MGrid.this.refreshVisibleRows();
                }
            };
            this.addSortListener(this.sortListener);
        }
    }

    public void attachSaveSettings(String settingsName) {
        GridUtils.attachToGrid(this, settingsName);
    }

    public MGrid<T> setRows(List<T> rows) {
        if (this.getContainerDataSource() instanceof ListContainer) {
            SortableLazyList old;
            Collection<?> itemIds = this.getListContainer().getItemIds();
            if (itemIds instanceof SortableLazyList && (old = (SortableLazyList)itemIds).getSortProperty() != null && rows instanceof SortableLazyList) {
                SortableLazyList newList = (SortableLazyList)rows;
                newList.setSortProperty(old.getSortProperty());
                newList.setSortAscending(old.getSortAscending());
            }
            this.getListContainer().setCollection(rows);
        } else {
            this.setContainerDataSource(new ListContainer<T>(rows));
        }
        return this;
    }

    public List<T> getRows() {
        return (List)this.getListContainer().getItemIds();
    }

    protected ListContainer<T> getListContainer() {
        ListContainer listContainer = (ListContainer)this.getContainerDataSource();
        return listContainer;
    }

    public MGrid<T> setRows(T ... rows) {
        this.setRows(Arrays.asList(rows));
        return this;
    }

    public <P> MGrid<T> withGeneratedColumn(String columnId, Class<P> presentationType, TypedPropertyValueGenerator.ValueGenerator<T, P> generator) {
        TypedPropertyValueGenerator<T, P> lambdaPropertyValueGenerator = new TypedPropertyValueGenerator<T, P>(this.typeOfRows, presentationType, generator);
        this.addGeneratedColumn(columnId, lambdaPropertyValueGenerator);
        return this;
    }

    public MGrid<T> withGeneratedColumn(String columnId, StringPropertyValueGenerator.ValueGenerator<T> generator) {
        StringPropertyValueGenerator<T> lambdaPropertyValueGenerator = new StringPropertyValueGenerator<T>(this.typeOfRows, generator);
        this.addGeneratedColumn(columnId, lambdaPropertyValueGenerator);
        return this;
    }

    public MGrid<T> withGeneratedColumn(String columnId, PropertyValueGenerator<?> columnGenerator) {
        this.addGeneratedColumn(columnId, columnGenerator);
        return this;
    }

    private void addGeneratedColumn(String columnId, PropertyValueGenerator<?> columnGenerator) {
        GeneratedPropertyListContainer gplc;
        Container.Indexed container = this.getContainerDataSource();
        if (container instanceof GeneratedPropertyListContainer) {
            gplc = (GeneratedPropertyListContainer)container;
        } else {
            gplc = new GeneratedPropertyListContainer(this.typeOfRows);
            try {
                gplc.setCollection(this.getListContainer().getItemIds());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setContainerDataSource(gplc);
        }
        gplc.addGeneratedProperty(columnId, columnGenerator);
        this.addColumn(columnId);
    }

    public MGrid<T> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public T getSelectedRow() throws IllegalStateException {
        return (T)super.getSelectedRow();
    }

    public boolean selectRow(T entity) {
        return this.select(entity);
    }

    @Deprecated
    public boolean select(Object itemId) throws IllegalArgumentException, IllegalStateException {
        return super.select(itemId);
    }

    public Collection<T> getSelectedRowsWithType() {
        return super.getSelectedRows();
    }

    public MGrid<T> withProperties(String ... propertyIds) {
        Container.Indexed containerDataSource = this.getContainerDataSource();
        if (containerDataSource instanceof ListContainer) {
            ListContainer lc = (ListContainer)containerDataSource;
            lc.setContainerPropertyIds(propertyIds);
        }
        this.setColumns(propertyIds);
        return this;
    }

    public MGrid<T> withId(String id) {
        this.setId(id);
        return this;
    }

    public void setEditorEnabled(boolean isEnabled) throws IllegalStateException {
        super.setEditorEnabled(isEnabled);
        this.ensureRowRefreshListener(isEnabled);
    }

    protected void ensureRowRefreshListener(boolean isEnabled) {
        if (isEnabled && this.reloadDataEfficientlyAfterEditor == null) {
            this.reloadDataEfficientlyAfterEditor = new FieldGroup.CommitHandler(){
                private static final long serialVersionUID = -9107206992771475209L;

                public void preCommit(FieldGroup.CommitEvent commitEvent) throws FieldGroup.CommitException {
                }

                public void postCommit(FieldGroup.CommitEvent commitEvent) throws FieldGroup.CommitException {
                    Item itemDataSource = commitEvent.getFieldBinder().getItemDataSource();
                    if (itemDataSource instanceof ListContainer.DynaBeanItem) {
                        ListContainer.DynaBeanItem dynaBeanItem = (ListContainer.DynaBeanItem)itemDataSource;
                        Object bean = dynaBeanItem.getBean();
                        MGrid.this.refreshRow(bean);
                    }
                }
            };
            this.getEditorFieldGroup().addCommitHandler(this.reloadDataEfficientlyAfterEditor);
        }
    }

    public void refreshRow(T bean) {
        Collection extensions = this.getExtensions();
        for (Extension extension : extensions) {
            if (!extension.getClass().getName().contains("RpcDataProviderExtension")) continue;
            try {
                Method method = extension.getClass().getMethod("updateRowData", Object.class);
                method.invoke((Object)extension, bean);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(MGrid.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void refreshRows() {
        if (this.getContainerDataSource() instanceof ListContainer) {
            ListContainer<T> listContainer = this.getListContainer();
            if (listContainer.getItemIds() instanceof LazyList) {
                ((LazyList)listContainer.getItemIds()).reset();
            }
            listContainer.fireItemSetChange();
        }
        this.refreshVisibleRows();
    }

    public void refreshVisibleRows() {
        Collection extensions = this.getExtensions();
        for (Extension extension : extensions) {
            if (!extension.getClass().getName().contains("RpcDataProviderExtension")) continue;
            try {
                Method method = extension.getClass().getMethod("refreshCache", new Class[0]);
                method.invoke((Object)extension, new Object[0]);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(MGrid.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public MGrid<T> lazyLoadFrom(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this.setRows(new LazyList<T>(pageProvider, countProvider, 45));
        return this;
    }

    public MGrid<T> lazyLoadFrom(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this.setRows(new LazyList<T>(pageProvider, countProvider, pageSize));
        return this;
    }

    public MGrid<T> lazyLoadFrom(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this.setRows(new SortableLazyList<T>(pageProvider, countProvider, 45));
        this.ensureSortListener();
        return this;
    }

    public MGrid<T> lazyLoadFrom(SortableLazyList.MultiSortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this.setRows(new SortableLazyList<T>(pageProvider, countProvider, 45));
        this.ensureSortListener();
        return this;
    }

    public MGrid<T> lazyLoadFrom(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this.setRows(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
        this.ensureSortListener();
        return this;
    }

    public MGrid<T> lazyLoadFrom(SortableLazyList.MultiSortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this.setRows(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
        this.ensureSortListener();
        return this;
    }

    public MGrid<T> withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public MGrid<T> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public MGrid<T> withHeight(String height) {
        this.setHeight(height);
        return this;
    }

    public MGrid<T> withFullHeight() {
        return this.withHeight("100%");
    }

    public MGrid<T> withSize(MSize mSize) {
        this.setWidth(mSize.getWidth(), mSize.getWidthUnit());
        this.setHeight(mSize.getHeight(), mSize.getHeightUnit());
        return this;
    }

    public MGrid<T> withColumnHeaders(String ... header) {
        if (header.length != this.getColumns().size()) {
            throw new IllegalArgumentException("The length of the headers array must match the number of columns");
        }
        for (int i = 0; i < this.getColumns().size(); ++i) {
            Object propertyId = ((Grid.Column)this.getColumns().get(i)).getPropertyId();
            if (header[i] == null) continue;
            this.getColumn(propertyId).setHeaderCaption(header[i]);
        }
        return this;
    }
}

