/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.log;

import com.levigo.util.log.ILoggerFactory;
import com.levigo.util.log.Logger;
import com.levigo.util.log.SimpleLoggerFactory;
import com.levigo.util.log.impl.LoggingBinder;

public final class LoggerFactory {
    private static final ILoggerFactory factory;

    public static Logger getLogger(String name) {
        return factory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return factory.getLogger(clazz);
    }

    public static Logger getRootLogger() {
        return factory.getRootLogger();
    }

    static {
        Throwable cause;
        ILoggerFactory f;
        try {
            f = LoggingBinder.SINGLETON.getLoggerFactory();
            cause = null;
        }
        catch (Throwable t) {
            cause = t;
            f = null;
        }
        if (f == null) {
            System.err.println("Unable to initialize logging.");
            if (cause != null) {
                if (cause instanceof NoClassDefFoundError && cause.getMessage() != null && cause.getMessage().equals("com/levigo/util/log/impl/LoggingBinder")) {
                    System.err.println("No logging delegation implementation on classpath");
                } else {
                    System.err.println("Initialization failure due to exception:");
                    cause.printStackTrace();
                }
            }
            System.err.println("Using default simple logging instead.");
            f = new SimpleLoggerFactory();
        }
        factory = f;
    }
}

