/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.log;

import com.levigo.util.log.Logger;
import java.io.PrintStream;

public class SimpleLogger
implements Logger {
    private final String name;
    private final String errorEntryPrefix;
    private final String warnEntryPrefix;
    private final String fatalEntryPrefix;
    private final String infoEntryPrefix;
    private final PrintStream errorOut;
    private final PrintStream warnOut;
    private final PrintStream fatalOut;
    private final PrintStream infoOut;

    public SimpleLogger() {
        this("ROOT");
    }

    public SimpleLogger(String name) {
        this.name = name;
        this.errorEntryPrefix = "ERROR [" + name + "] ";
        this.warnEntryPrefix = "WARN  [" + name + "] ";
        this.fatalEntryPrefix = "FATAL [" + name + "] ";
        this.infoEntryPrefix = "INFO  [" + name + "] ";
        this.errorOut = System.out;
        this.warnOut = System.out;
        this.fatalOut = System.out;
        this.infoOut = System.out;
    }

    public void debug(String msg) {
    }

    public void debug(String msg, Throwable t) {
    }

    public void error(String msg) {
        this.errorOut.println(this.errorEntryPrefix + msg);
    }

    public void error(String msg, Throwable t) {
        this.errorOut.print(this.errorEntryPrefix + msg + ", Cause: ");
        t.printStackTrace(this.errorOut);
    }

    public void fatal(String msg) {
        this.fatalOut.println(this.fatalEntryPrefix + msg);
    }

    public void fatal(String msg, Throwable t) {
        this.fatalOut.print(this.fatalEntryPrefix + msg + ", Cause: ");
        t.printStackTrace(this.fatalOut);
    }

    public String getName() {
        return this.name;
    }

    public void info(String msg) {
        this.infoOut.println(this.infoEntryPrefix + msg);
    }

    public void info(String msg, Throwable t) {
        this.infoOut.print(this.infoEntryPrefix + msg + ", Cause: ");
        t.printStackTrace(this.infoOut);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(String msg) {
    }

    public void trace(String msg, Throwable t) {
    }

    public void warn(String msg) {
        this.warnOut.println(this.warnEntryPrefix + msg);
    }

    public void warn(String msg, Throwable t) {
        this.warnOut.print(this.warnEntryPrefix + msg + ", Cause: ");
        t.printStackTrace(this.warnOut);
    }
}

