/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.DirectoryServiceListener;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class DirectoryService {
    private static final Map instances = new HashMap();

    public static DirectoryService getInstance() {
        return DirectoryService.getInstance("default");
    }

    public static synchronized DirectoryService getInstance(String instanceId) {
        DirectoryService service = (DirectoryService)instances.get(instanceId = instanceId.trim());
        if (service == null) {
            service = new DefaultDirectoryService(instanceId);
            instances.put(instanceId, service);
        }
        return service;
    }

    public static synchronized Set getAllInstances() {
        return new HashSet(instances.values());
    }

    public abstract void startup(DirectoryServiceListener var1, Hashtable var2) throws NamingException;

    public abstract void shutdown() throws NamingException;

    public abstract void sync() throws NamingException;

    public abstract boolean isStarted();

    public abstract DirectoryServiceConfiguration getConfiguration();

    public abstract Context getJndiContext(String var1) throws NamingException;

    public abstract Context getJndiContext(LdapDN var1, String var2, byte[] var3, String var4, String var5) throws NamingException;
}

