/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.Authenticator;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.configuration.AuthenticatorConfiguration;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.LdapDN;

public abstract class AbstractAuthenticator
implements Authenticator {
    private DirectoryServiceConfiguration factoryCfg;
    private AuthenticatorConfiguration cfg;
    private String authenticatorType;

    protected AbstractAuthenticator(String type) {
        this.authenticatorType = type;
    }

    public DirectoryServiceConfiguration getFactoryConfiguration() {
        return this.factoryCfg;
    }

    public AuthenticatorConfiguration getConfiguration() {
        return this.cfg;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public final void init(DirectoryServiceConfiguration factoryCfg, AuthenticatorConfiguration cfg) throws NamingException {
        this.factoryCfg = factoryCfg;
        this.cfg = cfg;
        this.doInit();
    }

    protected void doInit() throws NamingException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.doDestroy();
        }
        finally {
            this.factoryCfg = null;
            this.cfg = null;
        }
    }

    protected void doDestroy() {
    }

    public abstract LdapPrincipal authenticate(LdapDN var1, ServerContext var2) throws NamingException;

    public void invalidateCache(LdapDN bindDn) {
    }

    protected static LdapPrincipal createLdapPrincipal(String name, AuthenticationLevel authenticationLeve) throws NamingException {
        LdapDN principalDn = new LdapDN(name);
        return new LdapPrincipal((Name)principalDn, AuthenticationLevel.SIMPLE);
    }
}

