/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache {
    private static final String OC_ATTR = "objectClass";
    private static final String MEMBER_ATTR = "member";
    private static final String UNIQUEMEMBER_ATTR = "uniqueMember";
    private static final String GROUPOFNAMES_OC = "groupOfNames";
    private static final String GROUPOFUNIQUENAMES_OC = "groupOfUniqueNames";
    private static final Logger log = LoggerFactory.getLogger((Class)GroupCache.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Map groups = new HashMap();
    private final PartitionNexus nexus;
    private final Hashtable env;
    private Map normalizerMap;
    LdapDN administratorsGroupDn;

    public GroupCache(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.normalizerMap = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = factoryCfg.getPartitionNexus();
        this.env = (Hashtable)factoryCfg.getEnvironment().clone();
        this.administratorsGroupDn = new LdapDN("cn=Administrators,ou=groups,ou=system");
        this.administratorsGroupDn.normalize(this.normalizerMap);
        this.initialize();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize() throws NamingException {
        BranchNode filter = new BranchNode(9);
        filter.addNode((ExprNode)new SimpleNode(OC_ATTR, GROUPOFNAMES_OC, 0));
        filter.addNode((ExprNode)new SimpleNode(OC_ATTR, GROUPOFUNIQUENAMES_OC, 0));
        Iterator suffixes = this.nexus.listSuffixes();
        while (suffixes.hasNext()) {
            String suffix = (String)suffixes.next();
            LdapDN baseDn = new LdapDN(suffix);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration results = this.nexus.search(baseDn, this.env, (ExprNode)filter, ctls);
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.next();
                String groupDn = result.getName();
                groupDn = this.parseNormalized(groupDn).toString();
                Attribute members = this.getMemberAttribute(result.getAttributes());
                if (members != null) {
                    HashSet memberSet = new HashSet(members.size());
                    this.addMembers(memberSet, members);
                    this.groups.put(groupDn, memberSet);
                    continue;
                }
                log.warn("Found group '" + groupDn + "' without any member or uniqueMember attributes");
            }
            results.close();
        }
        if (IS_DEBUG) {
            log.debug("group cache contents on startup:\n" + this.groups);
        }
    }

    private Attribute getMemberAttribute(Attributes entry) {
        Attribute oc = entry.get(OC_ATTR);
        if (oc == null) {
            if (entry.get(MEMBER_ATTR) != null) {
                return entry.get(MEMBER_ATTR);
            }
            if (entry.get(UNIQUEMEMBER_ATTR) != null) {
                return entry.get(UNIQUEMEMBER_ATTR);
            }
            return null;
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)GROUPOFNAMES_OC)) {
            return entry.get(MEMBER_ATTR);
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)GROUPOFUNIQUENAMES_OC)) {
            return entry.get(UNIQUEMEMBER_ATTR);
        }
        return null;
    }

    private void addMembers(Set memberSet, Attribute members) throws NamingException {
        for (int ii = 0; ii < members.size(); ++ii) {
            String memberDn = (String)members.get(ii);
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                log.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not added to GroupCache.", (Throwable)e);
            }
            memberSet.add(memberDn);
        }
    }

    private void removeMembers(Set memberSet, Attribute members) throws NamingException {
        for (int ii = 0; ii < members.size(); ++ii) {
            String memberDn = (String)members.get(ii);
            try {
                memberDn = this.parseNormalized(memberDn).toString();
            }
            catch (NamingException e) {
                log.warn("Malformed member DN in groupOf[Unique]Names entry.  Member not removed from GroupCache.", (Throwable)e);
            }
            memberSet.remove(memberDn);
        }
    }

    public void groupAdded(String upName, Name normName, Attributes entry) throws NamingException {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        HashSet memberSet = new HashSet(members.size());
        this.addMembers(memberSet, members);
        this.groups.put(normName.toString(), memberSet);
        if (IS_DEBUG) {
            log.debug("group cache contents after adding " + normName.toString() + ":\n" + this.groups);
        }
    }

    public void groupDeleted(Name name, Attributes entry) {
        Attribute members = this.getMemberAttribute(entry);
        if (members == null) {
            return;
        }
        this.groups.remove(name.toString());
        if (IS_DEBUG) {
            log.debug("group cache contents after deleting " + name.toString() + ":\n" + this.groups);
        }
    }

    private void modify(Set memberSet, int modOp, Attribute members) throws NamingException {
        switch (modOp) {
            case 1: {
                this.addMembers(memberSet, members);
                break;
            }
            case 2: {
                if (members.size() <= 0) break;
                memberSet.clear();
                this.addMembers(memberSet, members);
                break;
            }
            case 3: {
                this.removeMembers(memberSet, members);
                break;
            }
            default: {
                throw new InternalError("Undefined modify operation value of " + modOp);
            }
        }
    }

    public void groupModified(Name name, ModificationItemImpl[] mods, Attributes entry) throws NamingException {
        Attribute members = null;
        String memberAttrId = null;
        Attribute oc = entry.get(OC_ATTR);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)GROUPOFNAMES_OC)) {
            members = entry.get(MEMBER_ATTR);
            memberAttrId = MEMBER_ATTR;
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)GROUPOFUNIQUENAMES_OC)) {
            members = entry.get(UNIQUEMEMBER_ATTR);
            memberAttrId = UNIQUEMEMBER_ATTR;
        }
        if (members == null) {
            return;
        }
        for (int ii = 0; ii < mods.length; ++ii) {
            if (!memberAttrId.equalsIgnoreCase(mods[ii].getAttribute().getID())) continue;
            Set memberSet = (Set)this.groups.get(name.toString());
            if (memberSet == null) break;
            this.modify(memberSet, mods[ii].getModificationOp(), mods[ii].getAttribute());
            break;
        }
        if (IS_DEBUG) {
            log.debug("group cache contents after modifying " + name.toString() + ":\n" + this.groups);
        }
    }

    public void groupModified(Name name, int modOp, Attributes mods, Attributes entry) throws NamingException {
        Attribute members = this.getMemberAttribute(mods);
        if (members == null) {
            return;
        }
        Set memberSet = (Set)this.groups.get(name.toString());
        if (memberSet != null) {
            this.modify(memberSet, modOp, members);
        }
        if (IS_DEBUG) {
            log.debug("group cache contents after modifying " + name.toString() + ":\n" + this.groups);
        }
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) {
        if (principalDn.toNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
            return true;
        }
        Set members = (Set)this.groups.get(this.administratorsGroupDn.toNormName());
        if (members == null) {
            log.warn("What do you mean there is no administrators group? This is bad news.");
            return false;
        }
        return members.contains(principalDn.toNormName());
    }

    public Set getGroups(String member) throws NamingException {
        try {
            member = this.parseNormalized(member).toString();
        }
        catch (NamingException e) {
            log.warn("Malformed member DN.  Could not find groups for member in GroupCache. Returning empty set for groups!", (Throwable)e);
            return Collections.EMPTY_SET;
        }
        HashSet<LdapDN> memberGroups = null;
        Iterator list = this.groups.keySet().iterator();
        while (list.hasNext()) {
            String group = (String)list.next();
            Set members = (Set)this.groups.get(group);
            if (members == null || !members.contains(member)) continue;
            if (memberGroups == null) {
                memberGroups = new HashSet<LdapDN>();
            }
            memberGroups.add(new LdapDN(group));
        }
        if (memberGroups == null) {
            return Collections.EMPTY_SET;
        }
        return memberGroups;
    }

    public boolean groupRenamed(Name oldName, Name newName) {
        Object members = this.groups.remove(oldName.toString());
        if (members != null) {
            this.groups.put(newName.toString(), members);
            if (IS_DEBUG) {
                log.debug("group cache contents after renaming " + oldName.toString() + ":\n" + this.groups);
            }
            return true;
        }
        return false;
    }
}

