/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.collective.CollectiveAttributesSchemaChecker;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class CollectiveAttributeService
extends BaseInterceptor {
    public static final String COLLECTIVE_ATTRIBUTE_SUBENTRIES = "collectiveAttributeSubentries";
    public static final String EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES_OID = "2.5.18.0";
    public static final String EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES = "excludeAllCollectiveAttributes";
    private AttributeTypeRegistry attrTypeRegistry = null;
    private PartitionNexus nexus = null;
    private CollectiveAttributesSchemaChecker collectiveAttributesSchemaChecker = null;
    private final SearchResultFilter SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            LdapDN name = new LdapDN(result.getName());
            name = LdapDN.normalize((LdapDN)name, (Map)CollectiveAttributeService.this.attrTypeRegistry.getNormalizerMapping());
            Attributes entry = result.getAttributes();
            String[] retAttrs = controls.getReturningAttributes();
            CollectiveAttributeService.this.addCollectiveAttributes(name, entry, retAttrs);
            return true;
        }
    };

    private void addCollectiveAttributes(LdapDN normName, Attributes entry, String[] retAttrs) throws NamingException {
        Attributes entryWithCAS = this.nexus.lookup(normName, new String[]{COLLECTIVE_ATTRIBUTE_SUBENTRIES});
        Attribute caSubentries = entryWithCAS.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
        if (caSubentries == null) {
            return;
        }
        Attribute collectiveExclusions = entry.get("collectiveExclusions");
        HashSet<String> exclusions = new HashSet<String>();
        if (collectiveExclusions != null) {
            if (collectiveExclusions.contains(EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES_OID) || collectiveExclusions.contains(EXCLUDE_ALL_COLLECTIVE_ATTRIBUTES)) {
                return;
            }
            exclusions = new HashSet();
            for (int ii = 0; ii < collectiveExclusions.size(); ++ii) {
                AttributeType attrType = this.attrTypeRegistry.lookup((String)collectiveExclusions.get(ii));
                exclusions.add(attrType.getOid());
            }
        }
        if (retAttrs == null) {
            retAttrs = new String[]{"*"};
        }
        HashSet<String> retIdsSet = new HashSet<String>(retAttrs.length);
        for (int i = 0; i < retAttrs.length; ++i) {
            retIdsSet.add(retAttrs[i].toLowerCase());
        }
        for (int ii = 0; ii < caSubentries.size(); ++ii) {
            String subentryDnStr = (String)caSubentries.get(ii);
            LdapDN subentryDn = new LdapDN(subentryDnStr);
            Attributes subentry = this.nexus.lookup(subentryDn);
            NamingEnumeration<String> attrIds = subentry.getIDs();
            while (attrIds.hasMore()) {
                String attrId = attrIds.next();
                AttributeType attrType = this.attrTypeRegistry.lookup(attrId);
                if (!attrType.isCollective() || exclusions.contains(attrType.getOid())) continue;
                Set allSuperTypes = this.getAllSuperTypes(attrType);
                Iterator it = retIdsSet.iterator();
                while (it.hasNext()) {
                    AttributeType retType;
                    String retId = (String)it.next();
                    if (retId.equals("*") || retId.equals("+") || !allSuperTypes.contains(retType = this.attrTypeRegistry.lookup(retId))) continue;
                    retIdsSet.add(attrId);
                    break;
                }
                if (!retIdsSet.contains("*") && !retIdsSet.contains(attrId)) continue;
                Attribute subentryColAttr = subentry.get(attrId);
                Attribute entryColAttr = entry.get(attrId);
                if (entryColAttr == null) {
                    entryColAttr = new LockableAttributeImpl(attrId);
                    entry.put(entryColAttr);
                }
                for (int jj = 0; jj < subentryColAttr.size(); ++jj) {
                    entryColAttr.add(subentryColAttr.get(jj));
                }
            }
        }
    }

    private Set getAllSuperTypes(AttributeType id) throws NamingException {
        HashSet<AttributeType> allSuperTypes = new HashSet<AttributeType>();
        AttributeType superType = id;
        while (superType != null) {
            if ((superType = superType.getSuperior()) == null) continue;
            allSuperTypes.add(superType);
        }
        return allSuperTypes;
    }

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        this.nexus = factoryCfg.getPartitionNexus();
        this.attrTypeRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        this.collectiveAttributesSchemaChecker = new CollectiveAttributesSchemaChecker(this.nexus, this.attrTypeRegistry);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        Attributes result = nextInterceptor.lookup(name);
        if (result == null) {
            return null;
        }
        this.addCollectiveAttributes(name, result, new String[]{"*"});
        return result;
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        Attributes result = nextInterceptor.lookup(name, attrIds);
        if (result == null) {
            return null;
        }
        this.addCollectiveAttributes(name, result, new String[]{"*"});
        return result;
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        NamingEnumeration e = nextInterceptor.list(base);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.SEARCH_FILTER);
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        NamingEnumeration e = nextInterceptor.search(base, env, filter, searchCtls);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.SEARCH_FILTER);
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
        this.collectiveAttributesSchemaChecker.checkAdd(normName, entry);
        super.add(next, normName, entry);
    }

    public void modify(NextInterceptor next, LdapDN normName, int modOp, Attributes mods) throws NamingException {
        this.collectiveAttributesSchemaChecker.checkModify(normName, modOp, mods);
        super.modify(next, normName, modOp, mods);
    }

    public void modify(NextInterceptor next, LdapDN normName, ModificationItemImpl[] mods) throws NamingException {
        this.collectiveAttributesSchemaChecker.checkModify(normName, mods);
        super.modify(next, normName, mods);
    }
}

