/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.shared.ldap.ldif.Entry;

public class ConfigurationUtil {
    public static Set getTypeSafeSet(Set set, Class type) {
        HashSet newSet = new HashSet();
        ConfigurationUtil.getTypeSafeCollection(set, type, newSet);
        return newSet;
    }

    public static List getTypeSafeList(List list, Class type) {
        ArrayList newList = new ArrayList();
        ConfigurationUtil.getTypeSafeCollection(list, type, newList);
        return newList;
    }

    public static void getTypeSafeCollection(Collection collection, Class type, Collection newCollection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (!type.isAssignableFrom(e.getClass())) {
                throw new ConfigurationException("Invalid element type: " + e.getClass() + " (expected " + type);
            }
            newCollection.add(e);
        }
    }

    public static Set getClonedSet(Set set) {
        HashSet newSet = new HashSet();
        newSet.addAll(set);
        return newSet;
    }

    public static List getClonedList(List list) {
        ArrayList newList = new ArrayList();
        newList.addAll(list);
        return newList;
    }

    public static List getClonedAttributesList(List list) throws CloneNotSupportedException {
        ArrayList<Object> newList = new ArrayList<Object>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            newList.add(((Entry)i.next()).clone());
        }
        return newList;
    }

    public static void validatePortNumber(int port) {
        if (port < 0 || port > 65535) {
            throw new ConfigurationException("Invalid port number: " + port);
        }
    }

    private ConfigurationUtil() {
    }
}

