/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.enumeration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResultFilteringEnumeration
implements NamingEnumeration,
AbandonListener {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchResultFilteringEnumeration.class);
    private final List filters;
    private final NamingEnumeration decorated;
    private SearchResult prefetched;
    private boolean isClosed = false;
    private final SearchControls searchControls;
    private final Invocation invocation;
    private final boolean applyObjectFactories;
    private boolean abandoned = false;

    public SearchResultFilteringEnumeration(NamingEnumeration decorated, SearchControls searchControls, Invocation invocation, SearchResultFilter filter) throws NamingException {
        this.searchControls = searchControls;
        this.invocation = invocation;
        this.filters = new ArrayList();
        this.filters.add(filter);
        this.decorated = decorated;
        this.applyObjectFactories = invocation.getCaller().getEnvironment().containsKey("java.naming.factory.object");
        if (!decorated.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public SearchResultFilteringEnumeration(NamingEnumeration decorated, SearchControls searchControls, Invocation invocation, List filters) throws NamingException {
        this.searchControls = searchControls;
        this.invocation = invocation;
        this.filters = new ArrayList();
        this.filters.addAll(filters);
        this.decorated = decorated;
        this.applyObjectFactories = invocation.getCaller().getEnvironment().containsKey("java.naming.factory.object");
        if (!decorated.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public boolean addResultFilter(SearchResultFilter filter) {
        return this.filters.add(filter);
    }

    public boolean removeResultFilter(SearchResultFilter filter) {
        return this.filters.remove(filter);
    }

    public List getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void close() throws NamingException {
        this.isClosed = true;
        this.decorated.close();
    }

    public boolean hasMore() {
        return !this.isClosed;
    }

    public Object next() throws NamingException {
        SearchResult retVal = this.prefetched;
        this.prefetch();
        return retVal;
    }

    public boolean hasMoreElements() {
        return !this.isClosed;
    }

    public Object nextElement() {
        SearchResult retVal = this.prefetched;
        try {
            this.prefetch();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to prefetch.", e);
        }
        return retVal;
    }

    private void applyObjectFactories(SearchResult result) throws NamingException {
        if (result.getObject() != null || !this.applyObjectFactories) {
            return;
        }
        DirContext ctx = (DirContext)this.invocation.getCaller();
        Hashtable<?, ?> env = ctx.getEnvironment();
        Attributes attrs = result.getAttributes();
        LdapDN name = new LdapDN(result.getName());
        try {
            Object obj = DirectoryManager.getObjectInstance(null, (Name)name, ctx, env, attrs);
            result.setObject(obj);
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            buf.append("ObjectFactories threw exception while attempting to generate an object for ");
            buf.append(result.getName());
            buf.append(". Call on SearchResult.getObject() will return null.");
            log.warn(buf.toString(), (Throwable)e);
        }
    }

    private void prefetch() throws NamingException {
        if (this.abandoned) {
            this.close();
            throw new OperationAbandonedException();
        }
        block0: while (this.decorated.hasMore()) {
            boolean accepted = true;
            SearchResult tmp = (SearchResult)this.decorated.next();
            if (this.filters.isEmpty()) {
                this.prefetched = tmp;
                this.applyObjectFactories(this.prefetched);
                return;
            }
            if (this.filters.size() == 1) {
                accepted = ((SearchResultFilter)this.filters.get(0)).accept(this.invocation, tmp, this.searchControls);
                if (!accepted) continue;
                this.prefetched = tmp;
                this.applyObjectFactories(this.prefetched);
                return;
            }
            for (int ii = 0; ii < this.filters.size(); ++ii) {
                SearchResultFilter filter = (SearchResultFilter)this.filters.get(ii);
                if (!(accepted &= filter.accept(this.invocation, tmp, this.searchControls))) continue block0;
            }
            this.prefetched = tmp;
            this.applyObjectFactories(this.prefetched);
            return;
        }
        this.close();
    }

    public void requestAbandoned(AbandonableRequest req) {
        this.abandoned = true;
    }
}

