/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameAlreadyBoundException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class ExceptionService
extends BaseInterceptor {
    private PartitionNexus nexus;
    private LdapDN subschemSubentryDn;
    private Map normalizerMap;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.normalizerMap = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        Attribute attr = this.nexus.getRootDSE().get("subschemaSubentry");
        this.subschemSubentryDn = new LdapDN((String)attr.get());
        this.subschemSubentryDn.normalize(this.normalizerMap);
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, LdapDN normName, Attributes entry) throws NamingException {
        if (nextInterceptor.hasEntry(normName)) {
            LdapNameAlreadyBoundException ne = new LdapNameAlreadyBoundException(normName.toString() + " already exists!");
            ne.setResolvedName((Name)new LdapDN(normName.getUpName()));
            throw ne;
        }
        LdapDN parentDn = (LdapDN)normName.clone();
        parentDn.remove(normName.size() - 1);
        Attributes attrs = null;
        try {
            attrs = nextInterceptor.lookup(parentDn);
        }
        catch (Exception e) {
            LdapNameNotFoundException e2 = new LdapNameNotFoundException("Parent " + parentDn.getUpName() + " not found");
            e2.setResolvedName((Name)new LdapDN(this.nexus.getMatchedName(parentDn).getUpName()));
            throw e2;
        }
        Attribute objectClass = attrs.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"alias")) {
            String msg = "Attempt to add entry to alias '" + normName.getUpName() + "' not allowed.";
            ResultCodeEnum rc = ResultCodeEnum.ALIASPROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)new LdapDN(parentDn.getUpName()));
            throw e;
        }
        nextInterceptor.add(normName, entry);
    }

    public void delete(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        boolean hasChildren = false;
        NamingEnumeration list = nextInterceptor.list(name);
        if (list.hasMore()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            e.setResolvedName((Name)new LdapDN(name.getUpName()));
            throw e;
        }
        nextInterceptor.delete(name);
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN baseName) throws NamingException {
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, baseName);
        return nextInterceptor.list(baseName);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        return nextInterceptor.lookup(name);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        return nextInterceptor.lookup(name, attrIds);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, int modOp, Attributes attrs) throws NamingException {
        String msg = "Attempt to modify non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        Attributes entry = this.nexus.lookup(name);
        NamingEnumeration<String> attrIds = attrs.getIDs();
        while (attrIds.hasMore()) {
            String attrId = attrIds.next();
            Attribute modAttr = attrs.get(attrId);
            Attribute entryAttr = entry.get(attrId);
            if (modOp != 1 || entryAttr == null) continue;
            for (int ii = 0; ii < modAttr.size(); ++ii) {
                if (!entryAttr.contains(modAttr.get(ii))) continue;
                throw new LdapAttributeInUseException("Trying to add existing value '" + modAttr.get(ii) + "' to attribute " + attrId);
            }
        }
        nextInterceptor.modify(name, modOp, attrs);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, ModificationItemImpl[] items) throws NamingException {
        String msg = "Attempt to modify non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, name);
        Attributes entry = this.nexus.lookup(name);
        for (int ii = 0; ii < items.length; ++ii) {
            Attribute modAttr;
            Attribute entryAttr;
            if (items[ii].getModificationOp() != 1 || (entryAttr = entry.get((modAttr = items[ii].getAttribute()).getID())) == null) continue;
            for (int jj = 0; jj < modAttr.size(); ++jj) {
                if (!entryAttr.contains(modAttr.get(jj))) continue;
                throw new LdapAttributeInUseException("Trying to add existing value '" + modAttr.get(jj) + "' to attribute " + modAttr.getID());
            }
        }
        nextInterceptor.modify(name, items);
    }

    public void modifyRn(NextInterceptor nextInterceptor, LdapDN dn, String newRn, boolean deleteOldRn) throws NamingException {
        String msg = "Attempt to rename non-existant entry: ";
        this.assertHasEntry(nextInterceptor, msg, dn);
        LdapDN newDn = (LdapDN)dn.clone();
        newDn.remove(dn.size() - 1);
        newDn.add(newRn);
        newDn.normalize(this.normalizerMap);
        if (nextInterceptor.hasEntry(newDn)) {
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + newDn.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(newDn.getUpName()));
            throw e;
        }
        nextInterceptor.modifyRn(dn, newRn, deleteOldRn);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, newParentName);
        String rdn = oriChildName.get(oriChildName.size() - 1);
        LdapDN target = (LdapDN)newParentName.clone();
        target.add(rdn);
        if (nextInterceptor.hasEntry(target)) {
            String upRdn = new LdapDN(oriChildName.getUpName()).get(oriChildName.size() - 1);
            LdapDN upTarget = (LdapDN)newParentName.clone();
            upTarget.add(upRdn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        nextInterceptor.move(oriChildName, newParentName);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, msg, newParentName);
        LdapDN target = (LdapDN)newParentName.clone();
        target.add(newRn);
        target.normalize(this.normalizerMap);
        if (nextInterceptor.hasEntry(target)) {
            LdapDN upTarget = (LdapDN)newParentName.clone();
            upTarget.add(newRn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException("target entry " + upTarget.getUpName() + " already exists!");
            e.setResolvedName((Name)new LdapDN(upTarget.getUpName()));
            throw e;
        }
        nextInterceptor.move(oriChildName, newParentName, newRn, deleteOldRn);
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        String msg = "Attempt to search under non-existant entry: ";
        if (base.size() == 0) {
            return nextInterceptor.search(base, env, filter, searchCtls);
        }
        if (this.subschemSubentryDn.toNormName().equalsIgnoreCase(base.toNormName())) {
            return nextInterceptor.search(base, env, filter, searchCtls);
        }
        this.assertHasEntry(nextInterceptor, msg, base);
        return nextInterceptor.search(base, env, filter, searchCtls);
    }

    private void assertHasEntry(NextInterceptor nextInterceptor, String msg, LdapDN dn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        if (!nextInterceptor.hasEntry(dn)) {
            LdapNameNotFoundException e = msg != null ? new LdapNameNotFoundException(msg + dn) : new LdapNameNotFoundException(dn.toString());
            e.setResolvedName((Name)new LdapDN(proxy.getMatchedName(dn).getUpName()));
            throw e;
        }
    }
}

