/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.jndi.ServerDirContext;
import org.apache.directory.server.core.referral.ReferralService;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ServerLdapContext
extends ServerDirContext
implements LdapContext {
    private static final Control[] EMPTY_CONTROLS = new Control[0];
    private Control[] requestControls = EMPTY_CONTROLS;
    private Control[] responseControls = EMPTY_CONTROLS;
    private Control[] connectControls = EMPTY_CONTROLS;
    private transient ReferralService refService;

    public ServerLdapContext(DirectoryService service, Hashtable env) throws NamingException {
        super(service, env);
    }

    ServerLdapContext(DirectoryService service, LdapPrincipal principal, Name dn) throws NamingException {
        super(service, principal, dn);
    }

    public ExtendedResponse extendedOperation(ExtendedRequest request) {
        throw new NotImplementedException();
    }

    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        ServerLdapContext ctx = new ServerLdapContext(this.getService(), this.getPrincipal(), this.getDn());
        ctx.setRequestControls(requestControls);
        return ctx;
    }

    public void reconnect(Control[] connCtls) throws NamingException {
        this.connectControls = connCtls;
    }

    public Control[] getConnectControls() throws NamingException {
        return this.connectControls;
    }

    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.requestControls = requestControls;
    }

    public Control[] getRequestControls() throws NamingException {
        return this.requestControls;
    }

    public Control[] getResponseControls() throws NamingException {
        return this.responseControls;
    }

    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        return super.getNexusProxy().compare(name, oid, value);
    }

    public void ldapUnbind() throws NamingException {
        String bindDn = (String)this.getEnvironment().get("java.naming.security.principal");
        super.getNexusProxy().unbind(new LdapDN(bindDn));
    }

    public boolean isReferral(String name) throws NamingException {
        if (this.refService == null) {
            this.refService = (ReferralService)this.getService().getConfiguration().getInterceptorChain().get("referralService");
        }
        return this.refService.isReferral(name);
    }
}

