/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.exception.LdapSizeLimitExceededException;
import org.apache.directory.shared.ldap.exception.LdapTimeLimitExceededException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;

public class PartitionNexusProxy
extends PartitionNexus {
    public static final Collection LOOKUP_BYPASS;
    public static final Collection GETMATCHEDDN_BYPASS;
    public static final Collection LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS;
    public static final String BYPASS_ALL = "*";
    public static final Collection BYPASS_ALL_COLLECTION;
    private static final Integer ADD_MODOP;
    private static final Integer REMOVE_MODOP;
    private static final Integer REPLACE_MODOP;
    private final Context caller;
    private final DirectoryService service;
    private final DirectoryServiceConfiguration configuration;

    public PartitionNexusProxy(Context caller, DirectoryService service) {
        this.caller = caller;
        this.service = service;
        this.configuration = service.getConfiguration();
    }

    public LdapContext getLdapContext() {
        return this.configuration.getPartitionNexus().getLdapContext();
    }

    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) {
    }

    public void destroy() {
    }

    public Partition getSystemPartition() {
        return this.configuration.getPartitionNexus().getSystemPartition();
    }

    public Partition getPartition(LdapDN dn) throws NamingException {
        return this.configuration.getPartitionNexus().getPartition(dn);
    }

    public LdapDN getSuffix() throws NamingException {
        return this.configuration.getPartitionNexus().getSuffix();
    }

    public LdapDN getUpSuffix() throws NamingException {
        return this.configuration.getPartitionNexus().getUpSuffix();
    }

    public void sync() throws NamingException {
        this.service.sync();
    }

    public void close() throws NamingException {
        this.service.shutdown();
    }

    public boolean isInitialized() {
        return this.service.isStarted();
    }

    public LdapDN getMatchedName(LdapDN dn) throws NamingException {
        return this.getMatchedName(dn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getMatchedName(LdapDN dn, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{dn};
        stack.push(new Invocation(this, this.caller, "getMatchedDn", args, bypass));
        try {
            LdapDN ldapDN = this.configuration.getInterceptorChain().getMatchedName(dn);
            return ldapDN;
        }
        finally {
            stack.pop();
        }
    }

    public LdapDN getSuffix(LdapDN dn) throws NamingException {
        return this.getSuffix(dn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getSuffix(LdapDN dn, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{dn};
        stack.push(new Invocation(this, this.caller, "getSuffix", args, bypass));
        try {
            LdapDN ldapDN = this.configuration.getInterceptorChain().getSuffix(dn);
            return ldapDN;
        }
        finally {
            stack.pop();
        }
    }

    public Iterator listSuffixes() throws NamingException {
        return this.listSuffixes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listSuffixes(Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{};
        stack.push(new Invocation(this, this.caller, "listSuffixes", args, bypass));
        try {
            Iterator iterator = this.configuration.getInterceptorChain().listSuffixes();
            return iterator;
        }
        finally {
            stack.pop();
        }
    }

    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        return this.compare(name, oid, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(LdapDN name, String oid, Object value, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "compare", new Object[]{name, oid, value}, bypass));
        try {
            boolean bl = this.configuration.getInterceptorChain().compare(name, oid, value);
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    public void delete(LdapDN name) throws NamingException {
        this.delete(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(LdapDN name, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "delete", new Object[]{name}, bypass));
        try {
            this.configuration.getInterceptorChain().delete(name);
        }
        finally {
            stack.pop();
        }
    }

    public void add(LdapDN normName, Attributes entry) throws NamingException {
        this.add(normName, entry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LdapDN normName, Attributes entry, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "add", new Object[]{normName, entry}, bypass));
        try {
            this.configuration.getInterceptorChain().add(normName, entry);
        }
        finally {
            stack.pop();
        }
    }

    public void modify(LdapDN name, int modOp, Attributes mods) throws NamingException {
        this.modify(name, modOp, mods, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(LdapDN name, int modOp, Attributes mods, Collection bypass) throws NamingException {
        Integer modOpObj;
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        switch (modOp) {
            case 1: {
                modOpObj = ADD_MODOP;
                break;
            }
            case 3: {
                modOpObj = REMOVE_MODOP;
                break;
            }
            case 2: {
                modOpObj = REPLACE_MODOP;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad modification operation value: " + modOp);
            }
        }
        stack.push(new Invocation(this, this.caller, "modify", new Object[]{name, modOpObj, mods}, bypass));
        try {
            this.configuration.getInterceptorChain().modify(name, modOp, mods);
        }
        finally {
            stack.pop();
        }
    }

    public void modify(LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        this.modify(name, mods, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(LdapDN name, ModificationItemImpl[] mods, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "modify", new Object[]{name, mods}, bypass));
        try {
            this.configuration.getInterceptorChain().modify(name, mods);
        }
        finally {
            stack.pop();
        }
    }

    public NamingEnumeration list(LdapDN base) throws NamingException {
        return this.list(base, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(LdapDN base, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "list", new Object[]{base}, bypass));
        try {
            NamingEnumeration namingEnumeration = this.configuration.getInterceptorChain().list(base);
            return namingEnumeration;
        }
        finally {
            stack.pop();
        }
    }

    public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        NamingEnumeration ne = this.search(base, env, filter, searchCtls, null);
        if (ne instanceof SearchResultFilteringEnumeration) {
            SearchResultFilteringEnumeration results = (SearchResultFilteringEnumeration)ne;
            if ((long)searchCtls.getTimeLimit() + searchCtls.getCountLimit() > 0L) {
                results.addResultFilter(new SearchResultFilter(){
                    final long startTime = System.currentTimeMillis();
                    int count = 1;

                    public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
                        long runtime;
                        if (controls.getTimeLimit() > 0 && (runtime = System.currentTimeMillis() - this.startTime) > (long)controls.getTimeLimit()) {
                            throw new LdapTimeLimitExceededException();
                        }
                        if (controls.getCountLimit() > 0L && (long)this.count > controls.getCountLimit()) {
                            throw new LdapSizeLimitExceededException();
                        }
                        ++this.count;
                        return true;
                    }
                });
            }
        }
        return ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "search", new Object[]{base, env, filter, searchCtls}, bypass));
        try {
            NamingEnumeration namingEnumeration = this.configuration.getInterceptorChain().search(base, env, filter, searchCtls);
            return namingEnumeration;
        }
        finally {
            stack.pop();
        }
    }

    public Attributes lookup(LdapDN name) throws NamingException {
        return this.lookup(name, (Collection)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes lookup(LdapDN name, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "lookup", new Object[]{name}, bypass));
        try {
            Attributes attributes = this.configuration.getInterceptorChain().lookup(name);
            return attributes;
        }
        finally {
            stack.pop();
        }
    }

    public Attributes lookup(LdapDN dn, String[] attrIds) throws NamingException {
        return this.lookup(dn, attrIds, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes lookup(LdapDN dn, String[] attrIds, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "lookup", new Object[]{dn, attrIds}, bypass));
        try {
            Attributes attributes = this.configuration.getInterceptorChain().lookup(dn, attrIds);
            return attributes;
        }
        finally {
            stack.pop();
        }
    }

    public boolean hasEntry(LdapDN name) throws NamingException {
        return this.hasEntry(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(LdapDN name, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "hasEntry", new Object[]{name}, bypass));
        try {
            boolean bl = this.configuration.getInterceptorChain().hasEntry(name);
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    public boolean isSuffix(LdapDN name) throws NamingException {
        return this.isSuffix(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuffix(LdapDN name, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "isSuffix", new Object[]{name}, bypass));
        try {
            boolean bl = this.configuration.getInterceptorChain().isSuffix(name);
            return bl;
        }
        finally {
            stack.pop();
        }
    }

    public void modifyRn(LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        this.modifyRn(name, newRn, deleteOldRn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRn(LdapDN name, String newRn, boolean deleteOldRn, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{name, newRn, deleteOldRn ? Boolean.TRUE : Boolean.FALSE};
        stack.push(new Invocation(this, this.caller, "modifyRn", args, bypass));
        try {
            this.configuration.getInterceptorChain().modifyRn(name, newRn, deleteOldRn);
        }
        finally {
            stack.pop();
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        this.move(oriChildName, newParentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(LdapDN oriChildName, LdapDN newParentName, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "move", new Object[]{oriChildName, newParentName}, bypass));
        try {
            this.configuration.getInterceptorChain().move(oriChildName, newParentName);
        }
        finally {
            stack.pop();
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        this.move(oriChildName, newParentName, newRn, deleteOldRn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{oriChildName, newParentName, newRn, deleteOldRn ? Boolean.TRUE : Boolean.FALSE};
        stack.push(new Invocation(this, this.caller, "move", args, bypass));
        try {
            this.configuration.getInterceptorChain().move(oriChildName, newParentName, newRn, deleteOldRn);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{bindDn, credentials, mechanisms, saslAuthId};
        stack.push(new Invocation(this, this.caller, "bind", args, bypass));
        try {
            this.configuration.getInterceptorChain().bind(bindDn, credentials, mechanisms, saslAuthId);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(LdapDN bindDn, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        Object[] args = new Object[]{bindDn};
        stack.push(new Invocation(this, this.caller, "unbind", args, bypass));
        try {
            this.configuration.getInterceptorChain().unbind(bindDn);
        }
        finally {
            stack.pop();
        }
    }

    public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        this.bind(bindDn, credentials, mechanisms, saslAuthId, null);
    }

    public void unbind(LdapDN bindDn) throws NamingException {
        this.unbind(bindDn, null);
    }

    public Attributes getRootDSE() throws NamingException {
        return this.getRootDSE(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes getRootDSE(Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "getRootDSE", null, bypass));
        try {
            Attributes attributes = this.configuration.getInterceptorChain().getRootDSE();
            return attributes;
        }
        finally {
            stack.pop();
        }
    }

    public void addContextPartition(PartitionConfiguration config) throws NamingException {
        this.addContextPartition(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextPartition(PartitionConfiguration config, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "addContextPartition", new Object[]{config}, bypass));
        try {
            this.configuration.getInterceptorChain().addContextPartition(config);
        }
        finally {
            stack.pop();
        }
    }

    public void removeContextPartition(LdapDN suffix) throws NamingException {
        this.removeContextPartition(suffix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextPartition(LdapDN suffix, Collection bypass) throws NamingException {
        this.ensureStarted();
        InvocationStack stack = InvocationStack.getInstance();
        stack.push(new Invocation(this, this.caller, "removeContextPartition", new Object[]{suffix}, bypass));
        try {
            this.configuration.getInterceptorChain().removeContextPartition(suffix);
        }
        finally {
            stack.pop();
        }
    }

    private void ensureStarted() throws ServiceUnavailableException {
        if (!this.service.isStarted()) {
            throw new ServiceUnavailableException("Directory service is not started.");
        }
    }

    public void registerSupportedExtensions(Set extensionOids) {
        this.configuration.getPartitionNexus().registerSupportedExtensions(extensionOids);
    }

    public void addNamingListener(EventContext ctx, Name name, ExprNode filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        InterceptorChain chain = this.configuration.getInterceptorChain();
        EventService interceptor = (EventService)chain.get("eventService");
        interceptor.addNamingListener(ctx, name, filter, searchControls, namingListener);
    }

    public void removeNamingListener(EventContext ctx, NamingListener namingListener) throws NamingException {
        InterceptorChain chain = this.configuration.getInterceptorChain();
        if (chain == null) {
            return;
        }
        EventService interceptor = (EventService)chain.get("eventService");
        interceptor.removeNamingListener(ctx, namingListener);
    }

    static {
        BYPASS_ALL_COLLECTION = Collections.singleton(BYPASS_ALL);
        ADD_MODOP = new Integer(1);
        REMOVE_MODOP = new Integer(3);
        REPLACE_MODOP = new Integer(2);
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("referralService");
        c.add("eventService");
        LOOKUP_BYPASS = Collections.unmodifiableCollection(c);
        c = new HashSet();
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("referralService");
        c.add("eventService");
        GETMATCHEDDN_BYPASS = Collections.unmodifiableCollection(c);
        c = new HashSet();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("referralService");
        c.add("eventService");
        LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS = Collections.unmodifiableCollection(c);
    }
}

