/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;

public class IndexAssertionEnumeration
implements NamingEnumeration {
    private final IndexRecord prefetched = new IndexRecord();
    private final IndexRecord candidate = new IndexRecord();
    private final NamingEnumeration underlying;
    private final Map candidates;
    private final IndexAssertion assertion;
    private final boolean checkDups;
    private boolean hasMore = true;

    public IndexAssertionEnumeration(NamingEnumeration underlying, IndexAssertion assertion) throws NamingException {
        this.underlying = underlying;
        this.candidates = null;
        this.assertion = assertion;
        this.checkDups = false;
        this.prefetch();
    }

    public IndexAssertionEnumeration(NamingEnumeration underlying, IndexAssertion assertion, boolean enableDupCheck) throws NamingException {
        this.underlying = underlying;
        this.candidates = new HashMap();
        this.assertion = assertion;
        this.checkDups = enableDupCheck;
        this.prefetch();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object next() throws NamingException {
        this.candidate.copy(this.prefetched);
        this.prefetch();
        return this.candidate;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        IndexRecord rec = null;
        while (this.underlying.hasMore()) {
            rec = (IndexRecord)this.underlying.next();
            if (!this.assertion.assertCandidate(rec)) continue;
            if (this.checkDups) {
                boolean dup = this.candidates.containsKey(rec.getEntryId());
                if (dup) continue;
                this.prefetched.copy(rec);
                this.candidates.put(rec.getEntryId(), rec.getEntryId());
                return;
            }
            this.prefetched.copy(rec);
            return;
        }
        this.close();
    }
}

