/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.math.BigInteger;
import java.util.Comparator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Evaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.ScopeEvaluator;
import org.apache.directory.server.core.partition.impl.btree.SubstringEvaluator;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ByteArrayComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 3;
    private BTreePartition db;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator;

    public LeafEvaluator(BTreePartition db, OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry, ScopeEvaluator scopeEvaluator, SubstringEvaluator substringEvaluator) {
        this.db = db;
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
        this.scopeEvaluator = scopeEvaluator;
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, record);
        }
        switch (((LeafNode)node).getAssertionType()) {
            case 5: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case 0: {
                return this.evalEquality((SimpleNode)node, record);
            }
            case 6: {
                throw new NotImplementedException();
            }
            case 3: {
                return this.evalGreater((SimpleNode)node, record, true);
            }
            case 4: {
                return this.evalGreater((SimpleNode)node, record, false);
            }
            case 1: {
                String attrId = ((PresenceNode)node).getAttribute();
                return this.evalPresence(attrId, record);
            }
            case 2: {
                return this.substringEvaluator.evaluate(node, record);
            }
        }
        throw new NamingException("Unrecognized leaf node type: " + ((LeafNode)node).getAssertionType());
    }

    private boolean evalGreater(SimpleNode node, IndexRecord record, boolean isGreater) throws NamingException {
        Attribute attr;
        String attrId = node.getAttribute();
        BigInteger id = record.getEntryId();
        if (this.db.hasUserIndexOn(attrId)) {
            Index idx = this.db.getUserIndex(attrId);
            if (isGreater) {
                return idx.hasValue(node.getValue(), id, true);
            }
            return idx.hasValue(node.getValue(), id, false);
        }
        if (null == record.getAttributes()) {
            record.setAttributes(this.db.lookup(id));
        }
        if (null == (attr = AttributeUtils.getAttribute((Attributes)record.getAttributes(), (AttributeType)this.attributeTypeRegistry.lookup(node.getAttribute())))) {
            return false;
        }
        Normalizer normalizer = this.getNormalizer(attrId);
        Comparator comparator = this.getComparator(attrId);
        Object filterValue = node.getValue();
        NamingEnumeration<?> list = attr.getAll();
        if (isGreater) {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 < comparator.compare(filterValue, value)) continue;
                return true;
            }
        } else {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 > comparator.compare(filterValue, value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evalPresence(String attrId, IndexRecord rec) throws NamingException {
        Attributes attrs;
        if (this.db.hasUserIndexOn(attrId)) {
            Index idx = this.db.getExistanceIndex();
            return idx.hasValue(attrId, rec.getEntryId());
        }
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.db.lookup(rec.getEntryId()));
        }
        if ((attrs = rec.getAttributes()) == null) {
            return false;
        }
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(attrId));
        return null != ServerUtils.getAttribute(type, attrs);
    }

    private boolean evalEquality(SimpleNode node, IndexRecord rec) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.hasValue(node.getValue(), rec.getEntryId());
        }
        Normalizer normalizer = this.getNormalizer(node.getAttribute());
        Comparator comparator = this.getComparator(node.getAttribute());
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.db.lookup(rec.getEntryId()));
        }
        Attributes attrs = rec.getAttributes();
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(node.getAttribute()));
        Attribute attr = ServerUtils.getAttribute(type, attrs);
        if (null == attr) {
            return false;
        }
        if (attr.contains(node.getValue())) {
            return true;
        }
        Object filterValue = node.getValue();
        if (attr.contains(filterValue)) {
            return true;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            Object value = normalizer.normalize(list.next());
            if (0 != comparator.compare(value, filterValue)) continue;
            return true;
        }
        return false;
    }

    private Comparator getComparator(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        if (mrule == null) {
            return ByteArrayComparator.INSTANCE;
        }
        return mrule.getComparator();
    }

    private Normalizer getNormalizer(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        if (mrule == null) {
            return NoOpNormalizer.INSTANCE;
        }
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = null;
        String oid = this.oidRegistry.getOid(attrId);
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        switch (matchType) {
            case 0: {
                mrule = type.getEquality();
                break;
            }
            case 3: {
                mrule = type.getSubstr();
                break;
            }
            case 1: {
                mrule = type.getOrdering();
                break;
            }
            default: {
                throw new NamingException("Unknown match type: " + matchType);
            }
        }
        return mrule;
    }
}

