/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jdbm.helper.Serializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.AttributeSerializer;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;

public class AttributesSerializer
implements Serializer {
    private static final long serialVersionUID = -3756830073760754086L;
    private static final byte SEPARATOR = -1;

    public Object deserialize(byte[] buf) throws IOException {
        if (buf.length == 0) {
            return new LockableAttributesImpl();
        }
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        for (int pos = 0; pos < buf.length; ++pos) {
            Object value;
            String id = AttributeSerializer.readString(buf, pos);
            LockableAttributeImpl attr = new LockableAttributeImpl(id);
            if (buf[pos += (id.length() << 1) + 4] == 0) {
                ++pos;
                while (pos < buf.length && buf[pos] != -1) {
                    value = AttributeSerializer.readString(buf, pos);
                    pos += (((String)value).length() << 1) + 4;
                    attr.add(value);
                }
            } else {
                ++pos;
                while (pos < buf.length && buf[pos] != -1) {
                    value = AttributeSerializer.readBytes(buf, pos);
                    pos += ((Object)value).length + 4;
                    attr.add(value);
                }
            }
            attrs.put((Attribute)attr);
        }
        return attrs;
    }

    public byte[] serialize(Object attrsObj) throws IOException {
        Attributes attrs = (Attributes)attrsObj;
        byte[] buf = new byte[this.calculateSize(attrs)];
        int pos = 0;
        try {
            NamingEnumeration<? extends Attribute> ii = attrs.getAll();
            while (ii.hasMore()) {
                Object value;
                NamingEnumeration<?> jj;
                Attribute attr = ii.next();
                pos = AttributeSerializer.write(buf, attr.getID(), pos);
                Object first = attr.get();
                if (first instanceof String) {
                    buf[pos] = 0;
                    ++pos;
                    jj = attr.getAll();
                    while (jj.hasMore()) {
                        value = (String)jj.next();
                        pos = AttributeSerializer.write(buf, (String)value, pos);
                    }
                } else {
                    buf[pos] = 1;
                    ++pos;
                    jj = attr.getAll();
                    while (jj.hasMore()) {
                        value = (byte[])jj.next();
                        pos = AttributeSerializer.write(buf, (byte[])value, pos);
                    }
                }
                if (!ii.hasMore()) continue;
                buf[pos] = -1;
                ++pos;
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attributes and/or their values.");
            ioe.initCause(e);
            throw ioe;
        }
        return buf;
    }

    public int calculateSize(Attributes attrs) throws IOException {
        int size = 0;
        try {
            NamingEnumeration<? extends Attribute> ii = attrs.getAll();
            while (ii.hasMore()) {
                Attribute attr = ii.next();
                if (ii.hasMore()) {
                    size += AttributeSerializer.calculateSize(attr) + 1;
                    continue;
                }
                size += AttributeSerializer.calculateSize(attr);
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attributes.");
            ioe.initCause(e);
            throw ioe;
        }
        return size;
    }
}

