/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jdbm.btree.BTree;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.core.partition.impl.btree.Tuple;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class BTreeTupleEnumeration
implements NamingEnumeration {
    private final Object key;
    private final Tuple tuple = new Tuple();
    private final jdbm.helper.Tuple jdbmTuple = new jdbm.helper.Tuple();
    private final boolean stepForward;
    private TupleBrowser browser;
    private boolean success = false;

    BTreeTupleEnumeration(BTree tree, Comparator comparator, Object key, Object val, boolean isGreaterThan) throws LdapNamingException {
        this.key = key;
        this.stepForward = isGreaterThan;
        try {
            Object nextVal;
            int compared;
            boolean gotNextOk;
            this.browser = tree.browse(val);
            if (!isGreaterThan && (gotNextOk = this.browser.getNext(this.jdbmTuple)) && (compared = comparator.compare(val, nextVal = this.jdbmTuple.getKey())) != 0) {
                this.browser.getPrevious(this.jdbmTuple);
            }
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    BTreeTupleEnumeration(BTree tree, Object key) throws NamingException {
        this.key = key;
        this.stepForward = true;
        try {
            this.browser = tree.browse();
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private void prefetch() throws IOException {
        this.success = this.stepForward ? this.browser.getNext(this.jdbmTuple) : this.browser.getPrevious(this.jdbmTuple);
    }

    public void close() throws NamingException {
        this.success = false;
    }

    public boolean hasMore() throws NamingException {
        return this.success;
    }

    public Object next() throws NamingException {
        if (!this.success) {
            throw new NoSuchElementException();
        }
        this.tuple.setKey(this.key);
        this.tuple.setValue(this.jdbmTuple.getKey());
        try {
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
        return this.tuple;
    }

    public boolean hasMoreElements() {
        return this.success;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new NoSuchElementException("Got IO Failure on btree: " + e.getCause().getMessage());
        }
    }
}

