/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Comparator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DnComparator
implements Comparator {
    private final AttributeTypeRegistry attrRegistry;

    public DnComparator(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public int compare(Object obj0, Object obj1) {
        LdapDN dn0 = null;
        LdapDN dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (NamingException e) {
            // empty catch block
        }
        return dn0.compareTo(dn1);
    }

    public LdapDN getDn(Object obj) throws NamingException {
        LdapDN dn = null;
        if (obj instanceof LdapDN) {
            dn = LdapDN.normalize((LdapDN)((LdapDN)obj), (Map)this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof Name) {
            dn = new LdapDN((Name)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof String) {
            dn = new LdapDN((String)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else {
            throw new IllegalStateException("I do not know how to handle dn comparisons with objects of class: " + obj.getClass());
        }
        return dn;
    }
}

