/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistryMonitor;
import org.apache.directory.server.core.schema.SyntaxRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSyntaxRegistry;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.util.JoinIterator;

public class GlobalSyntaxRegistry
implements SyntaxRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private SyntaxRegistryMonitor monitor;
    private BootstrapSyntaxRegistry bootstrap;

    public GlobalSyntaxRegistry(BootstrapSyntaxRegistry bootstrap, OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new SyntaxRegistryMonitorAdapter();
        this.bootstrap = bootstrap;
        if (this.bootstrap == null) {
            throw new NullPointerException("the bootstrap registry cannot be null");
        }
    }

    public void setMonitor(SyntaxRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, Syntax dITContentRule) throws NamingException {
        if (this.byOid.containsKey(dITContentRule.getOid()) || this.bootstrap.hasSyntax(dITContentRule.getOid())) {
            NamingException e = new NamingException("dITContentRule w/ OID " + dITContentRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITContentRule, e);
            throw e;
        }
        this.oidRegistry.register(dITContentRule.getName(), dITContentRule.getOid());
        this.byOid.put(dITContentRule.getOid(), dITContentRule);
        this.oidToSchema.put(dITContentRule.getOid(), schema);
        this.monitor.registered(dITContentRule);
    }

    public Syntax lookup(String id) throws NamingException {
        if (this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            Syntax dITContentRule = (Syntax)this.byOid.get(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        if (this.bootstrap.hasSyntax(id)) {
            Syntax dITContentRule = this.bootstrap.lookup(id);
            this.monitor.lookedUp(dITContentRule);
            return dITContentRule;
        }
        NamingException e = new NamingException("dITContentRule w/ OID " + id + " not registered!");
        this.monitor.lookupFailed(id, e);
        throw e;
    }

    public boolean hasSyntax(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id)) || this.bootstrap.hasSyntax(id);
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        if (this.bootstrap.hasSyntax(id)) {
            return this.bootstrap.getSchemaName(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return new JoinIterator(new Iterator[]{this.byOid.values().iterator(), this.bootstrap.list()});
    }
}

