/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.schema.ObjectClassRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaChecker {
    private static Logger log = LoggerFactory.getLogger((Class)SchemaChecker.class);

    public static void preventStructuralClassRemovalOnModifyReplace(ObjectClassRegistry registry, Name name, int mod, Attribute attribute) throws NamingException {
        if (mod != 2) {
            return;
        }
        if (!"objectclass".equalsIgnoreCase(attribute.getID())) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
        }
        for (int ii = 0; ii < attribute.size(); ++ii) {
            ObjectClass ocType = registry.lookup((String)attribute.get(ii));
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
    }

    public static void preventStructuralClassRemovalOnModifyReplace(ObjectClassRegistry registry, Name name, int mod, Attributes attributes) throws NamingException {
        if (mod != 2) {
            return;
        }
        Attribute objectClass = attributes.get("objectClass");
        if (objectClass == null) {
            return;
        }
        if (objectClass.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
        }
        for (int ii = 0; ii < objectClass.size(); ++ii) {
            ObjectClass ocType = registry.lookup((String)objectClass.get(ii));
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
    }

    public static void preventStructuralClassRemovalOnModifyRemove(ObjectClassRegistry registry, Name name, int mod, Attribute attribute, Attribute entryObjectClasses) throws NamingException {
        int ii;
        if (mod != 3) {
            return;
        }
        if (!"objectclass".equalsIgnoreCase(attribute.getID())) {
            return;
        }
        for (int ii2 = 0; ii2 < attribute.size(); ++ii2) {
            Object value = attribute.get(ii2);
            if (!"".equals(value)) continue;
            attribute.remove(ii2);
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
        }
        Attribute cloned = (Attribute)entryObjectClasses.clone();
        for (ii = 0; ii < attribute.size(); ++ii) {
            cloned.remove(attribute.get(ii));
        }
        for (ii = 0; ii < cloned.size(); ++ii) {
            ObjectClass ocType = registry.lookup((String)cloned.get(ii));
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
    }

    public static void preventStructuralClassRemovalOnModifyRemove(ObjectClassRegistry registry, Name name, int mod, Attributes attributes, Attribute entryObjectClasses) throws NamingException {
        int ii;
        if (mod != 3) {
            return;
        }
        Attribute objectClass = attributes.get("objectClass");
        if (objectClass == null) {
            return;
        }
        for (int ii2 = 0; ii2 < objectClass.size(); ++ii2) {
            Object value = objectClass.get(ii2);
            if (!"".equals(value)) continue;
            objectClass.remove(ii2);
        }
        if (objectClass.size() == 0) {
            String msg = "Modify operation leaves no structural objectClass for entry " + name;
            if (log.isInfoEnabled()) {
                log.info(msg + ".  Raising LdapSchemaViolationException.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
        }
        Attribute cloned = (Attribute)entryObjectClasses.clone();
        for (ii = 0; ii < objectClass.size(); ++ii) {
            cloned.remove(objectClass.get(ii));
        }
        for (ii = 0; ii < cloned.size(); ++ii) {
            ObjectClass ocType = registry.lookup((String)cloned.get(ii));
            if (ocType.getType() != ObjectClassTypeEnum.STRUCTURAL) continue;
            return;
        }
        String msg = "Modify operation leaves no structural objectClass for entry " + name;
        if (log.isInfoEnabled()) {
            log.info(msg + ".  Raising LdapSchemaViolationException.");
        }
        throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSMODSPROHIBITED);
    }

    public static void preventRdnChangeOnModifyReplace(Name name, int mod, Attribute attribute, OidRegistry oidRegistry) throws NamingException {
        String id;
        if (mod != 2) {
            return;
        }
        Set rdnAttributes = SchemaChecker.getRdnAttributes(name);
        if (!rdnAttributes.contains(id = oidRegistry.getOid(attribute.getID()))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation attempts to delete RDN attribute ";
            msg = msg + id + " on entry " + name + " violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
        for (int ii = 0; ii < attribute.size(); ++ii) {
            if (attribute.contains(rdnValue)) continue;
            String msg = "Modify operation attempts to delete RDN attribute values in use for ";
            msg = msg + id + " on entry " + name + " and violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
        }
    }

    public static void preventRdnChangeOnModifyReplace(Name name, int mod, Attributes attributes, OidRegistry oidRegistry) throws NamingException {
        if (mod != 2) {
            return;
        }
        Set rdnAttributes = SchemaChecker.getRdnAttributes(name);
        NamingEnumeration<String> list = attributes.getIDs();
        while (list.hasMore()) {
            String id = list.next();
            if (!rdnAttributes.contains(id)) continue;
            if (attributes.get(id).size() == 0) {
                String msg = "Modify operation attempts to delete RDN attribute ";
                msg = msg + id + " on entry " + name + " violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
            Attribute rdnAttr = attributes.get(id);
            for (int ii = 0; ii < rdnAttr.size(); ++ii) {
                if (rdnAttr.contains(rdnValue)) continue;
                String msg = "Modify operation attempts to delete RDN attribute values in use for ";
                msg = msg + id + " on entry " + name + " and violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
        }
    }

    public static void preventRdnChangeOnModifyRemove(Name name, int mod, Attribute attribute, OidRegistry oidRegistry) throws NamingException {
        String id;
        if (mod != 3) {
            return;
        }
        Set rdnAttributes = SchemaChecker.getRdnAttributes(name);
        if (!rdnAttributes.contains(oidRegistry.getOid(id = attribute.getID()))) {
            return;
        }
        if (attribute.size() == 0) {
            String msg = "Modify operation attempts to delete RDN attribute ";
            msg = msg + id + " on entry " + name + " violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
        }
        String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
        for (int ii = 0; ii < attribute.size(); ++ii) {
            if (!rdnValue.equals(attribute.get(ii))) continue;
            String msg = "Modify operation attempts to delete RDN attribute values in use for ";
            msg = msg + id + " on entry " + name + " and violates schema constraints";
            if (log.isInfoEnabled()) {
                log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
            }
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
        }
    }

    public static void preventRdnChangeOnModifyRemove(Name name, int mod, Attributes attributes, OidRegistry oidRegistry) throws NamingException {
        if (mod != 3) {
            return;
        }
        Set rdnAttributes = SchemaChecker.getRdnAttributes(name);
        NamingEnumeration<String> list = attributes.getIDs();
        while (list.hasMore()) {
            String id = list.next();
            if (!rdnAttributes.contains(id)) continue;
            if (attributes.get(id).size() == 0) {
                String msg = "Modify operation attempts to delete RDN attribute ";
                msg = msg + id + " on entry " + name + " violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
            String rdnValue = SchemaChecker.getRdnValue(id, name, oidRegistry);
            Attribute rdnAttr = attributes.get(id);
            for (int ii = 0; ii < rdnAttr.size(); ++ii) {
                if (!rdnValue.equals(rdnAttr.get(ii))) continue;
                String msg = "Modify operation attempts to delete RDN attribute values in use for ";
                msg = msg + id + " on entry " + name + " and violates schema constraints";
                if (log.isInfoEnabled()) {
                    log.info(msg + ". SchemaChecker is throwing a schema violation exception.");
                }
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
        }
    }

    private static String getRdnValue(String id, Name name, OidRegistry oidRegistry) throws NamingException {
        String idOid = oidRegistry.getOid(id);
        if (idOid == null) {
            log.error("The id {} does not have any OID. It should be a wrong AttributeType.", (Object)id);
            throw new NamingException("Wrong AttributeType, does not have an associated OID : " + id);
        }
        String[] comps = NamespaceTools.getCompositeComponents((String)name.get(name.size() - 1));
        for (int ii = 0; ii < comps.length; ++ii) {
            String rdnAttrId = NamespaceTools.getRdnAttribute((String)comps[ii]);
            String rdnAttrOid = oidRegistry.getOid(rdnAttrId);
            if (rdnAttrOid == null) {
                log.error("The id {} does not have any OID. It should be a wrong AttributeType.", (Object)rdnAttrOid);
                throw new NamingException("Wrong AttributeType, does not have an associated OID : " + rdnAttrOid);
            }
            if (!rdnAttrOid.equalsIgnoreCase(idOid)) continue;
            return NamespaceTools.getRdnValue((String)comps[ii]);
        }
        return null;
    }

    private static Set getRdnAttributes(Name name) throws NamingException {
        String[] comps = NamespaceTools.getCompositeComponents((String)name.get(name.size() - 1));
        HashSet<String> attributes = new HashSet<String>();
        for (int ii = 0; ii < comps.length; ++ii) {
            attributes.add(NamespaceTools.getRdnAttribute((String)comps[ii]));
        }
        return attributes;
    }
}

