/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.GlobalRegistries;
import org.apache.directory.server.core.schema.ObjectClassRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.SchemaChecker;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaService
extends BaseInterceptor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String BINARY_KEY = "java.naming.ldap.attributes.binary";
    private static Logger log = LoggerFactory.getLogger((Class)SchemaService.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private PartitionNexus nexus;
    private BinaryAttributeFilter binaryAttributeFilter;
    private TopFilter topFilter;
    private List filters = new ArrayList();
    private GlobalRegistries globalRegistries;
    private Set binaries;
    private LdapDN subschemaSubentryDn;
    private String startUpTimeStamp = DateUtils.getGeneralizedTime();
    private Map superiors;
    private Map allMay;
    private Map allMust;
    private Map allowed;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Initializing SchemaService...");
        }
        this.nexus = factoryCfg.getPartitionNexus();
        this.globalRegistries = factoryCfg.getGlobalRegistries();
        this.binaryAttributeFilter = new BinaryAttributeFilter();
        this.topFilter = new TopFilter();
        this.filters.add(this.binaryAttributeFilter);
        this.filters.add(this.topFilter);
        this.binaries = (Set)factoryCfg.getEnvironment().get(BINARY_KEY);
        String subschemaSubentry = (String)this.nexus.getRootDSE().get("subschemaSubentry").get();
        this.subschemaSubentryDn = new LdapDN(subschemaSubentry);
        this.subschemaSubentryDn.normalize(this.globalRegistries.getAttributeTypeRegistry().getNormalizerMapping());
        this.computeSuperiors();
        if (IS_DEBUG) {
            log.debug("SchemaService Initialized !");
        }
    }

    private void computeMustAttributes(ObjectClass objectClass, Set atSeen) throws NamingException {
        List parents = (List)this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mustList = new ArrayList<AttributeType>();
        ArrayList<AttributeType> allowedList = new ArrayList<AttributeType>();
        HashSet<String> mustSeen = new HashSet<String>();
        this.allMust.put(objectClass.getOid(), mustList);
        this.allowed.put(objectClass.getOid(), allowedList);
        Iterator objectClasses = parents.iterator();
        while (objectClasses.hasNext()) {
            ObjectClass parent = (ObjectClass)objectClasses.next();
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (int i = 0; i < mustParent.length; ++i) {
                AttributeType attributeType = mustParent[i];
                String oid = attributeType.getOid();
                if (mustSeen.contains(oid)) continue;
                mustSeen.add(oid);
                mustList.add(attributeType);
                allowedList.add(attributeType);
                atSeen.add(attributeType.getOid());
            }
        }
    }

    private void computeMayAttributes(ObjectClass objectClass, Set atSeen) throws NamingException {
        List parents = (List)this.superiors.get(objectClass.getOid());
        ArrayList<AttributeType> mayList = new ArrayList<AttributeType>();
        HashSet<String> maySeen = new HashSet<String>();
        List allowedList = (List)this.allowed.get(objectClass.getOid());
        this.allMay.put(objectClass.getOid(), mayList);
        Iterator objectClasses = parents.iterator();
        while (objectClasses.hasNext()) {
            ObjectClass parent = (ObjectClass)objectClasses.next();
            AttributeType[] mustParent = parent.getMustList();
            if (mustParent == null || mustParent.length == 0) continue;
            for (int i = 0; i < mustParent.length; ++i) {
                AttributeType attributeType = mustParent[i];
                String oid = attributeType.getOid();
                if (maySeen.contains(oid)) continue;
                maySeen.add(oid);
                mayList.add(attributeType);
                if (atSeen.contains(oid)) continue;
                allowedList.add(attributeType);
            }
        }
    }

    private void computeOCSuperiors(ObjectClass objectClass, List superiors, Set ocSeen) throws NamingException {
        ObjectClass[] parents = objectClass.getSuperClasses();
        if (parents != null && parents.length != 0) {
            for (int i = 0; i < parents.length; ++i) {
                ObjectClass parent = parents[i];
                if ("top".equals(parent.getName())) continue;
                this.computeOCSuperiors(parent, superiors, ocSeen);
                String oid = parents[i].getOid();
                if (ocSeen.contains(oid)) continue;
                superiors.add(parent);
                ocSeen.add(oid);
            }
        }
    }

    private void computeSuperiors() throws NamingException {
        Iterator objectClasses = this.globalRegistries.getObjectClassRegistry().list();
        this.superiors = new HashMap();
        this.allMust = new HashMap();
        this.allMay = new HashMap();
        this.allowed = new HashMap();
        while (objectClasses.hasNext()) {
            ArrayList ocSuperiors = new ArrayList();
            ObjectClass objectClass = (ObjectClass)objectClasses.next();
            this.superiors.put(objectClass.getOid(), ocSuperiors);
            this.computeOCSuperiors(objectClass, ocSuperiors, new HashSet());
            HashSet atSeen = new HashSet();
            this.computeMustAttributes(objectClass, atSeen);
            this.computeMayAttributes(objectClass, atSeen);
            this.superiors.put(objectClass.getName(), ocSuperiors);
        }
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        NamingEnumeration e = nextInterceptor.list(base);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.binaryAttributeFilter);
    }

    private void filterAttributesToReturn(SearchControls searchCtls) throws NamingException {
        String[] attributes = searchCtls.getReturningAttributes();
        if (attributes == null || attributes.length == 0) {
            return;
        }
        HashMap<String, String> filteredAttrs = new HashMap<String, String>();
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            if ("*".equals(attribute) || "+".equals(attribute) || "1.1".equals(attribute)) {
                if (filteredAttrs.containsKey(attribute)) continue;
                filteredAttrs.put(attribute, attribute);
                continue;
            }
            if (this.globalRegistries.getAttributeTypeRegistry().hasAttributeType(attribute)) {
                String oid = this.globalRegistries.getOidRegistry().getOid(attribute);
                if (filteredAttrs.containsKey(oid)) continue;
                filteredAttrs.put(oid, attribute);
                continue;
            }
            log.warn("The attribute " + attribute + " was not recognized as a valid attributeType.");
        }
        if (filteredAttrs.size() == attributes.length) {
            return;
        }
        String[] newAttributesList = new String[filteredAttrs.size()];
        int pos = 0;
        Iterator keys = filteredAttrs.keySet().iterator();
        while (keys.hasNext()) {
            newAttributesList[pos++] = (String)filteredAttrs.get(keys.next());
        }
        searchCtls.setReturningAttributes(newAttributesList);
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        this.filterAttributesToReturn(searchCtls);
        if (!this.subschemaSubentryDn.toNormName().equals(base.toNormName())) {
            NamingEnumeration e = nextInterceptor.search(base, env, filter, searchCtls);
            Invocation invocation = InvocationStack.getInstance().peek();
            if (searchCtls.getReturningAttributes() != null) {
                return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.topFilter);
            }
            return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.filters);
        }
        if (searchCtls.getSearchScope() == 0) {
            PresenceNode node;
            if (filter instanceof SimpleNode) {
                SimpleNode node2 = (SimpleNode)filter;
                String objectClass = null;
                objectClass = node2.getValue() instanceof String ? (String)node2.getValue() : node2.getValue().toString();
                String objectClassOid = null;
                if (this.globalRegistries.getObjectClassRegistry().hasObjectClass(objectClass)) {
                    objectClassOid = this.globalRegistries.getObjectClassRegistry().lookup(objectClass).getName();
                }
                if (node2.getAttribute().equalsIgnoreCase("2.5.4.0") && ("top".equalsIgnoreCase(objectClassOid) || "subschema".equalsIgnoreCase(objectClassOid)) && node2.getAssertionType() == 0) {
                    Attributes attrs = this.getSubschemaEntry(searchCtls.getReturningAttributes());
                    SearchResult result = new SearchResult(base.toString(), (Object)null, attrs);
                    return new SingletonEnumeration((Object)result);
                }
                return new EmptyEnumeration();
            }
            if (filter instanceof PresenceNode && (node = (PresenceNode)filter).getAttribute().equalsIgnoreCase("2.5.4.0")) {
                Attributes attrs = this.getSubschemaEntry(searchCtls.getReturningAttributes());
                SearchResult result = new SearchResult(base.toString(), (Object)null, attrs);
                return new SingletonEnumeration((Object)result);
            }
        }
        return new EmptyEnumeration();
    }

    private Attributes getSubschemaEntry(String[] ids) throws NamingException {
        Iterator list;
        LockableAttributeImpl attr;
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> set = new HashSet<String>();
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        for (int ii = 0; ii < ids.length; ++ii) {
            set.add(ids[ii].toLowerCase());
        }
        boolean returnAllOperationalAttributes = set.contains("+");
        if (returnAllOperationalAttributes || set.contains("objectclasses")) {
            attr = new LockableAttributeImpl("objectClasses");
            list = this.globalRegistries.getObjectClassRegistry().list();
            while (list.hasNext()) {
                ObjectClass oc = (ObjectClass)list.next();
                attr.add((Object)SchemaUtils.render((ObjectClass)oc).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("attributetypes")) {
            attr = new LockableAttributeImpl("attributeTypes");
            list = this.globalRegistries.getAttributeTypeRegistry().list();
            while (list.hasNext()) {
                AttributeType at = (AttributeType)list.next();
                attr.add((Object)SchemaUtils.render((AttributeType)at).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("matchingrules")) {
            attr = new LockableAttributeImpl("matchingRules");
            list = this.globalRegistries.getMatchingRuleRegistry().list();
            while (list.hasNext()) {
                MatchingRule mr = (MatchingRule)list.next();
                attr.add((Object)SchemaUtils.render((MatchingRule)mr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("matchingruleuse")) {
            attr = new LockableAttributeImpl("matchingRuleUse");
            list = this.globalRegistries.getMatchingRuleUseRegistry().list();
            while (list.hasNext()) {
                MatchingRuleUse mru = (MatchingRuleUse)list.next();
                attr.add((Object)SchemaUtils.render((MatchingRuleUse)mru).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("ldapsyntaxes")) {
            attr = new LockableAttributeImpl("ldapSyntaxes");
            list = this.globalRegistries.getSyntaxRegistry().list();
            while (list.hasNext()) {
                Syntax syntax = (Syntax)list.next();
                attr.add((Object)SchemaUtils.render((Syntax)syntax).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("ditcontentrules")) {
            attr = new LockableAttributeImpl("dITContentRules");
            list = this.globalRegistries.getDitContentRuleRegistry().list();
            while (list.hasNext()) {
                DITContentRule dcr = (DITContentRule)list.next();
                attr.add((Object)SchemaUtils.render((DITContentRule)dcr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("ditstructurerules")) {
            attr = new LockableAttributeImpl("dITStructureRules");
            list = this.globalRegistries.getDitStructureRuleRegistry().list();
            while (list.hasNext()) {
                DITStructureRule dsr = (DITStructureRule)list.next();
                attr.add((Object)SchemaUtils.render((DITStructureRule)dsr).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("nameforms")) {
            attr = new LockableAttributeImpl("nameForms");
            list = this.globalRegistries.getNameFormRegistry().list();
            while (list.hasNext()) {
                NameForm nf = (NameForm)list.next();
                attr.add((Object)SchemaUtils.render((NameForm)nf).toString());
            }
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("createtimestamp")) {
            attr = new LockableAttributeImpl("createTimestamp");
            attr.add((Object)this.startUpTimeStamp);
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("modifytimestamp")) {
            attr = new LockableAttributeImpl("modifyTimestamp");
            attr.add((Object)this.startUpTimeStamp);
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("creatorsname")) {
            attr = new LockableAttributeImpl("creatorsName");
            attr.add((Object)"uid=admin,ou=system");
            attrs.put((Attribute)attr);
        }
        if (returnAllOperationalAttributes || set.contains("modifiersname")) {
            attr = new LockableAttributeImpl("modifiersName");
            attr.add((Object)"uid=admin,ou=system");
            attrs.put((Attribute)attr);
        }
        int minSetSize = 0;
        if (set.contains("+")) {
            ++minSetSize;
        }
        if (set.contains("*")) {
            ++minSetSize;
        }
        if (set.contains("ref")) {
            ++minSetSize;
        }
        if (set.contains("*") || set.contains("objectclass") || set.size() == minSetSize) {
            attr = new LockableAttributeImpl("objectClass");
            attr.add((Object)"top");
            attr.add((Object)"subschema");
            attrs.put((Attribute)attr);
        }
        if (set.contains("*") || set.contains("cn") || set.contains("commonname") || set.size() == minSetSize) {
            attrs.put("cn", (Object)"schema");
        }
        return attrs;
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        Attributes result = nextInterceptor.lookup(name);
        this.filterBinaryAttributes(result);
        this.filterObjectClass(result);
        return result;
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        Attributes result = nextInterceptor.lookup(name, attrIds);
        if (result == null) {
            return null;
        }
        this.filterBinaryAttributes(result);
        this.filterObjectClass(result);
        return result;
    }

    private boolean isRequired(String attrId, Attribute objectClass) throws NamingException {
        OidRegistry oidRegistry = this.globalRegistries.getOidRegistry();
        ObjectClassRegistry registry = this.globalRegistries.getObjectClassRegistry();
        if (!oidRegistry.hasOid(attrId)) {
            return false;
        }
        String attrOid = oidRegistry.getOid(attrId);
        for (int ii = 0; ii < objectClass.size(); ++ii) {
            ObjectClass ocSpec = registry.lookup((String)objectClass.get(ii));
            AttributeType[] mustList = ocSpec.getMustList();
            for (int jj = 0; jj < mustList.length; ++jj) {
                if (!mustList[jj].getOid().equals(attrOid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompleteRemoval(Attribute change, Attributes entry) throws NamingException {
        if (change.size() == 0) {
            return true;
        }
        Attribute changedEntryAttr = (Attribute)entry.get(change.getID()).clone();
        for (int jj = 0; jj < change.size(); ++jj) {
            changedEntryAttr.remove(change.get(jj));
        }
        return changedEntryAttr.size() == 0;
    }

    private Attribute getResultantObjectClasses(int modOp, Attribute changes, Attribute existing) throws NamingException {
        if (changes == null && existing == null) {
            return new LockableAttributeImpl("objectClass");
        }
        if (changes == null) {
            return existing;
        }
        if (existing == null && modOp == 1) {
            return changes;
        }
        if (existing == null) {
            return new LockableAttributeImpl("objectClasses");
        }
        switch (modOp) {
            case 1: {
                return AttributeUtils.getUnion((Attribute)existing, (Attribute)changes);
            }
            case 2: {
                return (Attribute)changes.clone();
            }
            case 3: {
                return AttributeUtils.getDifference((Attribute)existing, (Attribute)changes);
            }
        }
        throw new InternalError("");
    }

    private void getSuperiors(ObjectClass oc, Set ocSeen, List result) throws NamingException {
        ObjectClass[] superiors = oc.getSuperClasses();
        for (int i = 0; i < superiors.length; ++i) {
            ObjectClass parent = superiors[i];
            if ("top".equals(parent.getName())) continue;
            if (!ocSeen.contains(parent.getOid())) {
                ocSeen.add(parent.getOid());
                result.add(parent);
            }
            this.getSuperiors(parent, ocSeen, result);
        }
    }

    private boolean getObjectClasses(Attribute objectClasses, List result) throws NamingException {
        HashSet<String> ocSeen = new HashSet<String>();
        ObjectClassRegistry registry = this.globalRegistries.getObjectClassRegistry();
        NamingEnumeration<?> ocs = objectClasses.getAll();
        boolean hasExtensibleObject = false;
        while (ocs.hasMoreElements()) {
            ObjectClass oc;
            String objectClassName = (String)ocs.nextElement();
            if ("top".equals(objectClassName)) continue;
            if ("extensibleObject".equalsIgnoreCase(objectClassName)) {
                hasExtensibleObject = true;
            }
            if (!ocSeen.contains((oc = registry.lookup(objectClassName)).getOid())) {
                ocSeen.add(oc.getOid());
                result.add(oc);
            }
            this.getSuperiors(oc, ocSeen, result);
        }
        return hasExtensibleObject;
    }

    private Set getAllMust(NamingEnumeration objectClasses) throws NamingException {
        HashSet<String> must = new HashSet<String>();
        while (objectClasses.hasMoreElements()) {
            String ocName = (String)objectClasses.nextElement();
            ObjectClass oc = this.globalRegistries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMustList();
            if (types == null || types.length <= 0) continue;
            for (int j = 0; j < types.length; ++j) {
                String oid = types[j].getOid();
                must.add(oid);
            }
        }
        return must;
    }

    private Set getAllAllowed(NamingEnumeration objectClasses, Set must) throws NamingException {
        HashSet<String> allowed = new HashSet<String>(must);
        allowed.add(this.globalRegistries.getOidRegistry().getOid("objectClass"));
        while (objectClasses.hasMoreElements()) {
            String ocName = (String)objectClasses.nextElement();
            ObjectClass oc = this.globalRegistries.getObjectClassRegistry().lookup(ocName);
            AttributeType[] types = oc.getMayList();
            if (types == null || types.length <= 0) continue;
            for (int j = 0; j < types.length; ++j) {
                String oid = types[j].getOid();
                allowed.add(oid);
            }
        }
        return allowed;
    }

    private void alterObjectClasses(Attribute objectClassAttr) throws NamingException {
        HashSet<String> objectClasses = new HashSet<String>();
        objectClasses.add("top");
        NamingEnumeration<?> ocList = objectClassAttr.getAll();
        while (ocList.hasMoreElements()) {
            List ocSuperiors;
            String ocName = (String)ocList.nextElement();
            if (ocName.equalsIgnoreCase("top")) continue;
            String ocLowerName = ocName.toLowerCase();
            ObjectClass objectClass = this.globalRegistries.getObjectClassRegistry().lookup(ocLowerName);
            if (!objectClasses.contains(ocLowerName)) {
                objectClasses.add(ocLowerName);
            }
            if ((ocSuperiors = (List)this.superiors.get(objectClass.getOid())) == null || ocSuperiors.size() == 0) continue;
            Iterator iter = ocSuperiors.iterator();
            while (iter.hasNext()) {
                ObjectClass oc = (ObjectClass)iter.next();
                if (objectClasses.contains(oc.getName().toLowerCase())) continue;
                objectClasses.add(oc.getName());
            }
        }
        objectClassAttr.clear();
        Iterator iter = objectClasses.iterator();
        while (iter.hasNext()) {
            objectClassAttr.add(iter.next());
        }
    }

    public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        if (entry == null) {
            log.error("No entry with this name :{}", (Object)name);
            throw new LdapNameNotFoundException("The entry which name is " + name + " is not found.");
        }
        Attribute objectClass = this.getResultantObjectClasses(modOp, mods.get("objectClass"), entry.get("objectClass"));
        ObjectClassRegistry ocRegistry = this.globalRegistries.getObjectClassRegistry();
        AttributeTypeRegistry atRegistry = this.globalRegistries.getAttributeTypeRegistry();
        NamingEnumeration<String> changes = mods.getIDs();
        Attributes tmpEntryForAdd = (Attributes)entry.clone();
        while (changes.hasMore()) {
            String id = changes.next();
            Attribute change = mods.get(id);
            if (!atRegistry.hasAttributeType(change.getID()) && !AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"extensibleObject")) {
                throw new LdapInvalidAttributeIdentifierException("unrecognized attributeID " + change.getID());
            }
            if (modOp == 1) {
                tmpEntryForAdd.put(change);
                if (change.size() == 0) {
                    throw new LdapInvalidAttributeValueException("No value is not a valid value for an attribute.", ResultCodeEnum.INVALIDATTRIBUTESYNTAX);
                }
            }
            if (modOp == 3 && entry.get(change.getID()) == null) {
                throw new LdapNoSuchAttributeException();
            }
            if (modOp != 3 || !this.isRequired(change.getID(), objectClass) || !this.isCompleteRemoval(change, entry)) continue;
            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
        if (modOp == 1) {
            this.assertNumberOfAttributeValuesValid(tmpEntryForAdd);
        }
        if (modOp == 3) {
            SchemaChecker.preventRdnChangeOnModifyRemove((Name)name, modOp, mods, this.globalRegistries.getOidRegistry());
            SchemaChecker.preventStructuralClassRemovalOnModifyRemove(ocRegistry, (Name)name, modOp, mods, objectClass);
        }
        if (modOp == 2) {
            SchemaChecker.preventRdnChangeOnModifyReplace((Name)name, modOp, mods, this.globalRegistries.getOidRegistry());
            SchemaChecker.preventStructuralClassRemovalOnModifyReplace(ocRegistry, (Name)name, modOp, mods);
            this.assertNumberOfAttributeValuesValid(mods);
        }
        if (mods.get("objectClass") != null) {
            Attribute alteredObjectClass = (Attribute)objectClass.clone();
            this.alterObjectClasses(alteredObjectClass);
            if (!alteredObjectClass.equals(objectClass)) {
                Attribute ocMods = mods.get("objectClass");
                switch (modOp) {
                    case 1: {
                        if (AttributeUtils.containsValueCaseIgnore((Attribute)ocMods, (Object)"top")) {
                            ocMods.remove("top");
                        }
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 3: {
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.remove(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 2: {
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                }
            }
        }
        next.modify(name, modOp, mods);
    }

    public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        if (entry == null) {
            log.error("No entry with this name :{}", (Object)name);
            throw new LdapNameNotFoundException("The entry which name is " + name + " is not found.");
        }
        Attributes tmpEntry = (Attributes)entry.clone();
        HashSet<String> modset = new HashSet<String>();
        ModificationItemImpl objectClassMod = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            if (mods[ii].getAttribute().getID().equalsIgnoreCase("objectclass")) {
                objectClassMod = mods[ii];
            }
            if (mods[ii].getAttribute().size() == 0 && mods[ii].getModificationOp() == 1) {
                throw new LdapInvalidAttributeValueException("No value is not a valid value for an attribute.", ResultCodeEnum.INVALIDATTRIBUTESYNTAX);
            }
            StringBuffer keybuf = new StringBuffer();
            keybuf.append(mods[ii].getModificationOp());
            keybuf.append(mods[ii].getAttribute().getID());
            for (int jj = 0; jj < mods[ii].getAttribute().size(); ++jj) {
                keybuf.append(mods[ii].getAttribute().get(jj));
            }
            if (modset.add(keybuf.toString()) || mods[ii].getModificationOp() != 1) continue;
            throw new LdapAttributeInUseException("found two copies of the following modification item: " + mods[ii]);
        }
        Attribute objectClass = objectClassMod == null ? entry.get("objectClass") : this.getResultantObjectClasses(objectClassMod.getModificationOp(), objectClassMod.getAttribute(), entry.get("objectClass"));
        ObjectClassRegistry ocRegistry = this.globalRegistries.getObjectClassRegistry();
        AttributeTypeRegistry atRegistry = this.globalRegistries.getAttributeTypeRegistry();
        if (mods.length == 1 && mods[0].getAttribute().size() == 0 && mods[0].getModificationOp() == 2 && !atRegistry.hasAttributeType(mods[0].getAttribute().getID())) {
            return;
        }
        block12: for (int ii = 0; ii < mods.length; ++ii) {
            int modOp = mods[ii].getModificationOp();
            Attribute change = mods[ii].getAttribute();
            if (!atRegistry.hasAttributeType(change.getID()) && !AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"extensibleObject")) {
                throw new LdapInvalidAttributeIdentifierException();
            }
            AttributeType attributeType = atRegistry.lookup(change.getID());
            if (!attributeType.isCanUserModify()) {
                throw new NoPermissionException("Cannot modify the attribute '" + change.getID() + "'");
            }
            switch (modOp) {
                case 1: {
                    NamingEnumeration<?> values;
                    Attribute attr = tmpEntry.get(change.getID());
                    if (attr != null) {
                        values = change.getAll();
                        while (values.hasMoreElements()) {
                            attr.add(values.nextElement());
                        }
                        continue block12;
                    }
                    attr = new LockableAttributeImpl(change.getID());
                    values = change.getAll();
                    while (values.hasMoreElements()) {
                        attr.add(values.nextElement());
                    }
                    tmpEntry.put(attr);
                    continue block12;
                }
                case 3: {
                    if (tmpEntry.get(change.getID()) == null) {
                        log.error("Trying to remove an inexistant attribute: " + change.getID());
                        throw new LdapNoSuchAttributeException();
                    }
                    if (change.size() == 0) {
                        if (this.isRequired(change.getID(), objectClass)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECTCLASSVIOLATION);
                        }
                    } else {
                        if (this.isRequired(change.getID(), objectClass) && this.isCompleteRemoval(change, entry)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECTCLASSVIOLATION);
                        }
                        Attribute modified = tmpEntry.remove(change.getID());
                        NamingEnumeration<?> values = change.getAll();
                        while (values.hasMoreElements()) {
                            modified.remove(values.next());
                        }
                        if (modified.size() == 0 && this.isRequired(change.getID(), objectClass)) {
                            log.error("Trying to remove a required attribute: " + change.getID());
                            throw new LdapSchemaViolationException(ResultCodeEnum.OBJECTCLASSVIOLATION);
                        }
                        tmpEntry.put(modified);
                    }
                    SchemaChecker.preventRdnChangeOnModifyRemove((Name)name, modOp, change, this.globalRegistries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyRemove(ocRegistry, (Name)name, modOp, change, objectClass);
                    continue block12;
                }
                case 2: {
                    SchemaChecker.preventRdnChangeOnModifyReplace((Name)name, modOp, change, this.globalRegistries.getOidRegistry());
                    SchemaChecker.preventStructuralClassRemovalOnModifyReplace(ocRegistry, (Name)name, modOp, change);
                    Attribute attr = tmpEntry.get(change.getID());
                    if (attr != null) {
                        tmpEntry.remove(change.getID());
                    }
                    attr = new LockableAttributeImpl(change.getID());
                    NamingEnumeration<?> values = change.getAll();
                    if (!values.hasMoreElements()) continue block12;
                    while (values.hasMoreElements()) {
                        attr.add(values.nextElement());
                    }
                    tmpEntry.put(attr);
                }
            }
        }
        this.check(name, tmpEntry);
        if (objectClassMod != null) {
            Attribute alteredObjectClass = (Attribute)objectClass.clone();
            this.alterObjectClasses(alteredObjectClass);
            if (!alteredObjectClass.equals(objectClass)) {
                Attribute ocMods = objectClassMod.getAttribute();
                switch (objectClassMod.getModificationOp()) {
                    case 1: {
                        if (AttributeUtils.containsValueCaseIgnore((Attribute)ocMods, (Object)"top")) {
                            ocMods.remove("top");
                        }
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 3: {
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.remove(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                    case 2: {
                        for (int ii = 0; ii < alteredObjectClass.size(); ++ii) {
                            if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)alteredObjectClass.get(ii))) continue;
                            ocMods.add(alteredObjectClass.get(ii));
                        }
                        break;
                    }
                }
            }
        }
        next.modify(name, mods);
    }

    private void filterObjectClass(Attributes entry) throws NamingException {
        ArrayList objectClasses = new ArrayList();
        Attribute oc = entry.get("objectClass");
        if (oc != null) {
            this.getObjectClasses(oc, objectClasses);
            entry.remove("objectClass");
            LockableAttributeImpl newOc = new LockableAttributeImpl("objectClass");
            for (int i = 0; i < objectClasses.size(); ++i) {
                Object currentOC = objectClasses.get(i);
                if (currentOC instanceof String) {
                    newOc.add(currentOC);
                    continue;
                }
                newOc.add(((ObjectClass)currentOC).getName());
            }
            newOc.add("top");
            entry.put((Attribute)newOc);
        }
    }

    private void filterBinaryAttributes(Attributes entry) throws NamingException {
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String id = list.next();
            AttributeType type = null;
            boolean asBinary = false;
            if (!this.globalRegistries.getAttributeTypeRegistry().hasAttributeType(id)) continue;
            type = this.globalRegistries.getAttributeTypeRegistry().lookup(id);
            asBinary = !type.getSyntax().isHumanReadible();
            if (!(asBinary = asBinary || this.binaries.contains(type))) continue;
            Attribute attribute = entry.get(id);
            LockableAttributeImpl binary = new LockableAttributeImpl(id);
            for (int i = 0; i < attribute.size(); ++i) {
                Object value = attribute.get(i);
                if (value instanceof String) {
                    binary.add(i, StringTools.getBytesUtf8((String)((String)value)));
                    continue;
                }
                binary.add(i, value);
            }
            entry.remove(id);
            entry.put((Attribute)binary);
        }
    }

    private void check(LdapDN dn, Attributes entry) throws NamingException {
        NamingEnumeration<String> attrEnum = entry.getIDs();
        while (attrEnum.hasMoreElements()) {
            String name = (String)attrEnum.nextElement();
            if (this.globalRegistries.getAttributeTypeRegistry().hasAttributeType(name)) continue;
            throw new LdapInvalidAttributeIdentifierException(name + " not found in attribute registry!");
        }
        Attribute objectClassAttr = entry.get("objectClass");
        ArrayList ocs = new ArrayList();
        this.alterObjectClasses(objectClassAttr);
        Set must = this.getAllMust(objectClassAttr.getAll());
        Set allowed = this.getAllAllowed(objectClassAttr.getAll(), must);
        boolean hasExtensibleObject = this.getObjectClasses(objectClassAttr, ocs);
        this.assertRequiredAttributesPresent(dn, entry, must);
        this.assertNumberOfAttributeValuesValid(entry);
        if (!hasExtensibleObject) {
            this.assertAllAttributesAllowed(dn, entry, allowed);
        }
        this.assertHumanReadible(entry);
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes attrs) throws NamingException {
        this.check(normName, attrs);
        next.add(normName, attrs);
    }

    private void assertNumberOfAttributeValuesValid(Attributes attributes) throws InvalidAttributeValueException, NamingException {
        NamingEnumeration<? extends Attribute> list = attributes.getAll();
        while (list.hasMore()) {
            Attribute attribute = list.next();
            this.assertNumberOfAttributeValuesValid(attribute);
        }
    }

    private void assertNumberOfAttributeValuesValid(Attribute attribute) throws InvalidAttributeValueException, NamingException {
        AttributeTypeRegistry registry = this.globalRegistries.getAttributeTypeRegistry();
        if (attribute.size() > 1 && registry.lookup(attribute.getID()).isSingleValue()) {
            throw new LdapInvalidAttributeValueException("More than one value has been provided for the single-valued attribute: " + attribute.getID(), ResultCodeEnum.CONSTRAINTVIOLATION);
        }
    }

    private void assertRequiredAttributesPresent(LdapDN dn, Attributes entry, Set must) throws NamingException {
        NamingEnumeration<? extends Attribute> attributes = entry.getAll();
        while (attributes.hasMoreElements() && must.size() > 0) {
            Attribute attribute = (Attribute)attributes.nextElement();
            String oid = this.globalRegistries.getOidRegistry().getOid(attribute.getID());
            must.remove(oid);
        }
        if (must.size() != 0) {
            throw new LdapSchemaViolationException("Required attributes " + must + " not found within entry " + dn.getUpName(), ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
    }

    private void assertHumanReadible(Attributes entry) throws NamingException {
        Attribute attribute;
        NamingEnumeration<? extends Attribute> attributes = entry.getAll();
        boolean isEntryModified = false;
        Attributes cloneEntry = null;
        while (attributes.hasMoreElements()) {
            attribute = (Attribute)attributes.nextElement();
            AttributeType attributeType = this.globalRegistries.getAttributeTypeRegistry().lookup(attribute.getID());
            if (!attributeType.getSyntax().isHumanReadible()) continue;
            NamingEnumeration<?> values = attribute.getAll();
            Attribute clone = null;
            boolean isModified = false;
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (value instanceof String) continue;
                if (value instanceof byte[]) {
                    try {
                        String valStr = new String((byte[])value, "UTF-8");
                        if (!isModified) {
                            isModified = true;
                            clone = (Attribute)attribute.clone();
                        }
                        clone.remove(value);
                        clone.add(valStr);
                        continue;
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new NamingException("The value is not a valid String");
                    }
                }
                throw new NamingException("The value stored in an Human Readible attribute is not a String");
            }
            if (!isModified) continue;
            if (!isEntryModified) {
                cloneEntry = (Attributes)entry.clone();
                isEntryModified = true;
            }
            cloneEntry.remove(attribute.getID());
            cloneEntry.put(clone);
        }
        if (isEntryModified) {
            attributes = cloneEntry.getAll();
            while (attributes.hasMoreElements()) {
                attribute = (Attribute)attributes.nextElement();
                entry.remove(attribute.getID());
                entry.put(attribute);
            }
        }
    }

    private void assertAllAttributesAllowed(LdapDN dn, Attributes attributes, Set allowed) throws NamingException {
        Attribute objectClass = attributes.get("objectclass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"extensibleobject")) {
            return;
        }
        NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
        while (attrs.hasMoreElements()) {
            Attribute attribute = (Attribute)attrs.nextElement();
            String attrId = attribute.getID();
            String attrOid = this.globalRegistries.getOidRegistry().getOid(attrId);
            AttributeType attributeType = this.globalRegistries.getAttributeTypeRegistry().lookup(attrOid);
            if (attributeType.isCollective() || attributeType.getUsage() != UsageEnum.USERAPPLICATIONS || allowed.contains(attrOid)) continue;
            throw new LdapSchemaViolationException("Attribute " + attribute.getID() + " not declared in objectClasses of entry " + dn.getUpName(), ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
    }

    private class TopFilter
    implements SearchResultFilter {
        private TopFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            SchemaService.this.filterObjectClass(result.getAttributes());
            return true;
        }
    }

    private class BinaryAttributeFilter
    implements SearchResultFilter {
        private BinaryAttributeFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            SchemaService.this.filterBinaryAttributes(result.getAttributes());
            return true;
        }
    }
}

