/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.DITContentRuleRegistry;
import org.apache.directory.server.core.schema.DITContentRuleRegistryMonitor;
import org.apache.directory.server.core.schema.DITContentRuleRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.schema.DITContentRule;

public class BootstrapDitContentRuleRegistry
implements DITContentRuleRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private DITContentRuleRegistryMonitor monitor;

    public BootstrapDitContentRuleRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new DITContentRuleRegistryMonitorAdapter();
    }

    public void setMonitor(DITContentRuleRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, DITContentRule dITContentRule) throws NamingException {
        if (this.byOid.containsKey(dITContentRule.getOid())) {
            NamingException e = new NamingException("dITContentRule w/ OID " + dITContentRule.getOid() + " has already been registered!");
            this.monitor.registerFailed(dITContentRule, e);
            throw e;
        }
        this.oidRegistry.register(dITContentRule.getName(), dITContentRule.getOid());
        this.byOid.put(dITContentRule.getOid(), dITContentRule);
        this.oidToSchema.put(dITContentRule.getOid(), schema);
        this.monitor.registered(dITContentRule);
    }

    public DITContentRule lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("dITContentRule w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        DITContentRule dITContentRule = (DITContentRule)this.byOid.get(id);
        this.monitor.lookedUp(dITContentRule);
        return dITContentRule;
    }

    public boolean hasDITContentRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

