/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.NameFormRegistry;
import org.apache.directory.server.core.schema.NameFormRegistryMonitor;
import org.apache.directory.server.core.schema.NameFormRegistryMonitorAdapter;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.schema.NameForm;

public class BootstrapNameFormRegistry
implements NameFormRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private NameFormRegistryMonitor monitor;

    public BootstrapNameFormRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new NameFormRegistryMonitorAdapter();
    }

    public void setMonitor(NameFormRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, NameForm nameForm) throws NamingException {
        if (this.byOid.containsKey(nameForm.getOid())) {
            NamingException e = new NamingException("nameForm w/ OID " + nameForm.getOid() + " has already been registered!");
            this.monitor.registerFailed(nameForm, e);
            throw e;
        }
        this.oidToSchema.put(nameForm.getOid(), schema);
        this.oidRegistry.register(nameForm.getName(), nameForm.getOid());
        this.byOid.put(nameForm.getOid(), nameForm);
        this.monitor.registered(nameForm);
    }

    public NameForm lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("nameForm w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        NameForm nameForm = (NameForm)this.byOid.get(id);
        this.monitor.lookedUp(nameForm);
        return nameForm;
    }

    public boolean hasNameForm(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

