/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.subtree.Subentry;
import org.apache.directory.server.core.subtree.SubentryCache;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SubentriesControl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationParser;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentryService
extends BaseInterceptor {
    private static final String SUBENTRY_CONTROL = "1.3.6.1.4.1.4203.1.10.1";
    private static final String SUBENTRY_OBJECTCLASS = "subentry";
    private static final String SUBENTRY_OBJECTCLASS_OID = "2.5.17.0";
    public static final String AC_AREA = "accessControlSpecificArea";
    public static final String AC_INNERAREA = "accessControlInnerArea";
    public static final String AC_SUBENTRIES = "accessControlSubentries";
    public static final String SCHEMA_AREA = "subschemaAdminSpecificArea";
    public static final String SCHEMA_SUBENTRY = "subschemaSubentry";
    public static final String COLLECTIVE_AREA = "collectiveAttributeSpecificArea";
    public static final String COLLECTIVE_ATTRIBUTE_SUBENTRIES = "collectiveAttributeSubentries";
    public static final String COLLECTIVE_INNERAREA = "collectiveAttributeInnerArea";
    public static final String[] SUBENTRY_OPATTRS = new String[]{"accessControlSubentries", "subschemaSubentry", "collectiveAttributeSubentries"};
    private static final Logger log = LoggerFactory.getLogger((Class)SubentryService.class);
    private final SubentryCache subentryCache = new SubentryCache();
    private DirectoryServiceConfiguration factoryCfg;
    private SubtreeSpecificationParser ssParser;
    private SubtreeEvaluator evaluator;
    private PartitionNexus nexus;
    private AttributeTypeRegistry attrRegistry;
    private OidRegistry oidRegistry;
    private AttributeType objectClassType;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        this.nexus = factoryCfg.getPartitionNexus();
        this.factoryCfg = factoryCfg;
        this.attrRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        this.oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        this.objectClassType = this.attrRegistry.lookup(this.oidRegistry.getOid("objectClass"));
        this.ssParser = new SubtreeSpecificationParser(new NormalizerMappingResolver(){

            public Map getNormalizerMapping() throws NamingException {
                return SubentryService.this.attrRegistry.getNormalizerMapping();
            }
        }, this.attrRegistry.getNormalizerMapping());
        this.evaluator = new SubtreeEvaluator(factoryCfg.getGlobalRegistries().getOidRegistry());
        Iterator suffixes = this.nexus.listSuffixes();
        SimpleNode filter = new SimpleNode("objectclass", SUBENTRY_OBJECTCLASS, 0);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"subtreeSpecification", "objectClass"});
        while (suffixes.hasNext()) {
            LdapDN suffix = new LdapDN((String)suffixes.next());
            suffix.normalize(this.attrRegistry.getNormalizerMapping());
            NamingEnumeration subentries = this.nexus.search(suffix, factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SubtreeSpecification ss;
                SearchResult result = (SearchResult)subentries.next();
                Attributes subentry = result.getAttributes();
                String dn = result.getName();
                String subtree = (String)subentry.get("subtreeSpecification").get();
                try {
                    ss = this.ssParser.parse(subtree);
                }
                catch (Exception e) {
                    log.warn("Failed while parsing subtreeSpecification for " + dn);
                    continue;
                }
                LdapDN dnName = new LdapDN(dn);
                dnName.normalize(this.attrRegistry.getNormalizerMapping());
                this.subentryCache.setSubentry(dnName.toString(), ss, this.getSubentryTypes(subentry));
            }
        }
    }

    private int getSubentryTypes(Attributes subentry) throws NamingException {
        int types = 0;
        Attribute oc = subentry.get("objectClass");
        if (oc == null) {
            throw new LdapSchemaViolationException("A subentry must have an objectClass attribute", ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"accessControlSubentry")) {
            types |= 4;
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"subschema")) {
            types |= 2;
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)"collectiveAttributeSubentry")) {
            types |= 1;
        }
        return types;
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        NamingEnumeration e = nextInterceptor.list(base);
        Invocation invocation = InvocationStack.getInstance().peek();
        if (!this.isSubentryVisible(invocation)) {
            return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, new HideSubentriesFilter());
        }
        return e;
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        NamingEnumeration e = nextInterceptor.search(base, env, filter, searchCtls);
        Invocation invocation = InvocationStack.getInstance().peek();
        if (searchCtls.getSearchScope() == 0) {
            return e;
        }
        if (!this.isSubentryVisible(invocation)) {
            return new SearchResultFilteringEnumeration(e, searchCtls, invocation, new HideSubentriesFilter());
        }
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, new HideEntriesFilter());
    }

    private boolean isSubentryVisible(Invocation invocation) throws NamingException {
        Control[] reqControls = ((LdapContext)invocation.getCaller()).getRequestControls();
        if (reqControls == null || reqControls.length <= 0) {
            return false;
        }
        for (int ii = 0; ii < reqControls.length; ++ii) {
            if (!reqControls[ii].getID().equals(SUBENTRY_CONTROL)) continue;
            SubentriesControl subentriesControl = (SubentriesControl)reqControls[ii];
            return subentriesControl.isVisible();
        }
        return false;
    }

    public Attributes getSubentryAttributes(Name dn, Attributes entryAttrs) throws NamingException {
        LockableAttributesImpl subentryAttrs = new LockableAttributesImpl();
        Attribute objectClasses = entryAttrs.get("objectClass");
        Iterator list = this.subentryCache.nameIterator();
        while (list.hasNext()) {
            Attribute operational;
            String subentryDnStr = (String)list.next();
            LdapDN subentryDn = new LdapDN(subentryDnStr);
            LdapDN apDn = (LdapDN)subentryDn.clone();
            apDn.remove(apDn.size() - 1);
            Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!this.evaluator.evaluate(ss, (Name)apDn, dn, objectClasses)) continue;
            if (subentry.isAccessControlSubentry()) {
                operational = subentryAttrs.get(AC_SUBENTRIES);
                if (operational == null) {
                    operational = new LockableAttributeImpl(AC_SUBENTRIES);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.toString());
            }
            if (subentry.isSchemaSubentry()) {
                operational = subentryAttrs.get(SCHEMA_SUBENTRY);
                if (operational == null) {
                    operational = new LockableAttributeImpl(SCHEMA_SUBENTRY);
                    subentryAttrs.put(operational);
                }
                operational.add(subentryDn.toString());
            }
            if (!subentry.isCollectiveSubentry()) continue;
            operational = subentryAttrs.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
            if (operational == null) {
                operational = new LockableAttributeImpl(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
                subentryAttrs.put(operational);
            }
            operational.add(subentryDn.toString());
        }
        return subentryAttrs;
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
        Attribute objectClasses = entry.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS)) {
            SubtreeSpecification ss;
            LdapDN apName = (LdapDN)normName.clone();
            apName.remove(normName.size() - 1);
            Attributes ap = this.nexus.lookup(apName);
            Attribute administrativeRole = ap.get("administrativeRole");
            if (administrativeRole == null || administrativeRole.size() <= 0) {
                throw new LdapNoSuchAttributeException("Administration point " + apName + " does not contain an administrativeRole attribute! An" + " administrativeRole attribute in the administrative point is" + " required to add a subordinate subentry.");
            }
            Subentry subentry = new Subentry();
            subentry.setTypes(this.getSubentryTypes(entry));
            Attributes operational = this.getSubentryOperatationalAttributes((Name)normName, subentry);
            String subtree = (String)entry.get("subtreeSpecification").get();
            try {
                ss = this.ssParser.parse(subtree);
            }
            catch (Exception e) {
                String msg = "Failed while parsing subtreeSpecification for " + normName.getUpName();
                log.warn(msg);
                throw new LdapInvalidAttributeValueException(msg, ResultCodeEnum.INVALIDATTRIBUTESYNTAX);
            }
            this.subentryCache.setSubentry(normName.toString(), ss, this.getSubentryTypes(entry));
            next.add(normName, entry);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            PresenceNode filter = new PresenceNode("2.5.4.0");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(baseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate.get("objectClass"))) continue;
                this.nexus.modify(dn, this.getOperationalModsForAdd(candidate, operational));
            }
        } else {
            Iterator list = this.subentryCache.nameIterator();
            while (list.hasNext()) {
                Attribute operational;
                String subentryDnStr = (String)list.next();
                LdapDN subentryDn = new LdapDN(subentryDnStr);
                LdapDN apDn = (LdapDN)subentryDn.clone();
                apDn.remove(apDn.size() - 1);
                Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
                SubtreeSpecification ss = subentry.getSubtreeSpecification();
                if (!this.evaluator.evaluate(ss, (Name)apDn, (Name)normName, objectClasses)) continue;
                if (subentry.isAccessControlSubentry()) {
                    operational = entry.get(AC_SUBENTRIES);
                    if (operational == null) {
                        operational = new LockableAttributeImpl(AC_SUBENTRIES);
                        entry.put(operational);
                    }
                    operational.add(subentryDn.toString());
                }
                if (subentry.isSchemaSubentry()) {
                    operational = entry.get(SCHEMA_SUBENTRY);
                    if (operational == null) {
                        operational = new LockableAttributeImpl(SCHEMA_SUBENTRY);
                        entry.put(operational);
                    }
                    operational.add(subentryDn.toString());
                }
                if (!subentry.isCollectiveSubentry()) continue;
                operational = entry.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
                if (operational == null) {
                    operational = new LockableAttributeImpl(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
                    entry.put(operational);
                }
                operational.add(subentryDn.toString());
            }
            next.add(normName, entry);
        }
    }

    public void delete(NextInterceptor next, LdapDN name) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        Attribute objectClasses = ServerUtils.getAttribute(this.objectClassType, entry);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS)) {
            SubtreeSpecification ss = this.subentryCache.removeSubentry(name.toNormName()).getSubtreeSpecification();
            next.delete(name);
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(name.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectclass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(baseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, ServerUtils.getAttribute(this.objectClassType, candidate))) continue;
                this.nexus.modify(dn, this.getOperationalModsForRemove(name, candidate));
            }
        } else {
            next.delete(name);
        }
    }

    private boolean hasAdministrativeDescendant(LdapDN name) throws NamingException {
        PresenceNode filter = new PresenceNode("administrativeRole");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration aps = this.nexus.search(name, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
        if (aps.hasMore()) {
            aps.close();
            return true;
        }
        return false;
    }

    private ModificationItemImpl[] getModsOnEntryRdnChange(Name oldName, Name newName, Attributes entry) throws NamingException {
        Attribute objectClasses = entry.get("objectClass");
        ArrayList<ModificationItemImpl> modList = new ArrayList<ModificationItemImpl>();
        Iterator subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            Attribute opAttr;
            int op;
            int ii;
            boolean isNewNameSelected;
            String subentryDn = (String)subentries.next();
            LdapDN apDn = new LdapDN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldNameSelected = this.evaluator.evaluate(ss, (Name)apDn, oldName, objectClasses);
            if (isOldNameSelected == (isNewNameSelected = this.evaluator.evaluate(ss, (Name)apDn, newName, objectClasses))) continue;
            if (isOldNameSelected && !isNewNameSelected) {
                for (ii = 0; ii < SUBENTRY_OPATTRS.length; ++ii) {
                    op = 2;
                    opAttr = entry.get(SUBENTRY_OPATTRS[ii]);
                    if (opAttr == null) continue;
                    opAttr = (Attribute)opAttr.clone();
                    opAttr.remove(subentryDn);
                    if (opAttr.size() < 1) {
                        op = 3;
                    }
                    modList.add(new ModificationItemImpl(op, opAttr));
                }
                continue;
            }
            if (!isNewNameSelected || isOldNameSelected) continue;
            for (ii = 0; ii < SUBENTRY_OPATTRS.length; ++ii) {
                op = 1;
                opAttr = new LockableAttributeImpl(SUBENTRY_OPATTRS[ii]);
                opAttr.add(subentryDn);
                modList.add(new ModificationItemImpl(op, opAttr));
            }
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[modList.size()];
        mods = modList.toArray(mods);
        return mods;
    }

    public void modifyRn(NextInterceptor next, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        Attribute objectClasses = ServerUtils.getAttribute(this.objectClassType, entry);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS)) {
            Subentry subentry = this.subentryCache.getSubentry(name.toNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)name.clone();
            newName.remove(newName.size() - 1);
            LdapDN rdn = new LdapDN(newRn);
            newName.addAll((Name)rdn);
            rdn.normalize(this.attrRegistry.getNormalizerMapping());
            newName.normalize(this.attrRegistry.getNormalizerMapping());
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.modifyRn(name, newRn, deleteOldRn);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectclass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(baseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, ServerUtils.getAttribute(this.objectClassType, candidate))) continue;
                this.nexus.modify(dn, this.getOperationalModsForReplace((Name)name, (Name)newName, subentry, candidate));
            }
        } else {
            if (this.hasAdministrativeDescendant(name)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                log.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
            next.modifyRn(name, newRn, deleteOldRn);
            LdapDN newName = (LdapDN)name.clone();
            newName.remove(newName.size() - 1);
            newName.add(newRn);
            newName.normalize(this.attrRegistry.getNormalizerMapping());
            ModificationItemImpl[] mods = this.getModsOnEntryRdnChange((Name)name, (Name)newName, entry);
            if (mods.length > 0) {
                this.nexus.modify(newName, mods);
            }
        }
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        Attributes entry = this.nexus.lookup(oriChildName);
        Attribute objectClasses = ServerUtils.getAttribute(this.objectClassType, entry);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS)) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.toNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.remove(newName.size() - 1);
            LdapDN rdn = new LdapDN(newRn);
            newName.addAll((Name)rdn);
            rdn.normalize(this.attrRegistry.getNormalizerMapping());
            newName.normalize(this.attrRegistry.getNormalizerMapping());
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.move(oriChildName, newParentName, newRn, deleteOldRn);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectclass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(baseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, ServerUtils.getAttribute(this.objectClassType, candidate))) continue;
                this.nexus.modify(dn, this.getOperationalModsForReplace((Name)oriChildName, (Name)newName, subentry, candidate));
            }
        } else {
            if (this.hasAdministrativeDescendant(oriChildName)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                log.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
            next.move(oriChildName, newParentName, newRn, deleteOldRn);
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.add(newRn);
            newName.normalize(this.attrRegistry.getNormalizerMapping());
            ModificationItemImpl[] mods = this.getModsOnEntryRdnChange((Name)oriChildName, (Name)newName, entry);
            if (mods.length > 0) {
                this.nexus.modify(newName, mods);
            }
        }
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        Attributes entry = this.nexus.lookup(oriChildName);
        Attribute objectClasses = entry.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS)) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.toString());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.remove(newName.size() - 1);
            newName.add(newParentName.get(newParentName.size() - 1));
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.move(oriChildName, newParentName);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode("objectclass");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(baseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate.get("objectClass"))) continue;
                this.nexus.modify(dn, this.getOperationalModsForReplace((Name)oriChildName, (Name)newName, subentry, candidate));
            }
        } else {
            if (this.hasAdministrativeDescendant(oriChildName)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                log.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOTALLOWEDONRDN);
            }
            next.move(oriChildName, newParentName);
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.add(oriChildName.get(oriChildName.size() - 1));
            ModificationItemImpl[] mods = this.getModsOnEntryRdnChange((Name)oriChildName, (Name)newName, entry);
            if (mods.length > 0) {
                this.nexus.modify(newName, mods);
            }
        }
    }

    private int getSubentryTypes(Attributes subentry, int modOp, Attributes mods) throws NamingException {
        int ii;
        if (mods.get("objectClass") == null) {
            return this.getSubentryTypes(subentry);
        }
        if (modOp == 2) {
            return this.getSubentryTypes(mods);
        }
        Attribute ocChanges = mods.get("objectClass");
        Attribute ocFinalState = (Attribute)subentry.get("objectClass").clone();
        if (modOp == 1) {
            for (ii = 0; ii < ocChanges.size(); ++ii) {
                ocFinalState.add(ocChanges.get(ii));
            }
        } else {
            for (ii = 0; ii < ocChanges.size(); ++ii) {
                ocFinalState.remove(ocChanges.get(ii));
            }
        }
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        attrs.put(ocFinalState);
        return this.getSubentryTypes((Attributes)attrs);
    }

    private int getSubentryTypes(Attributes entry, ModificationItemImpl[] mods) throws NamingException {
        Attribute ocFinalState = (Attribute)entry.get("objectClass").clone();
        block5: for (int ii = 0; ii < mods.length; ++ii) {
            if (!mods[ii].getAttribute().getID().equalsIgnoreCase("objectClass")) continue;
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    int jj;
                    for (jj = 0; jj < mods[ii].getAttribute().size(); ++jj) {
                        ocFinalState.add(mods[ii].getAttribute().get(jj));
                    }
                    continue block5;
                }
                case 3: {
                    int jj;
                    for (jj = 0; jj < mods[ii].getAttribute().size(); ++jj) {
                        ocFinalState.remove(mods[ii].getAttribute().get(jj));
                    }
                    continue block5;
                }
                case 2: {
                    ocFinalState = mods[ii].getAttribute();
                }
            }
        }
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        attrs.put(ocFinalState);
        return this.getSubentryTypes((Attributes)attrs);
    }

    public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        Attributes oldEntry = (Attributes)AttributeUtils.toAttributesImpl((Attributes)entry).clone();
        Attribute objectClasses = ServerUtils.getAttribute(this.objectClassType, entry);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS) && mods.get("subtreeSpecification") != null) {
            SubtreeSpecification ssNew;
            SubtreeSpecification ssOld = this.subentryCache.removeSubentry(name.toNormName()).getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse((String)mods.get("subtreeSpecification").get());
            }
            catch (Exception e) {
                String msg = "failed to parse the new subtreeSpecification";
                log.error(msg, (Throwable)e);
                throw new LdapInvalidAttributeValueException(msg, ResultCodeEnum.INVALIDATTRIBUTESYNTAX);
            }
            this.subentryCache.setSubentry(name.toNormName(), ssNew, this.getSubentryTypes(entry, modOp, mods));
            next.modify(name, modOp, mods);
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(apName.size() - 1);
            LdapDN oldBaseDn = (LdapDN)apName.clone();
            oldBaseDn.addAll((Name)ssOld.getBase());
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(oldBaseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssOld, (Name)apName, (Name)dn, ServerUtils.getAttribute(this.objectClassType, candidate))) continue;
                this.nexus.modify(dn, this.getOperationalModsForRemove(name, candidate));
            }
            Subentry subentry = this.subentryCache.getSubentry(name.toNormName());
            Attributes operational = this.getSubentryOperatationalAttributes((Name)name, subentry);
            LdapDN newBaseDn = (LdapDN)apName.clone();
            newBaseDn.addAll((Name)ssNew.getBase());
            subentries = this.nexus.search(newBaseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssNew, (Name)apName, (Name)dn, ServerUtils.getAttribute(this.objectClassType, candidate))) continue;
                this.nexus.modify(dn, this.getOperationalModsForAdd(candidate, operational));
            }
        } else {
            Attributes newEntry;
            ModificationItemImpl[] subentriesOpAttrMods;
            next.modify(name, modOp, mods);
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS) && (subentriesOpAttrMods = this.getModsOnEntryModification(name, oldEntry, newEntry = this.nexus.lookup(name))).length > 0) {
                this.nexus.modify(name, subentriesOpAttrMods);
            }
        }
    }

    public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        Attributes entry = this.nexus.lookup(name);
        Attributes oldEntry = (Attributes)AttributeUtils.toAttributesImpl((Attributes)entry).clone();
        Attribute objectClasses = ServerUtils.getAttribute(this.objectClassType, entry);
        boolean isSubtreeSpecificationModification = false;
        ModificationItemImpl subtreeMod = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            if (!"subtreeSpecification".equalsIgnoreCase(mods[ii].getAttribute().getID())) continue;
            isSubtreeSpecificationModification = true;
            subtreeMod = mods[ii];
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS) && isSubtreeSpecificationModification) {
            SubtreeSpecification ssNew;
            SubtreeSpecification ssOld = this.subentryCache.removeSubentry(name.toString()).getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse((String)subtreeMod.getAttribute().get());
            }
            catch (Exception e) {
                String msg = "failed to parse the new subtreeSpecification";
                log.error(msg, (Throwable)e);
                throw new LdapInvalidAttributeValueException(msg, ResultCodeEnum.INVALIDATTRIBUTESYNTAX);
            }
            this.subentryCache.setSubentry(name.toNormName(), ssNew, this.getSubentryTypes(entry, mods));
            next.modify(name, mods);
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(apName.size() - 1);
            LdapDN oldBaseDn = (LdapDN)apName.clone();
            oldBaseDn.addAll((Name)ssOld.getBase());
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            NamingEnumeration subentries = this.nexus.search(oldBaseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssOld, (Name)apName, (Name)dn, candidate.get("objectClass"))) continue;
                this.nexus.modify(dn, this.getOperationalModsForRemove(name, candidate));
            }
            Subentry subentry = this.subentryCache.getSubentry(name.toNormName());
            Attributes operational = this.getSubentryOperatationalAttributes((Name)name, subentry);
            LdapDN newBaseDn = (LdapDN)apName.clone();
            newBaseDn.addAll((Name)ssNew.getBase());
            subentries = this.nexus.search(newBaseDn, this.factoryCfg.getEnvironment(), (ExprNode)filter, controls);
            while (subentries.hasMore()) {
                SearchResult result = (SearchResult)subentries.next();
                Attributes candidate = result.getAttributes();
                LdapDN dn = new LdapDN(result.getName());
                dn.normalize(this.attrRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssNew, (Name)apName, (Name)dn, candidate.get("objectClass"))) continue;
                this.nexus.modify(dn, this.getOperationalModsForAdd(candidate, operational));
            }
        } else {
            Attributes newEntry;
            ModificationItemImpl[] subentriesOpAttrMods;
            next.modify(name, mods);
            if (!AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SUBENTRY_OBJECTCLASS) && (subentriesOpAttrMods = this.getModsOnEntryModification(name, oldEntry, newEntry = this.nexus.lookup(name))).length > 0) {
                this.nexus.modify(name, subentriesOpAttrMods);
            }
        }
    }

    private ModificationItemImpl[] getOperationalModsForReplace(Name oldName, Name newName, Subentry subentry, Attributes entry) throws NamingException {
        Attribute operational;
        ArrayList<ModificationItemImpl> modList = new ArrayList<ModificationItemImpl>();
        if (subentry.isAccessControlSubentry()) {
            operational = (Attribute)entry.get(AC_SUBENTRIES).clone();
            if (operational == null) {
                operational = new LockableAttributeImpl(AC_SUBENTRIES);
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ModificationItemImpl(2, operational));
        }
        if (subentry.isSchemaSubentry()) {
            operational = (Attribute)entry.get(SCHEMA_SUBENTRY).clone();
            if (operational == null) {
                operational = new LockableAttributeImpl(SCHEMA_SUBENTRY);
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ModificationItemImpl(2, operational));
        }
        if (subentry.isCollectiveSubentry()) {
            operational = (Attribute)entry.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES).clone();
            if (operational == null) {
                operational = new LockableAttributeImpl(COLLECTIVE_ATTRIBUTE_SUBENTRIES);
                operational.add(newName.toString());
            } else {
                operational.remove(oldName.toString());
                operational.add(newName.toString());
            }
            modList.add(new ModificationItemImpl(2, operational));
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[modList.size()];
        return modList.toArray(mods);
    }

    private Attributes getSubentryOperatationalAttributes(Name name, Subentry subentry) throws NamingException {
        LockableAttributesImpl operational = new LockableAttributesImpl();
        if (subentry.isAccessControlSubentry()) {
            if (operational.get(AC_SUBENTRIES) == null) {
                operational.put(AC_SUBENTRIES, name.toString());
            } else {
                operational.get(AC_SUBENTRIES).add(name.toString());
            }
        }
        if (subentry.isSchemaSubentry()) {
            if (operational.get(SCHEMA_SUBENTRY) == null) {
                operational.put(SCHEMA_SUBENTRY, name.toString());
            } else {
                operational.get(SCHEMA_SUBENTRY).add(name.toString());
            }
        }
        if (subentry.isCollectiveSubentry()) {
            if (operational.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES) == null) {
                operational.put(COLLECTIVE_ATTRIBUTE_SUBENTRIES, name.toString());
            } else {
                operational.get(COLLECTIVE_ATTRIBUTE_SUBENTRIES).add(name.toString());
            }
        }
        return operational;
    }

    private ModificationItemImpl[] getOperationalModsForRemove(LdapDN subentryDn, Attributes candidate) {
        ArrayList<ModificationItemImpl> modList = new ArrayList<ModificationItemImpl>();
        String dn = subentryDn.toNormName();
        for (int ii = 0; ii < SUBENTRY_OPATTRS.length; ++ii) {
            String opAttrId = SUBENTRY_OPATTRS[ii];
            Attribute opAttr = candidate.get(opAttrId);
            if (opAttr == null || !opAttr.contains(dn)) continue;
            LockableAttributeImpl attr = new LockableAttributeImpl(SUBENTRY_OPATTRS[ii]);
            attr.add(dn);
            modList.add(new ModificationItemImpl(3, (Attribute)attr));
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[modList.size()];
        return modList.toArray(mods);
    }

    public ModificationItemImpl[] getOperationalModsForAdd(Attributes entry, Attributes operational) throws NamingException {
        ArrayList<ModificationItemImpl> modList = new ArrayList<ModificationItemImpl>();
        NamingEnumeration<String> opAttrIds = operational.getIDs();
        while (opAttrIds.hasMore()) {
            int ii;
            int op = 2;
            String opAttrId = opAttrIds.next();
            LockableAttributeImpl result = new LockableAttributeImpl(opAttrId);
            Attribute opAttrAdditions = operational.get(opAttrId);
            Attribute opAttrInEntry = entry.get(opAttrId);
            for (ii = 0; ii < opAttrAdditions.size(); ++ii) {
                result.add(opAttrAdditions.get(ii));
            }
            if (opAttrInEntry != null && opAttrInEntry.size() > 0) {
                for (ii = 0; ii < opAttrInEntry.size(); ++ii) {
                    result.add(opAttrInEntry.get(ii));
                }
            } else {
                op = 1;
            }
            modList.add(new ModificationItemImpl(op, (Attribute)result));
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[modList.size()];
        mods = modList.toArray(mods);
        return mods;
    }

    private ModificationItemImpl[] getModsOnEntryModification(LdapDN name, Attributes oldEntry, Attributes newEntry) throws NamingException {
        ArrayList<ModificationItemImpl> modList = new ArrayList<ModificationItemImpl>();
        Iterator subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            Attribute opAttr;
            int op;
            int ii;
            boolean isNewEntrySelected;
            String subentryDn = (String)subentries.next();
            LdapDN apDn = new LdapDN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldEntrySelected = this.evaluator.evaluate(ss, (Name)apDn, (Name)name, oldEntry.get("objectClass"));
            if (isOldEntrySelected == (isNewEntrySelected = this.evaluator.evaluate(ss, (Name)apDn, (Name)name, newEntry.get("objectClass")))) continue;
            if (isOldEntrySelected && !isNewEntrySelected) {
                for (ii = 0; ii < SUBENTRY_OPATTRS.length; ++ii) {
                    op = 2;
                    opAttr = oldEntry.get(SUBENTRY_OPATTRS[ii]);
                    if (opAttr == null) continue;
                    opAttr = (Attribute)opAttr.clone();
                    opAttr.remove(subentryDn);
                    if (opAttr.size() < 1) {
                        op = 3;
                    }
                    modList.add(new ModificationItemImpl(op, opAttr));
                }
                continue;
            }
            if (!isNewEntrySelected || isOldEntrySelected) continue;
            for (ii = 0; ii < SUBENTRY_OPATTRS.length; ++ii) {
                op = 1;
                opAttr = new BasicAttribute(SUBENTRY_OPATTRS[ii]);
                opAttr.add(subentryDn);
                modList.add(new ModificationItemImpl(op, opAttr));
            }
        }
        ModificationItemImpl[] mods = new ModificationItemImpl[modList.size()];
        mods = modList.toArray(mods);
        return mods;
    }

    public class HideEntriesFilter
    implements SearchResultFilter {
        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            String dn = result.getName();
            if (SubentryService.this.subentryCache.hasSubentry(dn)) {
                return true;
            }
            Attribute objectClasses = result.getAttributes().get("objectClass");
            if (objectClasses != null) {
                if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SubentryService.SUBENTRY_OBJECTCLASS)) {
                    return true;
                }
                if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SubentryService.SUBENTRY_OBJECTCLASS_OID)) {
                    return true;
                }
                for (int ii = 0; ii < objectClasses.size(); ++ii) {
                    String oc = (String)objectClasses.get(ii);
                    if (!oc.equalsIgnoreCase(SubentryService.SUBENTRY_OBJECTCLASS)) continue;
                    return true;
                }
                return false;
            }
            if (!result.isRelative()) {
                LdapDN ndn = new LdapDN(dn);
                ndn.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
                return SubentryService.this.subentryCache.hasSubentry(ndn.toNormName());
            }
            LdapDN name = new LdapDN(invocation.getCaller().getNameInNamespace());
            name.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
            LdapDN rest = new LdapDN(result.getName());
            rest.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
            name.addAll((Name)rest);
            return SubentryService.this.subentryCache.hasSubentry(name.toNormName());
        }
    }

    public class HideSubentriesFilter
    implements SearchResultFilter {
        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            String dn = result.getName();
            if (SubentryService.this.subentryCache.hasSubentry(dn)) {
                return false;
            }
            Attribute objectClasses = result.getAttributes().get("objectClass");
            if (objectClasses != null) {
                if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SubentryService.SUBENTRY_OBJECTCLASS)) {
                    return false;
                }
                if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)SubentryService.SUBENTRY_OBJECTCLASS_OID)) {
                    return false;
                }
                for (int ii = 0; ii < objectClasses.size(); ++ii) {
                    String oc = (String)objectClasses.get(ii);
                    if (!oc.equalsIgnoreCase(SubentryService.SUBENTRY_OBJECTCLASS)) continue;
                    return false;
                }
                return true;
            }
            if (!result.isRelative()) {
                LdapDN ndn = new LdapDN(dn);
                ndn.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
                String normalizedDn = ndn.toString();
                return !SubentryService.this.subentryCache.hasSubentry(normalizedDn);
            }
            LdapDN name = new LdapDN(invocation.getCaller().getNameInNamespace());
            name.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
            LdapDN rest = new LdapDN(result.getName());
            rest.normalize(SubentryService.this.attrRegistry.getNormalizerMapping());
            name.addAll((Name)rest);
            return !SubentryService.this.subentryCache.hasSubentry(name.toString());
        }
    }
}

