/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools;

import java.io.Serializable;
import org.apache.directory.server.tools.ToolCommand;
import org.apache.directory.server.tools.ToolCommandListener;

public abstract class BaseToolCommand
implements ToolCommand {
    private final String name;
    protected int port;
    protected String host;
    protected String password;
    protected String user;
    protected String auth;
    private boolean debugEnabled = false;
    private boolean verboseEnabled = false;
    private boolean quietEnabled = false;
    private String version;
    protected ToolCommandListener outputListener;
    protected ToolCommandListener errorListener;
    protected ToolCommandListener exceptionListener;

    public BaseToolCommand(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setVerboseEnabled(boolean verboseEnabled) {
        this.verboseEnabled = verboseEnabled;
    }

    public boolean isVerboseEnabled() {
        return this.verboseEnabled;
    }

    public void setQuietEnabled(boolean quietEnabled) {
        this.quietEnabled = quietEnabled;
    }

    public boolean isQuietEnabled() {
        return this.quietEnabled;
    }

    protected void notifyOutputListener(Serializable o) {
        if (this.outputListener != null) {
            this.outputListener.notify(o);
        }
    }

    protected void notifyErrorListener(Serializable o) {
        if (this.errorListener != null) {
            this.errorListener.notify(o);
        }
    }

    protected void notifyExceptionListener(Serializable o) {
        if (this.exceptionListener != null) {
            this.exceptionListener.notify(o);
        }
    }
}

