/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.tools.commands.importcmd;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.configuration.ServerStartupConfiguration;
import org.apache.directory.server.tools.ToolCommandListener;
import org.apache.directory.server.tools.execution.BaseToolCommandExecutor;
import org.apache.directory.server.tools.util.ListenerParameter;
import org.apache.directory.server.tools.util.Parameter;
import org.apache.directory.server.tools.util.ToolCommandException;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapDecoder;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResult;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.codec.bind.BindRequest;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.del.DelRequest;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponse;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequest;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ImportCommandExecutor
extends BaseToolCommandExecutor {
    public static final String FILE_PARAMETER = "file";
    public static final String IGNOREERRORS_PARAMETER = "ignore-errors";
    public static final String ENTRYADDEDLISTENER_PARAMETER = "entryAddedListener";
    public static final String ENTRYADDFAILEDLISTENER_PARAMETER = "entryAddFailedListener";
    private File ldifFile;
    private String logs;
    private boolean ignoreErrors = false;
    private static final int IMPORT_ERROR = -1;
    private static final int IMPORT_SUCCESS = 0;
    private SocketChannel channel;
    private SocketAddress serverAddress;
    private IAsn1Container ldapMessageContainer = new LdapMessageContainer();
    private Asn1Decoder ldapDecoder = new LdapDecoder();
    private ToolCommandListener entryAddedListener;
    private ToolCommandListener entryAddFailedListener;

    public ImportCommandExecutor() {
        super("import");
    }

    private void connect() throws UnknownHostException, IOException {
        this.serverAddress = new InetSocketAddress(this.host, this.port);
        this.channel = SocketChannel.open(this.serverAddress);
        this.channel.configureBlocking(true);
    }

    private void sendMessage(ByteBuffer bb) throws IOException {
        this.channel.write(bb);
        bb.clear();
    }

    private LdapMessage readResponse(ByteBuffer bb) throws IOException, DecoderException, NamingException {
        int nbRead;
        LdapMessage messageResp = null;
        while ((nbRead = this.channel.read(bb)) != -1) {
            bb.flip();
            this.ldapDecoder.decode(bb, this.ldapMessageContainer);
            if (this.ldapMessageContainer.getState() == 1024) {
                ExtendedResponse resp;
                messageResp = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage();
                if (messageResp instanceof BindResponse) {
                    BindResponse resp2 = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage().getBindResponse();
                    if (resp2.getLdapResult().getResultCode() != 0) {
                        this.notifyOutputListener((Serializable)((Object)("Error : " + resp2.getLdapResult().getErrorMessage())));
                    }
                } else if (messageResp instanceof ExtendedResponse && (resp = ((LdapMessageContainer)this.ldapMessageContainer).getLdapMessage().getExtendedResponse()).getLdapResult().getResultCode() != 0) {
                    this.notifyOutputListener((Serializable)((Object)("Error : " + resp.getLdapResult().getErrorMessage())));
                }
                ((LdapMessageContainer)this.ldapMessageContainer).clean();
                break;
            }
            bb.flip();
        }
        return messageResp;
    }

    private int addEntry(Entry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        AddRequest addRequest = new AddRequest();
        String dn = entry.getDn();
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)("Adding entry " + dn)));
        }
        Attributes attributes = entry.getAttributes();
        addRequest.setEntry(new LdapDN(dn));
        addRequest.initAttributes();
        NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
        while (attrs.hasMoreElements()) {
            Attribute attribute = (Attribute)attrs.nextElement();
            addRequest.addAttributeType(attribute.getID());
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                addRequest.addAttributeValue(value);
            }
        }
        LdapMessage message = new LdapMessage();
        message.setProtocolOP((Asn1Object)addRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessage response = this.readResponse(bb);
        LdapResult result = response.getAddResponse().getLdapResult();
        if (result.getResultCode() == 0) {
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("Add of Entry " + entry.getDn() + " was successful")));
            }
            return 0;
        }
        this.notifyErrorListener((Serializable)((Object)("Add of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage())));
        return -1;
    }

    private int deleteEntry(Entry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        DelRequest delRequest = new DelRequest();
        String dn = entry.getDn();
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)("Deleting entry " + dn)));
        }
        delRequest.setEntry(new LdapDN(dn));
        LdapMessage message = new LdapMessage();
        message.setProtocolOP((Asn1Object)delRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessage response = this.readResponse(bb);
        LdapResult result = response.getDelResponse().getLdapResult();
        if (result.getResultCode() == 0) {
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("Delete of Entry " + entry.getDn() + " was successful")));
            }
            return 0;
        }
        this.notifyErrorListener((Serializable)((Object)("Delete of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage())));
        return -1;
    }

    private int changeModRDNEntry(Entry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        ModifyDNRequest modifyDNRequest = new ModifyDNRequest();
        String dn = entry.getDn();
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)("Modify DN of entry " + dn)));
        }
        modifyDNRequest.setEntry(new LdapDN(dn));
        modifyDNRequest.setDeleteOldRDN(entry.isDeleteOldRdn());
        modifyDNRequest.setNewRDN(new Rdn(entry.getNewRdn()));
        if (!StringTools.isEmpty((String)entry.getNewSuperior())) {
            modifyDNRequest.setNewSuperior(new LdapDN(entry.getNewSuperior()));
        }
        LdapMessage message = new LdapMessage();
        message.setProtocolOP((Asn1Object)modifyDNRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessage response = this.readResponse(bb);
        LdapResult result = response.getModifyDNResponse().getLdapResult();
        if (result.getResultCode() == 0) {
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("ModifyDn of Entry " + entry.getDn() + " was successful")));
            }
            return 0;
        }
        this.notifyErrorListener((Serializable)((Object)("ModifyDn of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage())));
        return -1;
    }

    private int changeModifyEntry(Entry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        ModifyRequest modifyRequest = new ModifyRequest();
        String dn = entry.getDn();
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)("Modify of entry " + dn)));
        }
        modifyRequest.setObject(new LdapDN(dn));
        modifyRequest.initModifications();
        for (ModificationItemImpl modification : entry.getModificationItems()) {
            switch (modification.getModificationOp()) {
                case 1: {
                    modifyRequest.setCurrentOperation(0);
                    break;
                }
                case 3: {
                    modifyRequest.setCurrentOperation(1);
                    break;
                }
                case 2: {
                    modifyRequest.setCurrentOperation(2);
                    break;
                }
                default: {
                    this.notifyErrorListener((Serializable)((Object)("Unknown modify operation for DN " + dn)));
                }
            }
            modifyRequest.addAttributeTypeAndValues(modification.getAttribute().getID());
            NamingEnumeration<?> values = modification.getAttribute().getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                modifyRequest.addAttributeValue(value);
            }
        }
        LdapMessage message = new LdapMessage();
        message.setProtocolOP((Asn1Object)modifyRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        bb.clear();
        LdapMessage response = this.readResponse(bb);
        LdapResult result = response.getModifyResponse().getLdapResult();
        if (result.getResultCode() == 0) {
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("Modify of Entry " + entry.getDn() + " was successful")));
            }
            return 0;
        }
        this.notifyErrorListener((Serializable)((Object)("Modify of entry " + entry.getDn() + " failed for the following reasons provided by the server:\n" + result.getErrorMessage())));
        return -1;
    }

    private int changeEntry(Entry entry, int messageId) throws IOException, DecoderException, InvalidNameException, NamingException, EncoderException {
        switch (entry.getChangeType()) {
            case 0: {
                return this.addEntry(entry, messageId);
            }
            case 4: {
                return this.deleteEntry(entry, messageId);
            }
            case 1: {
                return this.changeModifyEntry(entry, messageId);
            }
            case 2: 
            case 3: {
                return this.changeModRDNEntry(entry, messageId);
            }
        }
        return -1;
    }

    private void bind(int messageId) throws EncoderException, DecoderException, IOException, ToolCommandException, NamingException {
        BindRequest bindRequest = new BindRequest();
        LdapMessage message = new LdapMessage();
        SimpleAuthentication authentication = null;
        if ("simple".equals(this.auth)) {
            authentication = new SimpleAuthentication();
            authentication.setSimple(StringTools.getBytesUtf8((String)this.password));
        }
        bindRequest.setAuthentication(authentication);
        bindRequest.setName(new LdapDN(this.user));
        bindRequest.setVersion(3);
        message.setProtocolOP((Asn1Object)bindRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.connect();
        this.sendMessage(bb);
        bb.clear();
        LdapMessage response = this.readResponse(bb);
        LdapResult result = response.getBindResponse().getLdapResult();
        if (result.getResultCode() == 0) {
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("Binding of user " + this.user + " was successful")));
            }
        } else {
            this.notifyErrorListener((Serializable)((Object)("Binding of user " + this.user + " failed for the following reasons provided by the server:\n" + result.getErrorMessage())));
            throw new ToolCommandException("Binding of user " + this.user + " failed for the following reasons provided by the server:\n" + result.getErrorMessage());
        }
    }

    private void unbind(int messageId) throws InvalidNameException, EncoderException, DecoderException, IOException {
        UnBindRequest unbindRequest = new UnBindRequest();
        LdapMessage message = new LdapMessage();
        message.setProtocolOP((Asn1Object)unbindRequest);
        message.setMessageId(messageId);
        ByteBuffer bb = message.encode(null);
        bb.flip();
        this.sendMessage(bb);
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)("Unbinding of user " + this.user + " was successful")));
        }
    }

    private void processParameters(Parameter[] params) {
        Boolean ignoreErrorsParam;
        String hostParam;
        String installPathParam;
        Boolean verboseParam;
        Boolean debugParam;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            Parameter parameter = params[i];
            parameters.put(parameter.getName(), parameter.getValue());
        }
        Boolean quietParam = (Boolean)parameters.get("quiet");
        if (quietParam != null) {
            this.setQuietEnabled(quietParam);
        }
        if ((debugParam = (Boolean)parameters.get("debug")) != null) {
            this.setDebugEnabled(debugParam);
        }
        if ((verboseParam = (Boolean)parameters.get("verbose")) != null) {
            this.setVerboseEnabled(verboseParam);
        }
        if ((installPathParam = (String)parameters.get("install-path")) != null) {
            try {
                this.setLayout(installPathParam);
                if (!this.isQuietEnabled()) {
                    this.notifyOutputListener((Serializable)((Object)("loading settings from: " + this.getLayout().getConfigurationFile())));
                }
                FileSystemXmlApplicationContext factory = null;
                URL configUrl = this.getLayout().getConfigurationFile().toURL();
                factory = new FileSystemXmlApplicationContext(configUrl.toString());
                this.setConfiguration((ServerStartupConfiguration)factory.getBean("configuration"));
            }
            catch (MalformedURLException e) {
                this.notifyErrorListener((Serializable)((Object)e.getMessage()));
                this.notifyExceptionListener(e);
            }
        }
        if ((hostParam = (String)parameters.get("host")) != null) {
            this.host = hostParam;
        } else {
            this.host = "localhost";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("host set to default: " + this.host)));
            }
        }
        Integer portParam = (Integer)parameters.get("port");
        if (portParam != null) {
            this.port = portParam;
        } else {
            this.port = 10389;
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("port set to default: " + this.port)));
            }
        }
        String userParam = (String)parameters.get("user");
        if (userParam != null) {
            this.user = userParam;
        } else {
            this.user = "uid=admin,ou=system";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("user set to default: " + this.user)));
            }
        }
        String passwordParam = (String)parameters.get("password");
        if (passwordParam != null) {
            this.password = passwordParam;
        } else {
            this.password = "secret";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("password set to default: " + this.password)));
            }
        }
        String authParam = (String)parameters.get("auth");
        if (authParam != null) {
            this.auth = authParam;
        } else {
            this.auth = "simple";
            if (this.isDebugEnabled()) {
                this.notifyOutputListener((Serializable)((Object)("authentication type set to default: " + this.auth)));
            }
        }
        File ldifFileParam = (File)parameters.get(FILE_PARAMETER);
        if (ldifFileParam != null) {
            this.ldifFile = ldifFileParam;
        }
        if ((ignoreErrorsParam = (Boolean)parameters.get(IGNOREERRORS_PARAMETER)) != null) {
            this.ignoreErrors = ignoreErrorsParam;
        } else if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)"ignore-errors set to default: false"));
        }
    }

    private void execute() throws Exception {
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)"Parameters for Ldif import request:"));
            this.notifyOutputListener((Serializable)((Object)("port = " + this.port)));
            this.notifyOutputListener((Serializable)((Object)("host = " + this.host)));
            this.notifyOutputListener((Serializable)((Object)("user = " + this.user)));
            this.notifyOutputListener((Serializable)((Object)("auth type = " + this.auth)));
            this.notifyOutputListener((Serializable)((Object)("file = " + this.ldifFile)));
            this.notifyOutputListener((Serializable)((Object)("logs = " + this.logs)));
        }
        int messageId = 0;
        this.bind(messageId++);
        if (this.isDebugEnabled()) {
            this.notifyOutputListener((Serializable)((Object)"Connection to the server established.\nImporting data ... "));
        }
        LdifReader ldifReader = null;
        try {
            ldifReader = new LdifReader(this.ldifFile);
        }
        catch (NamingException ne) {
            this.notifyErrorListener((Serializable)((Object)("Could not parse the LDIF file:" + ne.getMessage())));
            throw new ToolCommandException("Naming Exception :" + ne.getMessage());
        }
        if (ldifReader.containsEntries()) {
            Iterator entries = ldifReader.iterator();
            long t0 = System.currentTimeMillis();
            int nbAdd = 0;
            while (entries.hasNext()) {
                Entry entry = (Entry)entries.next();
                if (ldifReader.hasError()) {
                    this.notifyErrorListener((Serializable)((Object)("Found an error while persing an entry : " + ldifReader.getError().getMessage())));
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        this.notifyErrorListener((Serializable)((Object)"Import failed..."));
                        throw new ToolCommandException("Import failed...");
                    }
                    this.notifyEntryAddFailedListener((Serializable)((Object)entry.getDn()));
                }
                if (this.addEntry(entry, messageId++) == -1) {
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        this.notifyErrorListener((Serializable)((Object)"Import failed..."));
                        throw new ToolCommandException("Import failed...");
                    }
                    this.notifyEntryAddFailedListener((Serializable)((Object)entry.getDn()));
                } else {
                    ++nbAdd;
                    this.notifyEntryAddedListener((Serializable)((Object)entry.getDn()));
                }
                if (nbAdd % 10 == 0) {
                    this.notifyOutputListener(new Character('.'));
                }
                if (nbAdd % 500 != 0) continue;
                this.notifyOutputListener((Serializable)((Object)("" + nbAdd)));
            }
            long t1 = System.currentTimeMillis();
            this.notifyOutputListener((Serializable)((Object)"Done!"));
            this.notifyOutputListener((Serializable)((Object)(nbAdd + " users added in " + (t1 - t0) / 1000L + " seconds")));
        } else {
            Iterator entries = ldifReader.iterator();
            long t0 = System.currentTimeMillis();
            int nbMod = 0;
            while (entries.hasNext()) {
                Entry entry = (Entry)entries.next();
                if (ldifReader.hasError()) {
                    this.notifyErrorListener((Serializable)((Object)("Found an error while persing an entry : " + ldifReader.getError().getMessage())));
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        this.notifyErrorListener((Serializable)((Object)"Import failed..."));
                        throw new ToolCommandException("Import failed...");
                    }
                    this.notifyEntryAddFailedListener((Serializable)((Object)entry.getDn()));
                }
                if (this.changeEntry(entry, messageId++) == -1) {
                    if (!this.ignoreErrors) {
                        this.unbind(messageId);
                        this.notifyErrorListener((Serializable)((Object)"Import failed..."));
                        throw new ToolCommandException("Import failed...");
                    }
                    this.notifyEntryAddFailedListener((Serializable)((Object)entry.getDn()));
                } else {
                    ++nbMod;
                    this.notifyEntryAddedListener((Serializable)((Object)entry.getDn()));
                }
                if (nbMod % 10 == 0) {
                    this.notifyOutputListener(new Character('.'));
                }
                if (nbMod % 500 != 0) continue;
                this.notifyOutputListener((Serializable)((Object)("" + nbMod)));
            }
            long t1 = System.currentTimeMillis();
            this.notifyOutputListener((Serializable)((Object)"Done!"));
            this.notifyOutputListener((Serializable)((Object)(nbMod + " users changed in " + (t1 - t0) / 1000L + " seconds")));
        }
        this.unbind(messageId++);
    }

    private void notifyEntryAddedListener(Serializable o) {
        if (this.entryAddedListener != null) {
            this.entryAddedListener.notify(o);
        }
    }

    private void notifyEntryAddFailedListener(Serializable o) {
        if (this.entryAddFailedListener != null) {
            this.entryAddFailedListener.notify(o);
        }
    }

    @Override
    public void execute(Parameter[] params, ListenerParameter[] listeners) {
        this.processParameters(params);
        this.processListeners(listeners);
        try {
            this.execute();
        }
        catch (Exception e) {
            this.notifyExceptionListener(e);
        }
    }

    private void processListeners(ListenerParameter[] listeners) {
        ToolCommandListener entryAddFailedListener;
        ToolCommandListener entryAddedListener;
        ToolCommandListener exceptionListener;
        ToolCommandListener errorListener;
        HashMap<String, ToolCommandListener> parameters = new HashMap<String, ToolCommandListener>();
        for (int i = 0; i < listeners.length; ++i) {
            ListenerParameter parameter = listeners[i];
            parameters.put(parameter.getName(), parameter.getListener());
        }
        ToolCommandListener outputListener = (ToolCommandListener)parameters.get("ouputListener");
        if (outputListener != null) {
            this.outputListener = outputListener;
        }
        if ((errorListener = (ToolCommandListener)parameters.get("errorListener")) != null) {
            this.errorListener = errorListener;
        }
        if ((exceptionListener = (ToolCommandListener)parameters.get("exceptionListener")) != null) {
            this.exceptionListener = exceptionListener;
        }
        if ((entryAddedListener = (ToolCommandListener)parameters.get(ENTRYADDEDLISTENER_PARAMETER)) != null) {
            this.entryAddedListener = entryAddedListener;
        }
        if ((entryAddFailedListener = (ToolCommandListener)parameters.get(ENTRYADDFAILEDLISTENER_PARAMETER)) != null) {
            this.entryAddFailedListener = entryAddFailedListener;
        }
    }
}

