/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class FocusPoint {
    private String name;
    private FocusPoint parentFocusPoint;
    private static final String URI_SEPARATOR = "/";
    private static final String TITLE_SEPARATOR = "-";

    public FocusPoint(String name) {
        this.name = name;
    }

    public FocusPoint(String name, FocusPoint parentFocusPoint) {
        this(name);
        this.parentFocusPoint = parentFocusPoint;
    }

    public String getName() {
        return this.name;
    }

    public void setParentTrackPoint(FocusPoint parentFocusPoint) {
        this.parentFocusPoint = parentFocusPoint;
    }

    public FocusPoint getParentFocusPoint() {
        return this.parentFocusPoint;
    }

    public String getContentURI() {
        StringBuffer contentURIBuffer = new StringBuffer();
        this.getContentURI(contentURIBuffer, this);
        return contentURIBuffer.toString();
    }

    public String getContentTitle() {
        StringBuffer titleBuffer = new StringBuffer();
        this.getContentTitle(titleBuffer, this);
        return titleBuffer.toString();
    }

    private void getContentURI(StringBuffer contentURIBuffer, FocusPoint focusPoint) {
        FocusPoint parentFocuPoint = focusPoint.getParentFocusPoint();
        if (parentFocuPoint != null) {
            this.getContentURI(contentURIBuffer, parentFocuPoint);
        }
        contentURIBuffer.append(URI_SEPARATOR);
        contentURIBuffer.append(this.encode(focusPoint.getName()));
    }

    private String encode(String name) {
        if (name == null) {
            name = "";
        }
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private void getContentTitle(StringBuffer titleBuffer, FocusPoint focusPoint) {
        FocusPoint parentFocusPoint = focusPoint.getParentFocusPoint();
        if (parentFocusPoint != null) {
            this.getContentTitle(titleBuffer, parentFocusPoint);
            titleBuffer.append(TITLE_SEPARATOR);
        }
        titleBuffer.append(this.encode(focusPoint.getName()));
    }
}

