/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.apacheds;

import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.configuration.SyncConfiguration;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSchema;
import org.apache.directory.server.core.schema.bootstrap.NisSchema;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirectoryService
implements Service<DirectoryServiceConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryService.class);
    private DirectoryServiceConfiguration configuration;
    private Timer syncTimer;

    public DirectoryServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DirectoryServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<DirectoryServiceConfiguration> getConfigurationClass() {
        return DirectoryServiceConfiguration.class;
    }

    public void startService() throws Exception {
        Hashtable env = this.createContextEnv();
        if (this.configuration.isEmbeddedServerEnabled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting Embedded Directory Server...");
            }
            MutableServerStartupConfiguration cfg = new MutableServerStartupConfiguration();
            cfg.setAccessControlEnabled(this.configuration.isAccessControlEnabled());
            cfg.setAllowAnonymousAccess(this.configuration.isEmbeddedAnonymousAccess());
            cfg.setEnableNetworking(true);
            cfg.setLdapPort(this.configuration.getEmbeddedLdapPort());
            cfg.setLdapsPort(this.configuration.getEmbeddedLdapsPort());
            cfg.setEnableNtp(this.configuration.isEnableNtp());
            cfg.setEnableKerberos(this.configuration.isEnableKerberos());
            cfg.setEnableChangePassword(this.configuration.isEnableChangePassword());
            cfg.setWorkingDirectory(this.configuration.getEmbeddedWkDir());
            cfg.setLdifDirectory(this.configuration.getEmbeddedLDIFDir());
            cfg.setLdifFilters(this.addCustomLdifFilters());
            cfg.setBootstrapSchemas(this.addCustomBootstrapSchema(cfg.getBootstrapSchemas()));
            if (null != this.configuration.getEmbeddedCustomRootPartitionName() && this.configuration.getEmbeddedCustomRootPartitionName().length() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding custom root partition name: " + this.configuration.getEmbeddedCustomRootPartitionName());
                }
                Set pcfgs = this.addCustomPartition();
                cfg.setContextPartitionConfigurations(pcfgs);
            }
            env.putAll(cfg.toJndiEnvironment());
            new InitialDirContext(env);
            this.syncTimer = new Timer(true);
            this.syncTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DirectoryService.this.flushEmbeddedServerData();
                }
            }, 0L, 5000L);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("No Embedded directory server requested.  All directory access will be via remote LDAP interface.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Directory Environment:");
            Enumeration en = env.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                LOG.debug("    " + key + ":" + env.get(key));
            }
        }
    }

    private List addCustomLdifFilters() {
        ArrayList filters = new ArrayList();
        Hashtable ht = this.getPropertiesFromElement(this.configuration.getLdifFilters());
        Enumeration en = ht.elements();
        Class<?> clazz = null;
        while (en.hasMoreElements()) {
            try {
                clazz = Class.forName((String)en.nextElement());
                filters.add(clazz.newInstance());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error(e.toString());
            }
        }
        return filters;
    }

    private Set<BootstrapSchema> addCustomBootstrapSchema(Set<BootstrapSchema> schema) {
        schema.add((BootstrapSchema)new NisSchema());
        return schema;
    }

    private void addAdditionalEnv(Hashtable env) {
        Hashtable ht = this.getPropertiesFromElement(this.configuration.getAdditionalEnv());
        Enumeration en = ht.keys();
        String key = null;
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            env.put(key, ht.get(key));
        }
    }

    private Hashtable createContextEnv() {
        Properties env = new Properties();
        this.addAdditionalEnv(env);
        ((Hashtable)env).put("java.naming.provider.url", this.configuration.getContextProviderURL());
        ((Hashtable)env).put("java.naming.factory.initial", ServerContextFactory.class.getName());
        ((Hashtable)env).put("java.naming.security.authentication", this.configuration.getContextSecurityAuthentication());
        ((Hashtable)env).put("java.naming.security.principal", this.configuration.getContextSecurityPrincipal());
        ((Hashtable)env).put("java.naming.security.credentials", this.configuration.getContextSecurityCredentials());
        if (this.configuration.isEmbeddedServerEnabled()) {
            ((Hashtable)env).put(Configuration.JNDI_KEY, new SyncConfiguration());
        }
        return env;
    }

    private Set addCustomPartition() throws NamingException {
        HashSet<MutablePartitionConfiguration> pcfgs = new HashSet<MutablePartitionConfiguration>();
        MutablePartitionConfiguration pcfg = new MutablePartitionConfiguration();
        String[] nameParts = this.configuration.getEmbeddedCustomRootPartitionName().split(",");
        StringBuffer partitionName = new StringBuffer();
        for (int i = 0; i < nameParts.length; ++i) {
            int idx = nameParts[i].indexOf(61);
            if (i > 0) {
                partitionName.append('_');
            }
            partitionName.append(idx > 0 ? nameParts[i].substring(idx + 1) : nameParts[i]);
        }
        pcfg.setName(partitionName.toString());
        pcfg.setSuffix(this.configuration.getEmbeddedCustomRootPartitionName());
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("ou");
        indexedAttrs.add("dc");
        indexedAttrs.add("cn");
        indexedAttrs.add("macAddress");
        indexedAttrs.add("ipHostNumber");
        indexedAttrs.add("objectClass");
        pcfg.setIndexedAttributes(indexedAttrs);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("objectClass");
        attr.add("top");
        attr.add("domain");
        attr.add("extensibleObject");
        attrs.put(attr);
        attr = new BasicAttribute("dc");
        attr.add(this.configuration.getEmbeddedCustomRootPartitionName());
        attrs.put(attr);
        pcfg.setContextEntry((Attributes)attrs);
        pcfgs.add(pcfg);
        return pcfgs;
    }

    public void stopService() throws Exception {
        if (this.configuration.isEmbeddedServerEnabled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Stopping Embedded Directory Server...");
            }
            if (null != this.syncTimer) {
                this.syncTimer.cancel();
                this.syncTimer = null;
            }
            ShutdownConfiguration cfg = new ShutdownConfiguration();
            Hashtable env = this.createContextEnv();
            env.putAll(cfg.toJndiEnvironment());
            new InitialDirContext(env);
            for (int retries = 0; retries <= 90; ++retries) {
                LOG.info("Verifying directory service shutdown complete...");
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                try {
                    ServerSocket socket = new ServerSocket(this.configuration.getEmbeddedLdapPort());
                    socket.close();
                    return;
                }
                catch (Exception e) {
                    LOG.info("Directory service still alive. Waiting for shutdown...");
                    LOG.debug("Exception trying to acquire the server socket", (Throwable)e);
                    continue;
                }
            }
        }
    }

    public DirContext openDirContext() throws NamingException {
        Hashtable env = this.createContextEnv();
        return new InitialDirContext(env);
    }

    public String changedEmbeddedAdminPassword(String oldPassword, String newPassword) {
        if (this.configuration.isEmbeddedServerEnabled()) {
            if (this.configuration.getContextSecurityCredentials().equals(oldPassword)) {
                ModificationItem[] mods = new ModificationItem[1];
                BasicAttribute password = new BasicAttribute("userpassword", newPassword);
                mods[0] = new ModificationItem(2, password);
                try {
                    DirContext dc = this.openDirContext();
                    dc.modifyAttributes("", mods);
                    dc.close();
                }
                catch (NamingException e) {
                    String msg = "Failed modifying directory password attribute: " + e;
                    if (LOG.isErrorEnabled()) {
                        LOG.error(msg);
                    }
                    return msg;
                }
                this.configuration.setContextSecurityCredentials(newPassword);
                return "Password change successful.";
            }
            return "Invalid oldPassword given.";
        }
        String msg = "Unable to change password as embedded server is not enabled.";
        if (LOG.isWarnEnabled()) {
            LOG.warn("Unable to change password as embedded server is not enabled.");
        }
        return "Unable to change password as embedded server is not enabled.";
    }

    public boolean flushEmbeddedServerData() {
        if (this.configuration.isEmbeddedServerEnabled()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Syncing Embedded Directory Server...");
                }
                SyncConfiguration cfg = new SyncConfiguration();
                Hashtable env = this.createContextEnv();
                env.putAll(cfg.toJndiEnvironment());
                if (LOG.isDebugEnabled()) {
                    LOG.info("Directory Properties:");
                    Enumeration en = env.keys();
                    while (en.hasMoreElements()) {
                        Object key = en.nextElement();
                        LOG.debug("    " + key + ":" + env.get(key));
                    }
                }
                new InitialDirContext(env);
                return true;
            }
            catch (NamingException e) {
                LOG.error("Can't flush server", (Throwable)e);
            }
        } else {
            LOG.warn("Unable to flush as embedded server is not enabled.");
        }
        return false;
    }

    private Hashtable getPropertiesFromElement(Element element) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (element != null && element.getFirstChild() instanceof Element) {
            element = (Element)element.getFirstChild();
        }
        if (null != element) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Adding custom configuration elements:");
            }
            NodeList nl = element.getChildNodes();
            Node el = null;
            for (int ii = 0; ii < nl.getLength(); ++ii) {
                el = nl.item(ii);
                String val = null;
                String name = null;
                if (el.getNodeType() != 1) continue;
                name = el.getAttributes().getNamedItem("name").getNodeValue();
                NodeList vnl = el.getChildNodes();
                for (int jj = 0; jj < vnl.getLength(); ++jj) {
                    el = vnl.item(jj);
                    if (el.getNodeType() != 3) continue;
                    val = el.getNodeValue();
                    break;
                }
                if (null == name || null == val) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("    " + name + ": " + val);
                }
                ht.put(name, val);
                break;
            }
        }
        return ht;
    }
}

