/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeTemplateInstallStep
extends AbstractInstallStep {
    private static final Logger LOG = LoggerFactory.getLogger(HomeTemplateInstallStep.class);

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        block38: {
            Path targetDirectory = installContext.getManagerHome().getLocation().toPath();
            URI uri = this.getClass().getResource("/home_template").toURI();
            if (uri.getScheme().equals("jar")) {
                String[] segments = uri.toString().split("!");
                if (segments.length == 2) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        this.copyTemplate(fileSystem.getPath("/home_template", new String[0]), targetDirectory);
                    }
                }
                try (FileSystem intermediate = FileSystems.newFileSystem(URI.create(segments[0]), Collections.emptyMap());){
                    Path nestedPath = intermediate.getPath(segments[1], new String[0]);
                    Path tempFile = Files.createTempFile("otc-nested-", ".jar", new FileAttribute[0]);
                    Files.copy(nestedPath, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    try (FileSystem fileSystem = FileSystems.newFileSystem(tempFile, null);){
                        this.copyTemplate(fileSystem.getPath("/home_template", new String[0]), targetDirectory);
                        break block38;
                    }
                }
            }
            this.copyTemplate(Paths.get(uri), targetDirectory);
        }
    }

    private void copyTemplate(Path templateBasePath, Path targetDirectory) throws IOException {
        Files.walk(templateBasePath, 200, new FileVisitOption[0]).filter(path -> !path.equals(templateBasePath)).forEach(templatePath -> {
            Path relativePath = templateBasePath.relativize((Path)templatePath);
            Path target = targetDirectory.resolve(relativePath.toString());
            if (Files.isDirectory(templatePath, new LinkOption[0])) {
                LOG.info(String.format("[DIR] %-40s -> %-40s", relativePath, target));
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create directory " + target, e);
                }
            }
            LOG.info(String.format("[CP ] %-40s -> %-40s", relativePath, target));
            try {
                Files.copy(templatePath, target, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to copy template file " + relativePath, e);
            }
        });
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_HOMETEMPLATEINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }
}

