/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;

public class RequiredPackagesInstallStep
extends AbstractInstallStep {
    private final InstallableDistribution installableDistribution;
    private ListenableProgressFuture<PackageManagerOperationReport> future = null;

    public RequiredPackagesInstallStep(InstallableDistribution installableDistribution) {
        this.installableDistribution = installableDistribution;
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_REQUIREDPACKAGESINSTALLSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        if (this.future == null) {
            return 0.0;
        }
        return this.future.getProgress();
    }

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        PackageManager packageManager = installContext.getPackageManager();
        Collection installablePackages = packageManager.getInstallablePackages();
        this.log.info("Installable packages:");
        installablePackages.forEach(pkg -> this.log.info(" - {}", (Object)pkg.getName()));
        List minimumPackages = this.installableDistribution.getMinimumPackages();
        List<Optional<Package>> resolvedPackages = this.resolvePackages(installablePackages, minimumPackages);
        ArrayList<String> missingPackages = new ArrayList<String>();
        for (int i = 0; i < minimumPackages.size(); ++i) {
            if (resolvedPackages.get(i).isPresent()) {
                Package p2 = resolvedPackages.get(i).get();
                this.log.info("Installing package '{}', version '{}'", (Object)p2.getName(), (Object)p2.getVersion());
                continue;
            }
            Iterator packageName = (String)minimumPackages.get(i);
            missingPackages.add((String)((Object)packageName));
            this.log.error("No package found with name '{}'", (Object)packageName);
        }
        this.installableDistribution.getAdditionalPackages().forEach(p -> {
            Optional<Package> packageOptional = this.resolvePackage(installablePackages, (Package)p);
            if (packageOptional.isPresent()) {
                resolvedPackages.add(packageOptional);
                this.log.info("Installing package '{}', version '{}'", (Object)p.getName(), (Object)p.getVersion());
            } else {
                missingPackages.add(p.getName());
                this.log.error("No package found with name '{}', version '{}'", (Object)p.getName(), (Object)p.getVersion());
            }
        });
        if (missingPackages.size() > 0) {
            throw new IllegalStateException("Missing required packages: " + missingPackages);
        }
        this.log.info("Resolving dependencies");
        PackageManagerOperation operation = packageManager.createOperation();
        resolvedPackages.stream().map(Optional::get).forEach(arg_0 -> ((PackageManagerOperation)operation).install(arg_0));
        operation.resolve();
        if (!operation.getConflicts().isEmpty()) {
            for (PackageManagerOperation.PackageConflict conflict : operation.getConflicts()) {
                this.log.error("Found conflict: {} conflicts {}", (Object)conflict.getSource().toStringWithNameAndVersion(), (Object)conflict.getConflicting().toStringWithNameAndVersion());
            }
            throw new IllegalStateException("Detected conflicting packages.");
        }
        if (!operation.getUnresolved().isEmpty()) {
            for (PackageManagerOperation.UnresolvedDependency unresolvedDependency : operation.getUnresolved()) {
                this.log.error("Found unresolved {} requires '{}'", (Object)unresolvedDependency.getSource().toStringWithNameAndVersion(), (Object)unresolvedDependency.getMissing());
            }
            throw new IllegalStateException("Detected unresolved packages.");
        }
        if (!operation.getSuggested().isEmpty()) {
            for (Package suggestedPackage : operation.getSuggested()) {
                this.log.error("Found suggested package for installation: {}", (Object)suggestedPackage.toStringWithNameAndVersion());
            }
            throw new IllegalStateException("Detected suggested packages.");
        }
        List steps = operation.getInstallPlan().getSteps();
        StringBuilder sb = new StringBuilder();
        operation.getInstallPlan().getPackageInstallSteps().forEach(step -> sb.append("  - ").append(step.getPackage().getName()).append("\n"));
        this.log.info("\n\n==============================================\n starting OS install\n \n The final package list for the installation:\n" + sb.toString() + "==============================================\n\n");
        this.future = packageManager.execute(operation);
        this.future.get();
    }

    protected List<Optional<Package>> resolvePackages(Collection<Package> installablePackages, List<String> minimumPackages) {
        return minimumPackages.stream().map(pkgName -> installablePackages.stream().filter(p -> pkgName.equals(p.getName())).sorted((p1, p2) -> p2.getVersion().compareTo((Object)p1.getVersion())).findFirst()).collect(Collectors.toList());
    }

    protected Optional<Package> resolvePackage(Collection<Package> installablePackages, Package pkg) {
        if (pkg.getVersion() == null) {
            return installablePackages.stream().filter(p -> pkg.getName().equals(p.getName())).sorted((p1, p2) -> p2.getVersion().compareTo((Object)p1.getVersion())).findFirst();
        }
        return installablePackages.stream().filter(p -> pkg.getName().equals(p.getName()) && pkg.getVersion().equals((Object)p.getVersion())).findFirst();
    }
}

