/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.model;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.openthinclient.db.DatabaseConfiguration;

public class DatabaseModel {
    private final MySQLConfiguration mySQLConfiguration;
    @NotNull
    private DatabaseConfiguration.DatabaseType type = DatabaseConfiguration.DatabaseType.H2;

    public DatabaseModel() {
        this.mySQLConfiguration = new MySQLConfiguration();
    }

    public static void apply(DatabaseModel model, DatabaseConfiguration target) {
        target.setType(model.getType());
        if (model.getType() == DatabaseConfiguration.DatabaseType.MYSQL) {
            MySQLConfiguration mySQLConfiguration = model.getMySQLConfiguration();
            target.setUrl("jdbc:mysql://" + mySQLConfiguration.getHostname() + ":" + mySQLConfiguration.getPort() + "/" + mySQLConfiguration.getDatabase());
            target.setTimezone(mySQLConfiguration.getTimezone());
            target.setUsername(mySQLConfiguration.getUsername());
            target.setPassword(mySQLConfiguration.getPassword());
        } else if (model.getType() == DatabaseConfiguration.DatabaseType.APACHE_DERBY) {
            target.setUrl(null);
            target.setUsername("sa");
            target.setPassword("");
        } else if (model.getType() == DatabaseConfiguration.DatabaseType.H2) {
            target.setUrl(null);
            target.setUsername("sa");
            target.setPassword("");
        } else {
            throw new IllegalArgumentException("Unsupported type of database " + model.getType());
        }
    }

    public DatabaseConfiguration.DatabaseType getType() {
        return this.type;
    }

    public void setType(DatabaseConfiguration.DatabaseType type) {
        this.type = type;
    }

    public MySQLConfiguration getMySQLConfiguration() {
        return this.mySQLConfiguration;
    }

    public static class MySQLConfiguration {
        @NotNull
        private String hostname = "localhost";
        @NotNull
        private String username = "root";
        private String password;
        @NotNull
        private String database = "openthinclient";
        @Min(value=1L)
        @Max(value=65535L)
        private @Min(value=1L) @Max(value=65535L) int port = 3306;
        @NotNull
        private String timezone = "";

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }
    }
}

