/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.model;

import com.vaadin.ui.UI;
import java.io.File;
import org.openthinclient.advisor.check.AbstractCheck;
import org.openthinclient.advisor.check.CheckExecutionEngine;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.openthinclient.advisor.check.CheckManagerHomeDirectory;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.model.CheckStatus;

public class ManagerHomeModel {
    public static final String DEFAULT_PATH = "/opt/openthinclient-home";
    private final ManagerHomeFactory factory;
    private final CheckExecutionEngine checkExecutionEngine;
    private File managerHomePath;
    private CheckStatus checkStatusManagerHomeDirectory;

    public ManagerHomeModel(ManagerHomeFactory factory, CheckExecutionEngine checkExecutionEngine) {
        this.factory = factory;
        this.checkExecutionEngine = checkExecutionEngine;
        this.managerHomePath = factory.getManagerHomeDirectory();
    }

    public boolean isManagerHomeChangeable() {
        return !this.factory.isManagerHomeDefinedAsSystemProperty();
    }

    public boolean isManagerHomeSpecified() {
        return this.factory.getManagerHomeDirectory() != null;
    }

    public boolean isManagerHomeValidated() {
        return this.isManagerHomeSpecified() && this.checkStatusManagerHomeDirectory != null && this.checkStatusManagerHomeDirectory.isFinished();
    }

    public boolean isManagerHomeValid() {
        return this.isManagerHomeValidated() && (this.checkStatusManagerHomeDirectory.getResultType() == CheckExecutionResult.CheckResultType.SUCCESS || this.checkStatusManagerHomeDirectory.getResultType() == CheckExecutionResult.CheckResultType.WARNING);
    }

    public CheckStatus runCheck() {
        if (!this.isManagerHomeSpecified()) {
            throw new IllegalStateException("No manager home directory has been specified");
        }
        this.checkStatusManagerHomeDirectory = new CheckStatus((AbstractCheck<?>)new CheckManagerHomeDirectory(UI.getCurrent().getLocale(), this.factory.getManagerHomeDirectory()));
        this.checkStatusManagerHomeDirectory.executeOn(this.checkExecutionEngine);
        return this.checkStatusManagerHomeDirectory;
    }

    public File getManagerHomePath() {
        return this.managerHomePath;
    }

    public void setManagerHomePath(File managerHomePath) {
        this.managerHomePath = managerHomePath;
    }
}

