/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import com.vaadin.event.UIEvents;
import com.vaadin.ui.Label;
import java.util.List;
import org.openthinclient.wizard.model.CheckStatus;
import org.openthinclient.wizard.ui.steps.AbstractStep;
import org.vaadin.teemu.wizards.Wizard;

public abstract class AbstractCheckExecutingStep
extends AbstractStep {
    protected final Wizard wizard;
    private final UIEvents.PollListener pollListener = this::onPoll;

    public AbstractCheckExecutingStep(Wizard wizard) {
        this.wizard = wizard;
    }

    protected void updateStatusLabels() {
        this.getStatusLabels().forEach(CheckStatusLabel::update);
    }

    protected abstract List<CheckStatusLabel> getStatusLabels();

    protected void runChecks() {
        this.wizard.getUI().setPollInterval(100);
        this.wizard.getUI().addPollListener(this.pollListener);
        this.onRunChecks();
        this.updateStatusLabels();
    }

    protected abstract void onRunChecks();

    private void onPoll(UIEvents.PollEvent pollEvent) {
        this.updateStatusLabels();
        if (this.isChecksFinished()) {
            this.wizard.getUI().removePollListener(this.pollListener);
            this.wizard.getUI().setPollInterval(-1);
            this.onChecksFinished();
        }
    }

    protected abstract void onChecksFinished();

    protected abstract boolean isChecksFinished();

    protected static final class CheckStatusLabel
    extends Label {
        private final CheckStatus checkStatus;

        public CheckStatusLabel(CheckStatus checkStatus) {
            this.checkStatus = checkStatus;
            this.setValue(checkStatus.getCheck().getName());
        }

        public void update() {
            if (this.checkStatus.getResultType() != null) {
                switch (this.checkStatus.getResultType()) {
                    case SUCCESS: {
                        this.setStyleName("success");
                        break;
                    }
                    case WARNING: {
                        this.setStyleName("warning");
                        break;
                    }
                    case FAILED: {
                        this.setStyleName("failure");
                    }
                }
            }
        }
    }
}

