/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.steps.AbstractStep;
import org.vaadin.teemu.wizards.WizardStep;

public class IntroStep
extends AbstractStep
implements WizardStep {
    private SystemSetupModel systemSetupModel;

    public IntroStep(SystemSetupModel systemSetupModel) {
        this.systemSetupModel = systemSetupModel;
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_INTROSTEP_TITLE, new Object[0]);
    }

    @Override
    public Component getContent() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        layout.setSpacing(true);
        Image logoImage = new Image();
        logoImage.setSource((Resource)new ThemeResource("img/OpenThinClient-logo.svg.png"));
        layout.addComponent((Component)logoImage);
        layout.setComponentAlignment((Component)logoImage, Alignment.MIDDLE_CENTER);
        layout.addComponent((Component)this.createLabelHuge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_INTROSTEP_TITLE, new Object[0])));
        layout.addComponent((Component)this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_INTROSTEP_TEXT, new Object[0])));
        if (!InstallationDirectoryUtil.isInstallationDirectoryEmpty((File)this.systemSetupModel.getFactory().getManagerHomeDirectory())) {
            Label note = this.createLabelLarge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_INTROSTEP_CLEAN_MANAGERHOME_NOTE, new Object[]{this.systemSetupModel.getFactory().getManagerHomeDirectory()}), ContentMode.HTML);
            note.addStyleName("color-red");
            layout.addComponent((Component)note);
        }
        return layout;
    }

    public boolean onAdvance() {
        return true;
    }

    public boolean onBack() {
        return true;
    }
}

