/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.text.MessageFormat;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiropLogger {
    private final Logger readLogger;
    private final Logger writeLogger;
    public static DiropLogger LOG = new DiropLogger(DiropLogger.class.getPackage().getName() + ".DIROP");

    private DiropLogger(String prefix) {
        this.readLogger = LoggerFactory.getLogger((String)(prefix + ".READ"));
        this.writeLogger = LoggerFactory.getLogger((String)(prefix + ".WRITE"));
    }

    public boolean isReadEnabled() {
        return this.readLogger.isDebugEnabled();
    }

    public boolean isWriteEnabled() {
        return this.writeLogger.isDebugEnabled();
    }

    public void logModify(Name dn, ModificationItem[] mods, String comment) {
        if (this.isWriteEnabled()) {
            this.logModify(dn.toString(), mods, comment);
        }
    }

    public void logModify(String dn, ModificationItem[] mods, String comment) {
        if (this.isWriteEnabled()) {
            try {
                this.writeLogger.debug("# " + comment);
                this.writeLogger.debug("dn: " + dn);
                this.writeLogger.debug("changetype: modify");
                for (ModificationItem mi : mods) {
                    String id = mi.getAttribute().getID();
                    switch (mi.getModificationOp()) {
                        case 1: {
                            this.writeLogger.debug("add: " + id);
                            break;
                        }
                        case 3: {
                            this.writeLogger.debug("remove: " + id);
                            break;
                        }
                        case 2: {
                            this.writeLogger.debug("replace: " + id);
                        }
                    }
                    NamingEnumeration<?> e = mi.getAttribute().getAll();
                    while (e.hasMore()) {
                        this.writeLogger.debug(id + ": " + e.next());
                    }
                    this.writeLogger.debug("-");
                }
                this.writeLogger.debug("");
            }
            catch (Exception e) {
                this.writeLogger.error("Can't log operation: ", (Throwable)e);
            }
        }
    }

    public void logAdd(Name dn, Attributes attributes, String comment) {
        if (this.isWriteEnabled()) {
            this.logAdd(dn.toString(), attributes, comment);
        }
    }

    public void logAdd(String dn, Attributes attributes, String comment) {
        if (this.isWriteEnabled()) {
            try {
                this.writeLogger.debug("# " + comment);
                this.writeLogger.debug("dn: " + dn);
                this.writeLogger.debug("changetype: add");
                this.logAttributes(attributes);
                this.writeLogger.debug("");
            }
            catch (NamingException e) {
                this.writeLogger.error("Can't log operation: ", (Throwable)e);
            }
        }
    }

    public void logDelete(Name dn, String comment) {
        if (this.isWriteEnabled()) {
            this.logDelete(dn.toString(), comment);
        }
    }

    public void logDelete(String dn, String comment) {
        if (this.isWriteEnabled()) {
            this.writeLogger.debug("# " + comment);
            this.writeLogger.debug("dn: " + dn);
            this.writeLogger.debug("changetype: delete");
            this.writeLogger.debug("");
        }
    }

    private void logAttributes(Attributes attributes) throws NamingException {
        NamingEnumeration<? extends Attribute> e = attributes.getAll();
        while (e.hasMore()) {
            Attribute a = e.next();
            String id = a.getID();
            NamingEnumeration<?> f = a.getAll();
            while (f.hasMore()) {
                this.writeLogger.debug(id + ": " + f.next());
            }
        }
    }

    public void logModRDN(Name oldName, Name newName, String comment) {
        if (this.isWriteEnabled()) {
            this.writeLogger.debug("# " + comment);
            this.writeLogger.debug("dn: " + oldName.toString());
            this.writeLogger.debug("changetype: modrdn");
            this.writeLogger.debug("newrdn: " + newName.get(newName.size() - 1));
            this.writeLogger.debug("");
        }
    }

    public void logReadComment(String pattern, Object ... args) {
        if (this.isReadEnabled()) {
            this.readLogger.debug(MessageFormat.format("# " + pattern, args));
        }
    }

    public void logGetAttributes(Name name, String[] attributes, String comment) {
        if (this.isReadEnabled()) {
            this.logGetAttributes(name.toString(), attributes, comment);
        }
    }

    public void logGetAttributes(String dn, String[] attributes, String comment) {
        if (this.isReadEnabled()) {
            this.readLogger.debug("# GET ATTRIBUTES: " + comment);
            this.readLogger.debug("# dn: " + dn);
            if (null != attributes) {
                StringBuilder sb = new StringBuilder("# fetching only: ");
                for (String s : attributes) {
                    sb.append(s).append(" ");
                }
                this.readLogger.debug(sb.toString());
            }
            this.readLogger.debug("");
        }
    }

    public void logSearch(String dn, String filter, Object[] filterArgs, SearchControls sc, String comment) {
        if (this.isReadEnabled()) {
            this.readLogger.debug("# SEARCH: " + comment);
            this.readLogger.debug("# base: " + dn);
            this.readLogger.debug("# filter: " + filter);
            if (null != filterArgs) {
                for (Object arg : filterArgs) {
                    this.readLogger.debug("#    " + arg);
                }
            }
            this.readLogger.debug("# scope: " + (sc.getSearchScope() == 0 ? "object" : (sc.getSearchScope() == 1 ? "onelevel" : "sub")) + " timelimit: " + sc.getTimeLimit() + " countlimit: " + sc.getCountLimit());
            this.readLogger.debug("");
        }
    }
}

