/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.net.UnknownHostException;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.RMICacheManagerPeerListener;
import net.sf.ehcache.util.PropertyUtil;

public final class RMICacheManagerPeerListenerFactory
extends CacheManagerPeerListenerFactory {
    public static final Integer DEFAULT_SOCKET_TIMEOUT_MILLIS = new Integer(120000);
    private static final String HOSTNAME = "hostName";
    private static final String PORT = "port";
    private static final String SOCKET_TIMEOUT_MILLIS = "socketTimeoutMillis";

    public final CacheManagerPeerListener createCachePeerListener(CacheManager cacheManager, Properties properties) throws CacheException {
        String hostName = PropertyUtil.extractAndLogProperty(HOSTNAME, properties);
        String portString = PropertyUtil.extractAndLogProperty(PORT, properties);
        Integer port = new Integer(portString);
        String socketTimeoutMillisString = PropertyUtil.extractAndLogProperty(SOCKET_TIMEOUT_MILLIS, properties);
        Integer socketTimeoutMillis = socketTimeoutMillisString == null || socketTimeoutMillisString.length() == 0 ? DEFAULT_SOCKET_TIMEOUT_MILLIS : new Integer(socketTimeoutMillisString);
        try {
            return new RMICacheManagerPeerListener(hostName, port, cacheManager, socketTimeoutMillis);
        }
        catch (UnknownHostException e) {
            throw new CacheException("Unable to create CacheManagerPeerListener. Initial cause was " + e.getMessage(), e);
        }
    }
}

